# automatically generated by the FlatBuffers compiler, do not modify

# namespace: flatbuf

import flatbuffers
from flatbuffers.compat import import_numpy
np = import_numpy()

# ----------------------------------------------------------------------
# EXPERIMENTAL: Data structures for sparse tensors
# Coordinate (COO) format of sparse tensor index.
#
# COO's index list are represented as a NxM matrix,
# where N is the number of non-zero values,
# and M is the number of dimensions of a sparse tensor.
#
# indicesBuffer stores the location and size of the data of this indices
# matrix.  The value type and the stride of the indices matrix is
# specified in indicesType and indicesStrides fields.
#
# For example, let X be a 2x3x4x5 tensor, and it has the following
# 6 non-zero values:
# ```text
#   X[0, 1, 2, 0] := 1
#   X[1, 1, 2, 3] := 2
#   X[0, 2, 1, 0] := 3
#   X[0, 1, 3, 0] := 4
#   X[0, 1, 2, 1] := 5
#   X[1, 2, 0, 4] := 6
# ```
# In COO format, the index matrix of X is the following 4x6 matrix:
# ```text
#   [[0, 0, 0, 0, 1, 1],
#    [1, 1, 1, 2, 1, 2],
#    [2, 2, 3, 1, 2, 0],
#    [0, 1, 0, 0, 3, 4]]
# ```
# When isCanonical is true, the indices is sorted in lexicographical order
# (row-major order), and it does not have duplicated entries.  Otherwise,
# the indices may not be sorted, or may have duplicated entries.
class SparseTensorIndexCOO(object):
    __slots__ = ['_tab']

    @classmethod
    def GetRootAs(cls, buf, offset=0):
        n = flatbuffers.encode.Get(flatbuffers.packer.uoffset, buf, offset)
        x = SparseTensorIndexCOO()
        x.Init(buf, n + offset)
        return x

    @classmethod
    def GetRootAsSparseTensorIndexCOO(cls, buf, offset=0):
        """This method is deprecated. Please switch to GetRootAs."""
        return cls.GetRootAs(buf, offset)
    # SparseTensorIndexCOO
    def Init(self, buf, pos):
        self._tab = flatbuffers.table.Table(buf, pos)

    # The type of values in indicesBuffer
    # SparseTensorIndexCOO
    def IndicesType(self):
        o = flatbuffers.number_types.UOffsetTFlags.py_type(self._tab.Offset(4))
        if o != 0:
            x = self._tab.Indirect(o + self._tab.Pos)
            from vastdb.vast_flatbuf.org.apache.arrow.flatbuf.Int import Int
            obj = Int()
            obj.Init(self._tab.Bytes, x)
            return obj
        return None

    # Non-negative byte offsets to advance one value cell along each dimension
    # If omitted, default to row-major order (C-like).
    # SparseTensorIndexCOO
    def IndicesStrides(self, j):
        o = flatbuffers.number_types.UOffsetTFlags.py_type(self._tab.Offset(6))
        if o != 0:
            a = self._tab.Vector(o)
            return self._tab.Get(flatbuffers.number_types.Int64Flags, a + flatbuffers.number_types.UOffsetTFlags.py_type(j * 8))
        return 0

    # SparseTensorIndexCOO
    def IndicesStridesAsNumpy(self):
        o = flatbuffers.number_types.UOffsetTFlags.py_type(self._tab.Offset(6))
        if o != 0:
            return self._tab.GetVectorAsNumpy(flatbuffers.number_types.Int64Flags, o)
        return 0

    # SparseTensorIndexCOO
    def IndicesStridesLength(self):
        o = flatbuffers.number_types.UOffsetTFlags.py_type(self._tab.Offset(6))
        if o != 0:
            return self._tab.VectorLen(o)
        return 0

    # SparseTensorIndexCOO
    def IndicesStridesIsNone(self):
        o = flatbuffers.number_types.UOffsetTFlags.py_type(self._tab.Offset(6))
        return o == 0

    # The location and size of the indices matrix's data
    # SparseTensorIndexCOO
    def IndicesBuffer(self):
        o = flatbuffers.number_types.UOffsetTFlags.py_type(self._tab.Offset(8))
        if o != 0:
            x = o + self._tab.Pos
            from vastdb.vast_flatbuf.org.apache.arrow.flatbuf.Buffer import Buffer
            obj = Buffer()
            obj.Init(self._tab.Bytes, x)
            return obj
        return None

    # This flag is true if and only if the indices matrix is sorted in
    # row-major order, and does not have duplicated entries.
    # This sort order is the same as of Tensorflow's SparseTensor,
    # but it is inverse order of SciPy's canonical coo_matrix
    # (SciPy employs column-major order for its coo_matrix).
    # SparseTensorIndexCOO
    def IsCanonical(self):
        o = flatbuffers.number_types.UOffsetTFlags.py_type(self._tab.Offset(10))
        if o != 0:
            return bool(self._tab.Get(flatbuffers.number_types.BoolFlags, o + self._tab.Pos))
        return False

def Start(builder): builder.StartObject(4)
def SparseTensorIndexCOOStart(builder):
    """This method is deprecated. Please switch to Start."""
    return Start(builder)
def AddIndicesType(builder, indicesType): builder.PrependUOffsetTRelativeSlot(0, flatbuffers.number_types.UOffsetTFlags.py_type(indicesType), 0)
def SparseTensorIndexCOOAddIndicesType(builder, indicesType):
    """This method is deprecated. Please switch to AddIndicesType."""
    return AddIndicesType(builder, indicesType)
def AddIndicesStrides(builder, indicesStrides): builder.PrependUOffsetTRelativeSlot(1, flatbuffers.number_types.UOffsetTFlags.py_type(indicesStrides), 0)
def SparseTensorIndexCOOAddIndicesStrides(builder, indicesStrides):
    """This method is deprecated. Please switch to AddIndicesStrides."""
    return AddIndicesStrides(builder, indicesStrides)
def StartIndicesStridesVector(builder, numElems): return builder.StartVector(8, numElems, 8)
def SparseTensorIndexCOOStartIndicesStridesVector(builder, numElems):
    """This method is deprecated. Please switch to Start."""
    return StartIndicesStridesVector(builder, numElems)
def AddIndicesBuffer(builder, indicesBuffer): builder.PrependStructSlot(2, flatbuffers.number_types.UOffsetTFlags.py_type(indicesBuffer), 0)
def SparseTensorIndexCOOAddIndicesBuffer(builder, indicesBuffer):
    """This method is deprecated. Please switch to AddIndicesBuffer."""
    return AddIndicesBuffer(builder, indicesBuffer)
def AddIsCanonical(builder, isCanonical): builder.PrependBoolSlot(3, isCanonical, 0)
def SparseTensorIndexCOOAddIsCanonical(builder, isCanonical):
    """This method is deprecated. Please switch to AddIsCanonical."""
    return AddIsCanonical(builder, isCanonical)
def End(builder): return builder.EndObject()
def SparseTensorIndexCOOEnd(builder):
    """This method is deprecated. Please switch to End."""
    return End(builder)