## cdk8s-grafana

cdk8s-grafana is a library that lets you easily define a Grafana service for
your kubernetes cluster along with associated dashboards and datasources, using
a high level API.

### Usage

To apply the resources generated by this construct, the Grafana operator must be
installed on your cluster. See
<https://operatorhub.io/operator/grafana-operator> for full installation
instructions.

The following will define a Grafana cluster connected to a Prometheus
datasource:

```typescript
import { Grafana } from 'cdk8s-grafana';

// inside your chart:
const grafana = new Grafana(this, 'my-grafana', {
  defaultDataSource: {
    name: 'Prometheus',
    type: 'prometheus',
    access: 'proxy',
    url: 'http://prometheus-service:9090',
  }
});
```

Basic aspects of a dashboard can be customized:

```typescript
const github = grafana.addDatasource('github', ...);
const dashboard = grafana.addDashboard('my-dashboard', { 
  title: 'My Dashboard',
  refreshRate: Duration.seconds(10),
  timeRange: Duration.hours(6), // show metrics from now-6h to now
  plugins: [
    {
      name: 'grafana-piechart-panel',
      version: '1.3.6',
    }
  ],
});
```

Note: the kubernetes grafana operator only supports one Grafana instance per
namespace (see https://github.com/grafana-operator/grafana-operator/issues/174).
This may require specifying namespaces explicitly, e.g.:

```typescript
const devGrafana = new Grafana(this, 'my-grafana', {
  namespace: 'dev',
});
const prodGrafana = new Grafana(this, 'my-grafana', {
  namespace: 'prod',
});
```

The grafana operator must be installed in each namespace for the resources in
that namespace to be recognized.

## Security

See [CONTRIBUTING](CONTRIBUTING.md#security-issue-notifications) for more
information.

## License

This project is licensed under the Apache-2.0 License.

