"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Grafana = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const dashboard_1 = require("./dashboard");
const datasource_1 = require("./datasource");
const grafana_1 = require("./imports/grafana");
/**
 * A Grafana instance.
 *
 * @stability stable
 */
class Grafana extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        super(scope, id);
        this.labels = (_b = props.labels) !== null && _b !== void 0 ? _b : { app: 'grafana' };
        this.dataSources = [];
        this.dashboards = [];
        this.namespace = props.namespace;
        const baseImage = (_c = props.image) !== null && _c !== void 0 ? _c : 'public.ecr.aws/ubuntu/grafana:latest';
        const ingress = (_d = props.ingress) !== null && _d !== void 0 ? _d : true;
        const serviceType = (_e = props.serviceType) !== null && _e !== void 0 ? _e : 'ClusterIP';
        const adminUser = (_f = props.adminUser) !== null && _f !== void 0 ? _f : 'root';
        const adminPassword = (_g = props.adminPassword) !== null && _g !== void 0 ? _g : 'secret';
        const requireLogin = (_h = props.requireLogin) !== null && _h !== void 0 ? _h : false;
        const dashboardLabelSelectors = [{ matchLabels: (_j = this.labels) !== null && _j !== void 0 ? _j : { app: 'grafana' } }];
        new grafana_1.Grafana(this, 'Resource', {
            metadata: {
                labels: this.labels,
                namespace: this.namespace,
            },
            spec: {
                baseImage: baseImage,
                ingress: {
                    enabled: ingress,
                },
                service: {
                    type: serviceType,
                },
                client: {
                    // without this, dashboards may not be automatically discovered
                    // https://github.com/grafana-operator/grafana-operator/blob/master/documentation/deploy_grafana.md#configuring-grafana-api-access
                    preferService: true,
                },
                config: {
                    'log': {
                        mode: 'console',
                        level: 'info',
                    },
                    'auth.anonymous': {
                        enabled: !requireLogin,
                    },
                    'security': {
                        admin_user: adminUser,
                        admin_password: adminPassword,
                    },
                },
                deployment: {
                    labels: this.labels,
                },
                dashboardLabelSelector: dashboardLabelSelectors,
            },
        });
        if (props.defaultDataSource) {
            this.addDataSource('default-datasource', props.defaultDataSource);
        }
    }
    /**
     * Adds a data source.
     *
     * By default, labels are automatically added so that
     * the data source is detected by Grafana.
     *
     * @stability stable
     */
    addDataSource(id, props) {
        const labels = {
            ...this.labels,
            ...props.labels,
        };
        const datasource = new datasource_1.DataSource(this, id, {
            labels,
            namespace: this.namespace,
            ...props,
        });
        this.dataSources.push(datasource);
        return datasource;
    }
    /**
     * Creates a dashboard associated with a particular data source.
     *
     * By default,
     * labels are automatically added so that the data source is detected by
     * Grafana.
     *
     * @stability stable
     */
    addDashboard(id, props) {
        const labels = {
            ...this.labels,
            ...props.labels,
        };
        const dashboard = new dashboard_1.Dashboard(this, id, {
            labels,
            namespace: this.namespace,
            ...props,
        });
        this.dashboards.push(dashboard);
        return dashboard;
    }
}
exports.Grafana = Grafana;
_a = JSII_RTTI_SYMBOL_1;
Grafana[_a] = { fqn: "cdk8s-grafana.Grafana", version: "0.1.46" };
//# sourceMappingURL=data:application/json;base64,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