"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from polar_sdk.types import BaseModel
from polar_sdk.utils import FieldMetadata, validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class AuthorizationCodeTokenRequestTypedDict(TypedDict):
    client_id: str
    client_secret: str
    code: str
    redirect_uri: str
    grant_type: Literal["authorization_code"]


class AuthorizationCodeTokenRequest(BaseModel):
    client_id: Annotated[str, FieldMetadata(form=True)]

    client_secret: Annotated[str, FieldMetadata(form=True)]

    code: Annotated[str, FieldMetadata(form=True)]

    redirect_uri: Annotated[str, FieldMetadata(form=True)]

    GRANT_TYPE: Annotated[
        Annotated[
            Literal["authorization_code"],
            AfterValidator(validate_const("authorization_code")),
        ],
        pydantic.Field(alias="grant_type"),
        FieldMetadata(form=True),
    ] = "authorization_code"
