"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .benefitgithubrepositorycreateproperties import (
    BenefitGitHubRepositoryCreateProperties,
    BenefitGitHubRepositoryCreatePropertiesTypedDict,
)
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Dict, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


BenefitGitHubRepositoryUpdateMetadataTypedDict = TypeAliasType(
    "BenefitGitHubRepositoryUpdateMetadataTypedDict", Union[str, int, float, bool]
)


BenefitGitHubRepositoryUpdateMetadata = TypeAliasType(
    "BenefitGitHubRepositoryUpdateMetadata", Union[str, int, float, bool]
)


class BenefitGitHubRepositoryUpdateTypedDict(TypedDict):
    metadata: NotRequired[Dict[str, BenefitGitHubRepositoryUpdateMetadataTypedDict]]
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """
    description: NotRequired[Nullable[str]]
    r"""The description of the benefit. Will be displayed on products having this benefit."""
    type: Literal["github_repository"]
    properties: NotRequired[Nullable[BenefitGitHubRepositoryCreatePropertiesTypedDict]]


class BenefitGitHubRepositoryUpdate(BaseModel):
    metadata: Optional[Dict[str, BenefitGitHubRepositoryUpdateMetadata]] = None
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """

    description: OptionalNullable[str] = UNSET
    r"""The description of the benefit. Will be displayed on products having this benefit."""

    TYPE: Annotated[
        Annotated[
            Literal["github_repository"],
            AfterValidator(validate_const("github_repository")),
        ],
        pydantic.Field(alias="type"),
    ] = "github_repository"

    properties: OptionalNullable[BenefitGitHubRepositoryCreateProperties] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["metadata", "description", "properties"]
        nullable_fields = ["description", "properties"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
