"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class BenefitGrantGitHubRepositoryPropertiesPermission(str, Enum):
    PULL = "pull"
    TRIAGE = "triage"
    PUSH = "push"
    MAINTAIN = "maintain"
    ADMIN = "admin"


class BenefitGrantGitHubRepositoryPropertiesTypedDict(TypedDict):
    account_id: NotRequired[Nullable[str]]
    repository_owner: NotRequired[str]
    repository_name: NotRequired[str]
    permission: NotRequired[BenefitGrantGitHubRepositoryPropertiesPermission]
    granted_account_id: NotRequired[str]


class BenefitGrantGitHubRepositoryProperties(BaseModel):
    account_id: OptionalNullable[str] = UNSET

    repository_owner: Optional[str] = None

    repository_name: Optional[str] = None

    permission: Optional[BenefitGrantGitHubRepositoryPropertiesPermission] = None

    granted_account_id: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "account_id",
            "repository_owner",
            "repository_name",
            "permission",
            "granted_account_id",
        ]
        nullable_fields = ["account_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
