"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .customercustomermetersortproperty import CustomerCustomerMeterSortProperty
from .listresource_customercustomermeter_ import (
    ListResourceCustomerCustomerMeter,
    ListResourceCustomerCustomerMeterTypedDict,
)
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import FieldMetadata, QueryParamMetadata, SecurityMetadata
from pydantic import model_serializer
from typing import Callable, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CustomerPortalCustomerMetersListSecurityTypedDict(TypedDict):
    customer_session: str


class CustomerPortalCustomerMetersListSecurity(BaseModel):
    customer_session: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="http",
                sub_type="bearer",
                field_name="Authorization",
            )
        ),
    ]


MeterIDFilterTypedDict = TypeAliasType("MeterIDFilterTypedDict", Union[str, List[str]])
r"""Filter by meter ID."""


MeterIDFilter = TypeAliasType("MeterIDFilter", Union[str, List[str]])
r"""Filter by meter ID."""


class CustomerPortalCustomerMetersListRequestTypedDict(TypedDict):
    meter_id: NotRequired[Nullable[MeterIDFilterTypedDict]]
    r"""Filter by meter ID."""
    query: NotRequired[Nullable[str]]
    r"""Filter by meter name."""
    page: NotRequired[int]
    r"""Page number, defaults to 1."""
    limit: NotRequired[int]
    r"""Size of a page, defaults to 10. Maximum is 100."""
    sorting: NotRequired[Nullable[List[CustomerCustomerMeterSortProperty]]]
    r"""Sorting criterion. Several criteria can be used simultaneously and will be applied in order. Add a minus sign `-` before the criteria name to sort by descending order."""


class CustomerPortalCustomerMetersListRequest(BaseModel):
    meter_id: Annotated[
        OptionalNullable[MeterIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by meter ID."""

    query: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by meter name."""

    page: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number, defaults to 1."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Size of a page, defaults to 10. Maximum is 100."""

    sorting: Annotated[
        OptionalNullable[List[CustomerCustomerMeterSortProperty]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Sorting criterion. Several criteria can be used simultaneously and will be applied in order. Add a minus sign `-` before the criteria name to sort by descending order."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meter_id", "query", "page", "limit", "sorting"]
        nullable_fields = ["meter_id", "query", "sorting"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CustomerPortalCustomerMetersListResponseTypedDict(TypedDict):
    result: ListResourceCustomerCustomerMeterTypedDict


class CustomerPortalCustomerMetersListResponse(BaseModel):
    next: Callable[[], Optional[CustomerPortalCustomerMetersListResponse]]

    result: ListResourceCustomerCustomerMeter
