"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .missinginvoicebillingdetails import MissingInvoiceBillingDetailsData
from .notpaidorder import NotPaidOrderData
import httpx
from polar_sdk.models import PolarError
from polar_sdk.types import BaseModel
from polar_sdk.utils import FieldMetadata, PathParamMetadata, SecurityMetadata
from typing import Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class CustomerPortalOrdersGenerateInvoiceSecurityTypedDict(TypedDict):
    customer_session: str


class CustomerPortalOrdersGenerateInvoiceSecurity(BaseModel):
    customer_session: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="http",
                sub_type="bearer",
                field_name="Authorization",
            )
        ),
    ]


class CustomerPortalOrdersGenerateInvoiceRequestTypedDict(TypedDict):
    id: str
    r"""The order ID."""


class CustomerPortalOrdersGenerateInvoiceRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The order ID."""


CustomerPortalOrdersGenerateInvoiceResponse422CustomerPortalOrdersGenerateInvoiceUnion = TypeAliasType(
    "CustomerPortalOrdersGenerateInvoiceResponse422CustomerPortalOrdersGenerateInvoiceUnion",
    Union[MissingInvoiceBillingDetailsData, NotPaidOrderData],
)
r"""Order is not paid or is missing billing name or address."""


class CustomerPortalOrdersGenerateInvoiceResponse422CustomerPortalOrdersGenerateInvoice(
    PolarError
):
    r"""Order is not paid or is missing billing name or address."""

    data: CustomerPortalOrdersGenerateInvoiceResponse422CustomerPortalOrdersGenerateInvoiceUnion

    def __init__(
        self,
        data: CustomerPortalOrdersGenerateInvoiceResponse422CustomerPortalOrdersGenerateInvoiceUnion,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data
