"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .discountduration import DiscountDuration
from .discounttype import DiscountType
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, List, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


DiscountUpdateMetadataTypedDict = TypeAliasType(
    "DiscountUpdateMetadataTypedDict", Union[str, int, float, bool]
)


DiscountUpdateMetadata = TypeAliasType(
    "DiscountUpdateMetadata", Union[str, int, float, bool]
)


class DiscountUpdateTypedDict(TypedDict):
    r"""Schema to update a discount."""

    metadata: NotRequired[Dict[str, DiscountUpdateMetadataTypedDict]]
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """
    name: NotRequired[Nullable[str]]
    code: NotRequired[Nullable[str]]
    starts_at: NotRequired[Nullable[datetime]]
    ends_at: NotRequired[Nullable[datetime]]
    max_redemptions: NotRequired[Nullable[int]]
    duration: NotRequired[Nullable[DiscountDuration]]
    duration_in_months: NotRequired[Nullable[int]]
    type: NotRequired[Nullable[DiscountType]]
    amount: NotRequired[Nullable[int]]
    currency: NotRequired[Nullable[str]]
    basis_points: NotRequired[Nullable[int]]
    products: NotRequired[Nullable[List[str]]]


class DiscountUpdate(BaseModel):
    r"""Schema to update a discount."""

    metadata: Optional[Dict[str, DiscountUpdateMetadata]] = None
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """

    name: OptionalNullable[str] = UNSET

    code: OptionalNullable[str] = UNSET

    starts_at: OptionalNullable[datetime] = UNSET

    ends_at: OptionalNullable[datetime] = UNSET

    max_redemptions: OptionalNullable[int] = UNSET

    duration: OptionalNullable[DiscountDuration] = UNSET

    duration_in_months: OptionalNullable[int] = UNSET

    type: OptionalNullable[DiscountType] = UNSET

    amount: OptionalNullable[int] = UNSET

    currency: OptionalNullable[str] = "usd"

    basis_points: OptionalNullable[int] = UNSET

    products: OptionalNullable[List[str]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "metadata",
            "name",
            "code",
            "starts_at",
            "ends_at",
            "max_redemptions",
            "duration",
            "duration_in_months",
            "type",
            "amount",
            "currency",
            "basis_points",
            "products",
        ]
        nullable_fields = [
            "name",
            "code",
            "starts_at",
            "ends_at",
            "max_redemptions",
            "duration",
            "duration_in_months",
            "type",
            "amount",
            "currency",
            "basis_points",
            "products",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
