"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .countaggregation import CountAggregation, CountAggregationTypedDict
from .filter_ import Filter, FilterTypedDict
from .propertyaggregation import PropertyAggregation, PropertyAggregationTypedDict
from .uniqueaggregation import UniqueAggregation, UniqueAggregationTypedDict
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import get_discriminator
import pydantic
from pydantic import Discriminator, Tag, model_serializer
from typing import Dict, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


MeterMetadataTypedDict = TypeAliasType(
    "MeterMetadataTypedDict", Union[str, int, float, bool]
)


MeterMetadata = TypeAliasType("MeterMetadata", Union[str, int, float, bool])


MeterAggregationTypedDict = TypeAliasType(
    "MeterAggregationTypedDict",
    Union[
        CountAggregationTypedDict,
        PropertyAggregationTypedDict,
        UniqueAggregationTypedDict,
    ],
)
r"""The aggregation to apply on the filtered events to calculate the meter."""


MeterAggregation = Annotated[
    Union[
        Annotated[PropertyAggregation, Tag("avg")],
        Annotated[CountAggregation, Tag("count")],
        Annotated[PropertyAggregation, Tag("max")],
        Annotated[PropertyAggregation, Tag("min")],
        Annotated[PropertyAggregation, Tag("sum")],
        Annotated[UniqueAggregation, Tag("unique")],
    ],
    Discriminator(lambda m: get_discriminator(m, "func", "func")),
]
r"""The aggregation to apply on the filtered events to calculate the meter."""


class MeterTypedDict(TypedDict):
    metadata: Dict[str, MeterMetadataTypedDict]
    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    id: str
    r"""The ID of the object."""
    name: str
    r"""The name of the meter. Will be shown on customer's invoices and usage."""
    filter_: FilterTypedDict
    aggregation: MeterAggregationTypedDict
    r"""The aggregation to apply on the filtered events to calculate the meter."""
    organization_id: str
    r"""The ID of the organization owning the meter."""
    archived_at: NotRequired[Nullable[datetime]]
    r"""Whether the meter is archived and the time it was archived."""


class Meter(BaseModel):
    metadata: Dict[str, MeterMetadata]

    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    id: str
    r"""The ID of the object."""

    name: str
    r"""The name of the meter. Will be shown on customer's invoices and usage."""

    filter_: Annotated[Filter, pydantic.Field(alias="filter")]

    aggregation: MeterAggregation
    r"""The aggregation to apply on the filtered events to calculate the meter."""

    organization_id: str
    r"""The ID of the organization owning the meter."""

    archived_at: OptionalNullable[datetime] = UNSET
    r"""Whether the meter is archived and the time it was archived."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["archived_at"]
        nullable_fields = ["modified_at", "archived_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
