"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .discountfixedonceforeverdurationbase import (
    DiscountFixedOnceForeverDurationBase,
    DiscountFixedOnceForeverDurationBaseTypedDict,
)
from .discountfixedrepeatdurationbase import (
    DiscountFixedRepeatDurationBase,
    DiscountFixedRepeatDurationBaseTypedDict,
)
from .discountpercentageonceforeverdurationbase import (
    DiscountPercentageOnceForeverDurationBase,
    DiscountPercentageOnceForeverDurationBaseTypedDict,
)
from .discountpercentagerepeatdurationbase import (
    DiscountPercentageRepeatDurationBase,
    DiscountPercentageRepeatDurationBaseTypedDict,
)
from .orderbillingreason import OrderBillingReason
from .ordercustomer import OrderCustomer, OrderCustomerTypedDict
from .orderitemschema import OrderItemSchema, OrderItemSchemaTypedDict
from .orderproduct import OrderProduct, OrderProductTypedDict
from .orderstatus import OrderStatus
from .ordersubscription import OrderSubscription, OrderSubscriptionTypedDict
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


OrderMetadataTypedDict = TypeAliasType(
    "OrderMetadataTypedDict", Union[str, int, float, bool]
)


OrderMetadata = TypeAliasType("OrderMetadata", Union[str, int, float, bool])


OrderCustomFieldDataTypedDict = TypeAliasType(
    "OrderCustomFieldDataTypedDict", Union[str, int, bool, datetime]
)


OrderCustomFieldData = TypeAliasType(
    "OrderCustomFieldData", Union[str, int, bool, datetime]
)


OrderDiscountTypedDict = TypeAliasType(
    "OrderDiscountTypedDict",
    Union[
        DiscountPercentageOnceForeverDurationBaseTypedDict,
        DiscountFixedOnceForeverDurationBaseTypedDict,
        DiscountPercentageRepeatDurationBaseTypedDict,
        DiscountFixedRepeatDurationBaseTypedDict,
    ],
)


OrderDiscount = TypeAliasType(
    "OrderDiscount",
    Union[
        DiscountPercentageOnceForeverDurationBase,
        DiscountFixedOnceForeverDurationBase,
        DiscountPercentageRepeatDurationBase,
        DiscountFixedRepeatDurationBase,
    ],
)


class OrderTypedDict(TypedDict):
    id: str
    r"""The ID of the object."""
    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    status: OrderStatus
    paid: bool
    r"""Whether the order has been paid for."""
    subtotal_amount: int
    r"""Amount in cents, before discounts and taxes."""
    discount_amount: int
    r"""Discount amount in cents."""
    net_amount: int
    r"""Amount in cents, after discounts but before taxes."""
    tax_amount: int
    r"""Sales tax amount in cents."""
    total_amount: int
    r"""Amount in cents, after discounts and taxes."""
    refunded_amount: int
    r"""Amount refunded in cents."""
    refunded_tax_amount: int
    r"""Sales tax refunded in cents."""
    currency: str
    billing_reason: OrderBillingReason
    billing_name: Nullable[str]
    r"""The name of the customer that should appear on the invoice."""
    billing_address: Nullable[AddressTypedDict]
    is_invoice_generated: bool
    r"""Whether an invoice has been generated for this order."""
    customer_id: str
    product_id: str
    discount_id: Nullable[str]
    subscription_id: Nullable[str]
    checkout_id: Nullable[str]
    metadata: Dict[str, OrderMetadataTypedDict]
    customer: OrderCustomerTypedDict
    user_id: str
    product: OrderProductTypedDict
    discount: Nullable[OrderDiscountTypedDict]
    subscription: Nullable[OrderSubscriptionTypedDict]
    items: List[OrderItemSchemaTypedDict]
    r"""Line items composing the order."""
    custom_field_data: NotRequired[Dict[str, Nullable[OrderCustomFieldDataTypedDict]]]
    r"""Key-value object storing custom field values."""


class Order(BaseModel):
    id: str
    r"""The ID of the object."""

    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    status: OrderStatus

    paid: bool
    r"""Whether the order has been paid for."""

    subtotal_amount: int
    r"""Amount in cents, before discounts and taxes."""

    discount_amount: int
    r"""Discount amount in cents."""

    net_amount: int
    r"""Amount in cents, after discounts but before taxes."""

    tax_amount: int
    r"""Sales tax amount in cents."""

    total_amount: int
    r"""Amount in cents, after discounts and taxes."""

    refunded_amount: int
    r"""Amount refunded in cents."""

    refunded_tax_amount: int
    r"""Sales tax refunded in cents."""

    currency: str

    billing_reason: OrderBillingReason

    billing_name: Nullable[str]
    r"""The name of the customer that should appear on the invoice."""

    billing_address: Nullable[Address]

    is_invoice_generated: bool
    r"""Whether an invoice has been generated for this order."""

    customer_id: str

    product_id: str

    discount_id: Nullable[str]

    subscription_id: Nullable[str]

    checkout_id: Nullable[str]

    metadata: Dict[str, OrderMetadata]

    customer: OrderCustomer

    user_id: Annotated[
        str,
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ]

    product: OrderProduct

    discount: Nullable[OrderDiscount]

    subscription: Nullable[OrderSubscription]

    items: List[OrderItemSchema]
    r"""Line items composing the order."""

    custom_field_data: Optional[Dict[str, Nullable[OrderCustomFieldData]]] = None
    r"""Key-value object storing custom field values."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["custom_field_data"]
        nullable_fields = [
            "modified_at",
            "billing_name",
            "billing_address",
            "discount_id",
            "subscription_id",
            "checkout_id",
            "discount",
            "subscription",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
