"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .organizationfeaturesettings import (
    OrganizationFeatureSettings,
    OrganizationFeatureSettingsTypedDict,
)
from .organizationnotificationsettings import (
    OrganizationNotificationSettings,
    OrganizationNotificationSettingsTypedDict,
)
from .organizationsociallink import (
    OrganizationSocialLink,
    OrganizationSocialLinkTypedDict,
)
from .organizationsubscriptionsettings import (
    OrganizationSubscriptionSettings,
    OrganizationSubscriptionSettingsTypedDict,
)
from .status import Status
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List
from typing_extensions import TypedDict


class OrganizationTypedDict(TypedDict):
    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    id: str
    r"""The organization ID."""
    name: str
    r"""Organization name shown in checkout, customer portal, emails etc."""
    slug: str
    r"""Unique organization slug in checkout, customer portal and credit card statements."""
    avatar_url: Nullable[str]
    r"""Avatar URL shown in checkout, customer portal, emails etc."""
    email: Nullable[str]
    r"""Public support email."""
    website: Nullable[str]
    r"""Official website of the organization."""
    socials: List[OrganizationSocialLinkTypedDict]
    r"""Links to social profiles."""
    status: Status
    details_submitted_at: Nullable[datetime]
    r"""When the business details were submitted."""
    feature_settings: Nullable[OrganizationFeatureSettingsTypedDict]
    r"""Organization feature settings"""
    subscription_settings: OrganizationSubscriptionSettingsTypedDict
    notification_settings: OrganizationNotificationSettingsTypedDict


class Organization(BaseModel):
    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    id: str
    r"""The organization ID."""

    name: str
    r"""Organization name shown in checkout, customer portal, emails etc."""

    slug: str
    r"""Unique organization slug in checkout, customer portal and credit card statements."""

    avatar_url: Nullable[str]
    r"""Avatar URL shown in checkout, customer portal, emails etc."""

    email: Nullable[str]
    r"""Public support email."""

    website: Nullable[str]
    r"""Official website of the organization."""

    socials: List[OrganizationSocialLink]
    r"""Links to social profiles."""

    status: Status

    details_submitted_at: Nullable[datetime]
    r"""When the business details were submitted."""

    feature_settings: Nullable[OrganizationFeatureSettings]
    r"""Organization feature settings"""

    subscription_settings: OrganizationSubscriptionSettings

    notification_settings: OrganizationNotificationSettings

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = [
            "modified_at",
            "avatar_url",
            "email",
            "website",
            "details_submitted_at",
            "feature_settings",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
