"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .s3filecreatemultipart import S3FileCreateMultipart, S3FileCreateMultipartTypedDict
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, NotRequired, TypedDict


class ProductMediaFileCreateTypedDict(TypedDict):
    r"""Schema to create a file to be used as a product media file."""

    name: str
    mime_type: str
    r"""MIME type of the file. Only images are supported for this type of file."""
    size: int
    r"""Size of the file. A maximum of 10 MB is allowed for this type of file."""
    upload: S3FileCreateMultipartTypedDict
    organization_id: NotRequired[Nullable[str]]
    checksum_sha256_base64: NotRequired[Nullable[str]]
    service: Literal["product_media"]
    version: NotRequired[Nullable[str]]


class ProductMediaFileCreate(BaseModel):
    r"""Schema to create a file to be used as a product media file."""

    name: str

    mime_type: str
    r"""MIME type of the file. Only images are supported for this type of file."""

    size: int
    r"""Size of the file. A maximum of 10 MB is allowed for this type of file."""

    upload: S3FileCreateMultipart

    organization_id: OptionalNullable[str] = UNSET

    checksum_sha256_base64: OptionalNullable[str] = UNSET

    SERVICE: Annotated[
        Annotated[
            Literal["product_media"], AfterValidator(validate_const("product_media"))
        ],
        pydantic.Field(alias="service"),
    ] = "product_media"

    version: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["organization_id", "checksum_sha256_base64", "version"]
        nullable_fields = ["organization_id", "checksum_sha256_base64", "version"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
