"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ProductPriceCustomCreateTypedDict(TypedDict):
    r"""Schema to create a pay-what-you-want price."""

    amount_type: Literal["custom"]
    price_currency: NotRequired[str]
    r"""The currency. Currently, only `usd` is supported."""
    minimum_amount: NotRequired[Nullable[int]]
    r"""The minimum amount the customer can pay."""
    maximum_amount: NotRequired[Nullable[int]]
    r"""The maximum amount the customer can pay."""
    preset_amount: NotRequired[Nullable[int]]
    r"""The initial amount shown to the customer."""


class ProductPriceCustomCreate(BaseModel):
    r"""Schema to create a pay-what-you-want price."""

    AMOUNT_TYPE: Annotated[
        Annotated[Literal["custom"], AfterValidator(validate_const("custom"))],
        pydantic.Field(alias="amount_type"),
    ] = "custom"

    price_currency: Optional[str] = "usd"
    r"""The currency. Currently, only `usd` is supported."""

    minimum_amount: OptionalNullable[int] = UNSET
    r"""The minimum amount the customer can pay."""

    maximum_amount: OptionalNullable[int] = UNSET
    r"""The maximum amount the customer can pay."""

    preset_amount: OptionalNullable[int] = UNSET
    r"""The initial amount shown to the customer."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "price_currency",
            "minimum_amount",
            "maximum_amount",
            "preset_amount",
        ]
        nullable_fields = ["minimum_amount", "maximum_amount", "preset_amount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
