"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


UnitAmountTypedDict = TypeAliasType("UnitAmountTypedDict", Union[float, str])
r"""The price per unit in cents. Supports up to 12 decimal places."""


UnitAmount = TypeAliasType("UnitAmount", Union[float, str])
r"""The price per unit in cents. Supports up to 12 decimal places."""


class ProductPriceMeteredUnitCreateTypedDict(TypedDict):
    r"""Schema to create a metered price with a fixed unit price."""

    meter_id: str
    r"""The ID of the meter associated to the price."""
    unit_amount: UnitAmountTypedDict
    r"""The price per unit in cents. Supports up to 12 decimal places."""
    amount_type: Literal["metered_unit"]
    price_currency: NotRequired[str]
    r"""The currency. Currently, only `usd` is supported."""
    cap_amount: NotRequired[Nullable[int]]
    r"""Optional maximum amount in cents that can be charged, regardless of the number of units consumed."""


class ProductPriceMeteredUnitCreate(BaseModel):
    r"""Schema to create a metered price with a fixed unit price."""

    meter_id: str
    r"""The ID of the meter associated to the price."""

    unit_amount: UnitAmount
    r"""The price per unit in cents. Supports up to 12 decimal places."""

    AMOUNT_TYPE: Annotated[
        Annotated[
            Literal["metered_unit"], AfterValidator(validate_const("metered_unit"))
        ],
        pydantic.Field(alias="amount_type"),
    ] = "metered_unit"

    price_currency: Optional[str] = "usd"
    r"""The currency. Currently, only `usd` is supported."""

    cap_amount: OptionalNullable[int] = UNSET
    r"""Optional maximum amount in cents that can be charged, regardless of the number of units consumed."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["price_currency", "cap_amount"]
        nullable_fields = ["cap_amount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
