"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .refundreason import RefundReason
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


RefundCreateMetadataTypedDict = TypeAliasType(
    "RefundCreateMetadataTypedDict", Union[str, int, float, bool]
)


RefundCreateMetadata = TypeAliasType(
    "RefundCreateMetadata", Union[str, int, float, bool]
)


class RefundCreateTypedDict(TypedDict):
    order_id: str
    reason: RefundReason
    amount: int
    r"""Amount to refund in cents. Minimum is 1."""
    metadata: NotRequired[Dict[str, RefundCreateMetadataTypedDict]]
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """
    comment: NotRequired[Nullable[str]]
    r"""An internal comment about the refund."""
    revoke_benefits: NotRequired[bool]
    r"""Should this refund trigger the associated customer benefits to be revoked?

    **Note:**
    Only allowed in case the `order` is a one-time purchase.
    Subscriptions automatically revoke customer benefits once the
    subscription itself is revoked, i.e fully canceled.
    """


class RefundCreate(BaseModel):
    order_id: str

    reason: RefundReason

    amount: int
    r"""Amount to refund in cents. Minimum is 1."""

    metadata: Optional[Dict[str, RefundCreateMetadata]] = None
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """

    comment: OptionalNullable[str] = UNSET
    r"""An internal comment about the refund."""

    revoke_benefits: Optional[bool] = False
    r"""Should this refund trigger the associated customer benefits to be revoked?

    **Note:**
    Only allowed in case the `order` is a one-time purchase.
    Subscriptions automatically revoke customer benefits once the
    subscription itself is revoked, i.e fully canceled.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["metadata", "comment", "revoke_benefits"]
        nullable_fields = ["comment"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
