"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .customer import Customer, CustomerTypedDict
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class WebhookCustomerCreatedPayloadTypedDict(TypedDict):
    r"""Sent when a new customer is created.

    A customer can be created:

    * After a successful checkout.
    * Programmatically via the API.

    **Discord & Slack support:** Basic
    """

    data: CustomerTypedDict
    r"""A customer in an organization."""
    type: Literal["customer.created"]


class WebhookCustomerCreatedPayload(BaseModel):
    r"""Sent when a new customer is created.

    A customer can be created:

    * After a successful checkout.
    * Programmatically via the API.

    **Discord & Slack support:** Basic
    """

    data: Customer
    r"""A customer in an organization."""

    TYPE: Annotated[
        Annotated[
            Literal["customer.created"],
            AfterValidator(validate_const("customer.created")),
        ],
        pydantic.Field(alias="type"),
    ] = "customer.created"
