"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .customer import Customer, CustomerTypedDict
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class WebhookCustomerUpdatedPayloadTypedDict(TypedDict):
    r"""Sent when a customer is updated.

    This event is fired when the customer details are updated.

    If you want to be notified when a customer subscription or benefit state changes, you should listen to the `customer_state_changed` event.

    **Discord & Slack support:** Basic
    """

    data: CustomerTypedDict
    r"""A customer in an organization."""
    type: Literal["customer.updated"]


class WebhookCustomerUpdatedPayload(BaseModel):
    r"""Sent when a customer is updated.

    This event is fired when the customer details are updated.

    If you want to be notified when a customer subscription or benefit state changes, you should listen to the `customer_state_changed` event.

    **Discord & Slack support:** Basic
    """

    data: Customer
    r"""A customer in an organization."""

    TYPE: Annotated[
        Annotated[
            Literal["customer.updated"],
            AfterValidator(validate_const("customer.updated")),
        ],
        pydantic.Field(alias="type"),
    ] = "customer.updated"
