"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .webhookeventtype import WebhookEventType
from .webhookformat import WebhookFormat
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List
from typing_extensions import Annotated, NotRequired, TypedDict


class WebhookEndpointCreateTypedDict(TypedDict):
    r"""Schema to create a webhook endpoint."""

    url: str
    r"""The URL where the webhook events will be sent."""
    format_: WebhookFormat
    events: List[WebhookEventType]
    r"""The events that will trigger the webhook."""
    secret: NotRequired[Nullable[str]]
    organization_id: NotRequired[Nullable[str]]
    r"""The organization ID associated with the webhook endpoint. **Required unless you use an organization token.**"""


class WebhookEndpointCreate(BaseModel):
    r"""Schema to create a webhook endpoint."""

    url: str
    r"""The URL where the webhook events will be sent."""

    format_: Annotated[WebhookFormat, pydantic.Field(alias="format")]

    events: List[WebhookEventType]
    r"""The events that will trigger the webhook."""

    secret: Annotated[
        OptionalNullable[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = UNSET

    organization_id: OptionalNullable[str] = UNSET
    r"""The organization ID associated with the webhook endpoint. **Required unless you use an organization token.**"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["secret", "organization_id"]
        nullable_fields = ["secret", "organization_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
