"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .listresource_webhookendpoint_ import (
    ListResourceWebhookEndpoint,
    ListResourceWebhookEndpointTypedDict,
)
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import FieldMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import Callable, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


QueryParamOrganizationIDTypedDict = TypeAliasType(
    "QueryParamOrganizationIDTypedDict", Union[str, List[str]]
)
r"""Filter by organization ID."""


QueryParamOrganizationID = TypeAliasType(
    "QueryParamOrganizationID", Union[str, List[str]]
)
r"""Filter by organization ID."""


class WebhooksListWebhookEndpointsRequestTypedDict(TypedDict):
    organization_id: NotRequired[Nullable[QueryParamOrganizationIDTypedDict]]
    r"""Filter by organization ID."""
    page: NotRequired[int]
    r"""Page number, defaults to 1."""
    limit: NotRequired[int]
    r"""Size of a page, defaults to 10. Maximum is 100."""


class WebhooksListWebhookEndpointsRequest(BaseModel):
    organization_id: Annotated[
        OptionalNullable[QueryParamOrganizationID],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by organization ID."""

    page: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number, defaults to 1."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Size of a page, defaults to 10. Maximum is 100."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["organization_id", "page", "limit"]
        nullable_fields = ["organization_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class WebhooksListWebhookEndpointsResponseTypedDict(TypedDict):
    result: ListResourceWebhookEndpointTypedDict


class WebhooksListWebhookEndpointsResponse(BaseModel):
    next: Callable[[], Optional[WebhooksListWebhookEndpointsResponse]]

    result: ListResourceWebhookEndpoint
