"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .httpclient import AsyncHttpClient, ClientOwner, HttpClient, close_clients
from .sdkconfiguration import SDKConfiguration
from .utils.logger import Logger, get_default_logger
from .utils.retries import RetryConfig
import httpx
import importlib
from polar_sdk import models, utils
from polar_sdk._hooks import SDKHooks
from polar_sdk.types import OptionalNullable, UNSET
import sys
from typing import Any, Callable, Dict, Optional, TYPE_CHECKING, Union, cast
import weakref

if TYPE_CHECKING:
    from polar_sdk.benefits import Benefits
    from polar_sdk.checkout_links import CheckoutLinks
    from polar_sdk.checkouts import Checkouts
    from polar_sdk.custom_fields import CustomFields
    from polar_sdk.customer_meters import CustomerMeters
    from polar_sdk.customer_portal import CustomerPortal
    from polar_sdk.customer_sessions import CustomerSessions
    from polar_sdk.customers import Customers
    from polar_sdk.discounts import Discounts
    from polar_sdk.events import Events
    from polar_sdk.files import Files
    from polar_sdk.license_keys import LicenseKeys
    from polar_sdk.meters import Meters
    from polar_sdk.metrics_sdk import MetricsSDK
    from polar_sdk.oauth2 import Oauth2
    from polar_sdk.orders import Orders
    from polar_sdk.organizations import Organizations
    from polar_sdk.payments import Payments
    from polar_sdk.products import Products
    from polar_sdk.refunds import Refunds
    from polar_sdk.subscriptions import Subscriptions
    from polar_sdk.webhooks import Webhooks


class Polar(BaseSDK):
    r"""Polar API: Polar HTTP and Webhooks API

    Read the docs at https://docs.polar.sh/api-reference
    """

    organizations: "Organizations"
    subscriptions: "Subscriptions"
    oauth2: "Oauth2"
    benefits: "Benefits"
    webhooks: "Webhooks"
    products: "Products"
    orders: "Orders"
    refunds: "Refunds"
    checkouts: "Checkouts"
    files: "Files"
    metrics: "MetricsSDK"
    license_keys: "LicenseKeys"
    checkout_links: "CheckoutLinks"
    custom_fields: "CustomFields"
    discounts: "Discounts"
    customers: "Customers"
    customer_portal: "CustomerPortal"
    customer_sessions: "CustomerSessions"
    events: "Events"
    meters: "Meters"
    customer_meters: "CustomerMeters"
    payments: "Payments"
    _sub_sdk_map = {
        "organizations": ("polar_sdk.organizations", "Organizations"),
        "subscriptions": ("polar_sdk.subscriptions", "Subscriptions"),
        "oauth2": ("polar_sdk.oauth2", "Oauth2"),
        "benefits": ("polar_sdk.benefits", "Benefits"),
        "webhooks": ("polar_sdk.webhooks", "Webhooks"),
        "products": ("polar_sdk.products", "Products"),
        "orders": ("polar_sdk.orders", "Orders"),
        "refunds": ("polar_sdk.refunds", "Refunds"),
        "checkouts": ("polar_sdk.checkouts", "Checkouts"),
        "files": ("polar_sdk.files", "Files"),
        "metrics": ("polar_sdk.metrics_sdk", "MetricsSDK"),
        "license_keys": ("polar_sdk.license_keys", "LicenseKeys"),
        "checkout_links": ("polar_sdk.checkout_links", "CheckoutLinks"),
        "custom_fields": ("polar_sdk.custom_fields", "CustomFields"),
        "discounts": ("polar_sdk.discounts", "Discounts"),
        "customers": ("polar_sdk.customers", "Customers"),
        "customer_portal": ("polar_sdk.customer_portal", "CustomerPortal"),
        "customer_sessions": ("polar_sdk.customer_sessions", "CustomerSessions"),
        "events": ("polar_sdk.events", "Events"),
        "meters": ("polar_sdk.meters", "Meters"),
        "customer_meters": ("polar_sdk.customer_meters", "CustomerMeters"),
        "payments": ("polar_sdk.payments", "Payments"),
    }

    def __init__(
        self,
        access_token: Optional[
            Union[Optional[str], Callable[[], Optional[str]]]
        ] = None,
        server: Optional[str] = None,
        server_url: Optional[str] = None,
        url_params: Optional[Dict[str, str]] = None,
        client: Optional[HttpClient] = None,
        async_client: Optional[AsyncHttpClient] = None,
        retry_config: OptionalNullable[RetryConfig] = UNSET,
        timeout_ms: Optional[int] = None,
        debug_logger: Optional[Logger] = None,
    ) -> None:
        r"""Instantiates the SDK configuring it with the provided parameters.

        :param access_token: The access_token required for authentication
        :param server: The server by name to use for all methods
        :param server_url: The server URL to use for all methods
        :param url_params: Parameters to optionally template the server URL with
        :param client: The HTTP client to use for all synchronous methods
        :param async_client: The Async HTTP client to use for all asynchronous methods
        :param retry_config: The retry configuration to use for all supported methods
        :param timeout_ms: Optional request timeout applied to each operation in milliseconds
        """
        client_supplied = True
        if client is None:
            client = httpx.Client()
            client_supplied = False

        assert issubclass(
            type(client), HttpClient
        ), "The provided client must implement the HttpClient protocol."

        async_client_supplied = True
        if async_client is None:
            async_client = httpx.AsyncClient()
            async_client_supplied = False

        if debug_logger is None:
            debug_logger = get_default_logger()

        assert issubclass(
            type(async_client), AsyncHttpClient
        ), "The provided async_client must implement the AsyncHttpClient protocol."

        security: Any = None
        if callable(access_token):
            # pylint: disable=unnecessary-lambda-assignment
            security = lambda: models.Security(access_token=access_token())
        else:
            security = models.Security(access_token=access_token)

        if server_url is not None:
            if url_params is not None:
                server_url = utils.template_url(server_url, url_params)

        BaseSDK.__init__(
            self,
            SDKConfiguration(
                client=client,
                client_supplied=client_supplied,
                async_client=async_client,
                async_client_supplied=async_client_supplied,
                security=security,
                server_url=server_url,
                server=server,
                retry_config=retry_config,
                timeout_ms=timeout_ms,
                debug_logger=debug_logger,
            ),
            parent_ref=self,
        )

        hooks = SDKHooks()

        # pylint: disable=protected-access
        self.sdk_configuration.__dict__["_hooks"] = hooks

        current_server_url, *_ = self.sdk_configuration.get_server_details()
        server_url, self.sdk_configuration.client = hooks.sdk_init(
            current_server_url, client
        )
        if current_server_url != server_url:
            self.sdk_configuration.server_url = server_url

        weakref.finalize(
            self,
            close_clients,
            cast(ClientOwner, self.sdk_configuration),
            self.sdk_configuration.client,
            self.sdk_configuration.client_supplied,
            self.sdk_configuration.async_client,
            self.sdk_configuration.async_client_supplied,
        )

    def dynamic_import(self, modname, retries=3):
        for attempt in range(retries):
            try:
                return importlib.import_module(modname)
            except KeyError:
                # Clear any half-initialized module and retry
                sys.modules.pop(modname, None)
                if attempt == retries - 1:
                    break
        raise KeyError(f"Failed to import module '{modname}' after {retries} attempts")

    def __getattr__(self, name: str):
        if name in self._sub_sdk_map:
            module_path, class_name = self._sub_sdk_map[name]
            try:
                module = self.dynamic_import(module_path)
                klass = getattr(module, class_name)
                instance = klass(self.sdk_configuration, parent_ref=self)
                setattr(self, name, instance)
                return instance
            except ImportError as e:
                raise AttributeError(
                    f"Failed to import module {module_path} for attribute {name}: {e}"
                ) from e
            except AttributeError as e:
                raise AttributeError(
                    f"Failed to find class {class_name} in module {module_path} for attribute {name}: {e}"
                ) from e

        raise AttributeError(
            f"'{type(self).__name__}' object has no attribute '{name}'"
        )

    def __dir__(self):
        default_attrs = list(super().__dir__())
        lazy_attrs = list(self._sub_sdk_map.keys())
        return sorted(list(set(default_attrs + lazy_attrs)))

    def __enter__(self):
        return self

    async def __aenter__(self):
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.client is not None
            and not self.sdk_configuration.client_supplied
        ):
            self.sdk_configuration.client.close()
        self.sdk_configuration.client = None

    async def __aexit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.async_client is not None
            and not self.sdk_configuration.async_client_supplied
        ):
            await self.sdk_configuration.async_client.aclose()
        self.sdk_configuration.async_client = None
