from cognite_toolkit._cdf_tk.utils._auxiliary import get_concrete_subclasses

from ._annotations import AnnotationIO
from ._applications import CanvasIO, ChartIO
from ._asset_centric import (
    AssetIO,
    BaseAssetCentricIO,
    EventIO,
    FileMetadataIO,
    HierarchyIO,
    TimeSeriesIO,
)
from ._base import (
    ConfigurableStorageIO,
    Page,
    StorageIO,
    StorageIOConfig,
    T_Selector,
    TableStorageIO,
    UploadableStorageIO,
    UploadItem,
)
from ._data_classes import InstanceIdCSVList, InstanceIdRow, ModelList
from ._datapoints import DatapointsIO
from ._file_content import FileContentIO
from ._instances import InstanceIO
from ._raw import RawIO
from .selectors._base import DataSelector

# MyPy fails to recognize that get_concrete_subclasses always returns a list of concrete subclasses.
STORAGE_IO_CLASSES = get_concrete_subclasses(StorageIO)  # type: ignore[type-abstract]
UPLOAD_IO_CLASSES = get_concrete_subclasses(UploadableStorageIO)  # type: ignore[type-abstract]


def get_upload_io(selector_cls: type[DataSelector]) -> type[UploadableStorageIO]:
    """Get the appropriate UploadableStorageIO class based on the type of the provided selector."""
    for cls in UPLOAD_IO_CLASSES:
        if issubclass(selector_cls, cls.BASE_SELECTOR):
            return cls
    raise ValueError(f"No UploadableStorageIO found for selector of type {selector_cls.__name__}")


__all__ = [
    "AnnotationIO",
    "AssetIO",
    "BaseAssetCentricIO",
    "CanvasIO",
    "ChartIO",
    "ConfigurableStorageIO",
    "DatapointsIO",
    "EventIO",
    "FileContentIO",
    "FileMetadataIO",
    "HierarchyIO",
    "InstanceIO",
    "InstanceIdCSVList",
    "InstanceIdRow",
    "ModelList",
    "Page",
    "RawIO",
    "StorageIO",
    "StorageIOConfig",
    "T_Selector",
    "TableStorageIO",
    "TimeSeriesIO",
    "UploadItem",
    "UploadableStorageIO",
    "get_upload_io",
]
