# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.map_component import MapComponent
from ..types.map_config import MapConfig
from ..types.time_series_component import TimeSeriesComponent
from .raw_client import AsyncRawComponentsClient, RawComponentsClient
from .types.list_components_api_v_1_dashboard_components_get_response_item import (
    ListComponentsApiV1DashboardComponentsGetResponseItem,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ComponentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawComponentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawComponentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawComponentsClient
        """
        return self._raw_client

    def create_map(
        self,
        *,
        name: str,
        config: MapConfig,
        layer_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MapComponent:
        """
        Create a new map component.

        Parameters
        ----------
        name : str

        config : MapConfig

        layer_ids : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MapComponent
            Successful Response

        Examples
        --------
        from rebase_dashboard import MapConfig, RebaseDashboardClient

        client = RebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )
        client.components.create_map(
            name="name",
            config=MapConfig(),
        )
        """
        _response = self._raw_client.create_map(
            name=name, config=config, layer_ids=layer_ids, request_options=request_options
        )
        return _response.data

    def create_timeseries(
        self,
        *,
        name: str,
        title: str,
        datasets: typing.Sequence[str],
        y_axis_label: typing.Optional[str] = OMIT,
        unit: typing.Optional[str] = OMIT,
        formula: typing.Optional[str] = OMIT,
        echarts_options: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        theme: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TimeSeriesComponent:
        """
        Create a new time series component.

        Parameters
        ----------
        name : str

        title : str
            The user-defined title of the chart.

        datasets : typing.Sequence[str]
            List of timeseries dataset IDs to display on this chart.

        y_axis_label : typing.Optional[str]
            Label for the Y-axis.

        unit : typing.Optional[str]
            The unit for the Y-axis values, e.g., 'MW'.

        formula : typing.Optional[str]
            Optional formula to combine datasets, e.g., 'dataset_1 + dataset_2'

        echarts_options : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Optional ECharts options for the chart.

        theme : typing.Optional[str]
            Theme name for the chart component, e.g., 'wind_dark', 'wind_light'.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TimeSeriesComponent
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardClient

        client = RebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )
        client.components.create_timeseries(
            name="name",
            title="title",
            datasets=["datasets"],
        )
        """
        _response = self._raw_client.create_timeseries(
            name=name,
            title=title,
            datasets=datasets,
            y_axis_label=y_axis_label,
            unit=unit,
            formula=formula,
            echarts_options=echarts_options,
            theme=theme,
            request_options=request_options,
        )
        return _response.data

    def list_components(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ListComponentsApiV1DashboardComponentsGetResponseItem]:
        """
        List all components in the user's library.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ListComponentsApiV1DashboardComponentsGetResponseItem]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardClient

        client = RebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )
        client.components.list_components()
        """
        _response = self._raw_client.list_components(request_options=request_options)
        return _response.data

    def get_component(
        self, component_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Retrieve a single component.

        Parameters
        ----------
        component_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardClient

        client = RebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )
        client.components.get_component(
            component_id="component_id",
        )
        """
        _response = self._raw_client.get_component(component_id, request_options=request_options)
        return _response.data

    def delete_component(
        self, component_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete a component from the user's library.

        Parameters
        ----------
        component_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardClient

        client = RebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )
        client.components.delete_component(
            component_id="component_id",
        )
        """
        _response = self._raw_client.delete_component(component_id, request_options=request_options)
        return _response.data

    def update_map(
        self,
        component_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        config: typing.Optional[MapConfig] = OMIT,
        layer_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MapComponent:
        """
        Update a map component.

        Parameters
        ----------
        component_id : str

        name : typing.Optional[str]
            Updated component name

        config : typing.Optional[MapConfig]
            Updated map configuration

        layer_ids : typing.Optional[typing.Sequence[str]]
            Updated list of layer IDs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MapComponent
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardClient

        client = RebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )
        client.components.update_map(
            component_id="component_id",
        )
        """
        _response = self._raw_client.update_map(
            component_id, name=name, config=config, layer_ids=layer_ids, request_options=request_options
        )
        return _response.data

    def update_timeseries(
        self,
        component_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        y_axis_label: typing.Optional[str] = OMIT,
        unit: typing.Optional[str] = OMIT,
        datasets: typing.Optional[typing.Sequence[str]] = OMIT,
        formula: typing.Optional[str] = OMIT,
        echarts_options: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        theme: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TimeSeriesComponent:
        """
        Update a timeseries component.

        Parameters
        ----------
        component_id : str

        name : typing.Optional[str]
            Updated component name

        title : typing.Optional[str]
            Updated chart title

        y_axis_label : typing.Optional[str]
            Updated Y-axis label

        unit : typing.Optional[str]
            Updated unit for Y-axis values

        datasets : typing.Optional[typing.Sequence[str]]
            Updated list of timeseries dataset IDs

        formula : typing.Optional[str]
            Updated formula to combine datasets

        echarts_options : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Updated ECharts options

        theme : typing.Optional[str]
            Updated theme name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TimeSeriesComponent
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardClient

        client = RebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )
        client.components.update_timeseries(
            component_id="component_id",
        )
        """
        _response = self._raw_client.update_timeseries(
            component_id,
            name=name,
            title=title,
            y_axis_label=y_axis_label,
            unit=unit,
            datasets=datasets,
            formula=formula,
            echarts_options=echarts_options,
            theme=theme,
            request_options=request_options,
        )
        return _response.data


class AsyncComponentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawComponentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawComponentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawComponentsClient
        """
        return self._raw_client

    async def create_map(
        self,
        *,
        name: str,
        config: MapConfig,
        layer_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MapComponent:
        """
        Create a new map component.

        Parameters
        ----------
        name : str

        config : MapConfig

        layer_ids : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MapComponent
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardClient, MapConfig

        client = AsyncRebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.components.create_map(
                name="name",
                config=MapConfig(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_map(
            name=name, config=config, layer_ids=layer_ids, request_options=request_options
        )
        return _response.data

    async def create_timeseries(
        self,
        *,
        name: str,
        title: str,
        datasets: typing.Sequence[str],
        y_axis_label: typing.Optional[str] = OMIT,
        unit: typing.Optional[str] = OMIT,
        formula: typing.Optional[str] = OMIT,
        echarts_options: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        theme: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TimeSeriesComponent:
        """
        Create a new time series component.

        Parameters
        ----------
        name : str

        title : str
            The user-defined title of the chart.

        datasets : typing.Sequence[str]
            List of timeseries dataset IDs to display on this chart.

        y_axis_label : typing.Optional[str]
            Label for the Y-axis.

        unit : typing.Optional[str]
            The unit for the Y-axis values, e.g., 'MW'.

        formula : typing.Optional[str]
            Optional formula to combine datasets, e.g., 'dataset_1 + dataset_2'

        echarts_options : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Optional ECharts options for the chart.

        theme : typing.Optional[str]
            Theme name for the chart component, e.g., 'wind_dark', 'wind_light'.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TimeSeriesComponent
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardClient

        client = AsyncRebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.components.create_timeseries(
                name="name",
                title="title",
                datasets=["datasets"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_timeseries(
            name=name,
            title=title,
            datasets=datasets,
            y_axis_label=y_axis_label,
            unit=unit,
            formula=formula,
            echarts_options=echarts_options,
            theme=theme,
            request_options=request_options,
        )
        return _response.data

    async def list_components(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ListComponentsApiV1DashboardComponentsGetResponseItem]:
        """
        List all components in the user's library.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ListComponentsApiV1DashboardComponentsGetResponseItem]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardClient

        client = AsyncRebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.components.list_components()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_components(request_options=request_options)
        return _response.data

    async def get_component(
        self, component_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Retrieve a single component.

        Parameters
        ----------
        component_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardClient

        client = AsyncRebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.components.get_component(
                component_id="component_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_component(component_id, request_options=request_options)
        return _response.data

    async def delete_component(
        self, component_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete a component from the user's library.

        Parameters
        ----------
        component_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardClient

        client = AsyncRebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.components.delete_component(
                component_id="component_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_component(component_id, request_options=request_options)
        return _response.data

    async def update_map(
        self,
        component_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        config: typing.Optional[MapConfig] = OMIT,
        layer_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MapComponent:
        """
        Update a map component.

        Parameters
        ----------
        component_id : str

        name : typing.Optional[str]
            Updated component name

        config : typing.Optional[MapConfig]
            Updated map configuration

        layer_ids : typing.Optional[typing.Sequence[str]]
            Updated list of layer IDs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MapComponent
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardClient

        client = AsyncRebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.components.update_map(
                component_id="component_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_map(
            component_id, name=name, config=config, layer_ids=layer_ids, request_options=request_options
        )
        return _response.data

    async def update_timeseries(
        self,
        component_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        y_axis_label: typing.Optional[str] = OMIT,
        unit: typing.Optional[str] = OMIT,
        datasets: typing.Optional[typing.Sequence[str]] = OMIT,
        formula: typing.Optional[str] = OMIT,
        echarts_options: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        theme: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TimeSeriesComponent:
        """
        Update a timeseries component.

        Parameters
        ----------
        component_id : str

        name : typing.Optional[str]
            Updated component name

        title : typing.Optional[str]
            Updated chart title

        y_axis_label : typing.Optional[str]
            Updated Y-axis label

        unit : typing.Optional[str]
            Updated unit for Y-axis values

        datasets : typing.Optional[typing.Sequence[str]]
            Updated list of timeseries dataset IDs

        formula : typing.Optional[str]
            Updated formula to combine datasets

        echarts_options : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Updated ECharts options

        theme : typing.Optional[str]
            Updated theme name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TimeSeriesComponent
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardClient

        client = AsyncRebaseDashboardClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.components.update_timeseries(
                component_id="component_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_timeseries(
            component_id,
            name=name,
            title=title,
            y_axis_label=y_axis_label,
            unit=unit,
            datasets=datasets,
            formula=formula,
            echarts_options=echarts_options,
            theme=theme,
            request_options=request_options,
        )
        return _response.data
