# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .geometrytype import Geometrytype


class Typeconfig_Geospatial(UniversalBaseModel):
    data_type: typing_extensions.Annotated[typing.Literal["geospatial"], FieldMetadata(alias="dataType")] = "geospatial"
    coordinate_system: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="coordinateSystem")] = None
    geometry_type: typing_extensions.Annotated[Geometrytype, FieldMetadata(alias="geometryType")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Typeconfig_Tabular(UniversalBaseModel):
    data_type: typing_extensions.Annotated[typing.Literal["tabular"], FieldMetadata(alias="dataType")] = "tabular"
    column_schema: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, str]], FieldMetadata(alias="columnSchema")
    ] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Typeconfig_Timeseries(UniversalBaseModel):
    data_type: typing_extensions.Annotated[typing.Literal["timeseries"], FieldMetadata(alias="dataType")] = "timeseries"
    unit: typing.Optional[str] = None
    forecast_type: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="forecastType")] = None
    price_area: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="priceArea")] = None
    forecast_horizon: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="forecastHorizon")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


Typeconfig = typing.Union[Typeconfig_Geospatial, Typeconfig_Tabular, Typeconfig_Timeseries]
