# Формат файла экспорта/импорта

Файл в кодировке, указанной в атрибуте `ENCODING` класса `File` с разделителем колонок ';' и первой строкой, содержащей заголовки колонок данных.
Файл содержит 27 колонок. Часть колонок интерпретируется одинаково для всех типов обьектов.
Для другой части колонок их данные интерпретируются в зависимости от типа обьекта в конкретной строке.

## Общие колонки для всех типов обьектов

### Дистанция по одометру

Номер колонки '01' заголовок 'DistOd'

Дистанция обьекта в записи в миллиметрах (целое число).

### Тип обьекта

Номер колонки '02' заголовок 'TypeObject'

Один из следующих кодов, задающих тип обьекта в строке

- 0 Швы
- 1 Маркеры
- 2 Дефекты
- 3 Переход толщины
- 4 Продольный шов
- 5 Категория трубопровода
- 6 Переход (изменение) диаметра

### Код обьекта

Колонка '03' Object_Code по умолчанию должна содержать 0. Значение этой колонки может быть переопределено некоторыми типами обьектов.

### Маркер

Номер колонки '06' заголовок 'Marker'

Логическое значение ЛОЖЬ/ИСТИНА указывающее, следует ли использовать данный обьект как маркер при привязке к маркерам других обьектов.

### Комментарий

Номер колонки '24' заголовок 'Comments'

Текст примечания длиной до 50 символов.

### Геокоординаты

- 25 Latitude Широта
- 26 Longtitude Долгота
- 27 Altitude Высота

Числа с плавающей точкой, представляющие  гео-координаты обьекта.

### Опциональный идентификатор

Номер колонки '16' заголовок 'DistML'

Если задано, то должно содержать уникальный для данной колонки идентификатор обьекта (строка).

### Пользовательские данные

Номер колонки '17' заголовок 'DistMR'

Если задано, то содержит данные пользователя (строка).

### Колонки, используемые для привязки обьектов к маркерам и швам в экспресс-отчете InspectionViewer

- 18 DistStL Дистанция до стыка слева в мм.
- 19 DistStR Дистанция до стыка справа в мм.
- 20 LinkStL Имя шва слева к которому привязан объект - значение из поля  ObjectName. Текст до 20 символов длиной.
- 21 LinkStR Имя шва справа к которому привязан объект - значение из поля  ObjectName. Текст до 20 символов длиной.
- 22 LinkML Имя маркера слева к которому привязан объект - значение из поля  ObjectName. Текст до 20 символов длиной.
- 23 LinkMR Имя маркера справа к которому привязан объект - значение из поля  ObjectName. Текст до 20 символов длиной.

Данные колонки должны игнорироваться внешними программами и при создании csv файла для импорта в InspectionViewer оставаться пустыми.

## Колонки специфичные для типа обьекта

Следующие колонки могут интерпретироваться по разному, в зависимости от типа обьекта, указанного в колонке 02 'TypeObject'.

- 03 Object_Code
- 04 ObjectName
- 05 Object_Code_T
- 07 Length
- 08 Width
- 09 Depth_min
- 10 Depth_max
- 11 OrientTD
- 12 OrientBD
- 13 MPoint_Orient
- 14 MPoint_Dist
- 15 Type_Def

### Швы

Если значение колонки 02 TypeObject установлено в 0 (Шов)

Колонка 03 Object_Code должна содержать код 0

Колонка 04 ObjectName может содержать пользовательский номер трубы (произвольная строка).

Колонка 05 Object_Code_T может содержать текстовое название обьекта, например 'Шов'.

Колонка 09 Depth_min может содержать радиус изгиба трубы в ее диаметрах (с плавающей точкой).

Колонка 10 Depth_max может содержать минимальное проходное сечение трубы в мм (строка).

Остальные колонки должны быть пустыми.

### Маркеры

Если значение колонки 02 TypeObject установлено в 1 (Маркер).

Колонка 03 Object_Code должна содержать код объекта.

- 0 Кран
- 1 Маркер 
- 2 Маркер магнитный
- 3 Отвод-врезка
- 4 Тройник
- 5 Патрон начало
- 6 Патрон конец
- 7 Место ремонта
- 8 Пригруз
- 9 Отвод (поворот) начало
- 10 Отвод (поворот) конец
- 11 Особенность 
- 12 Гнутая секция
- 13 Сегмент поворота

Колонка 05 Object_Code_T может содержать текстовое название обьекта, например 'Кран'.

Остальные колонки должны быть пустыми.

### Дефекты

Если значение колонки 02 TypeObject установлено в 2 (Дефект)

Колонка 03 Object_Code должна содержать один из следующих кодов.

- 0 Коррозия 
- 1 Механическое повреждение
- 2 Вмятина
- 3 Вмятина с дефектами потери металла
- 4 Гофра
- 5 Аномалия кольцевого шва
- 6 Технологический дефект
- 7 Заводской дефект
- 8 Дополнительный металл/материал
- 9 Другое
- 10 Зона продольных трещин 
- 11 Трещиноподобный дефект
- 12 Трещина на кольцевом шве
- 13 Расслоение
- 14 Аномалия продольного шва
- 15 Аномалия спирального шва
- 16 Эллипсность 
- 17 Поджиг 
- 18 Зашлифовка

Колонка 05 Object_Code_T может содержать текстовое название обьекта, например 'Коррозия'.

Остальные колонки должны содержать параметры дефекта

- 07 Length Длина в мм
- 08 Width Ширина в мм
- 09 Depth_min Минимальная глубина в %% либо сотых долях мм в зависимости от значения Row.depth_units
- 10 Depth_max Максимальная глубина в %% либо сотых долях мм в зависимости от значения Row.depth_units
- 11 OrientTD Начало угловой ориентации в формате "часы,минуты"
- 12 OrientBD Конец угловой ориентации в формате "часы,минуты"
- 13 MPoint_Orient Ориентация точки с макс глубиной в формате "часы,минуты"
- 14 MPoint_Dist Дистанция точки с максимальной глубиной в мм
- 15 Type_Def Код типа дефекта

Код типа дефекта должен быть одним из следующих:

- 0 не определено
- 1 наружная
- 2 внутренняя
- 3 внутристенная коррозия

### Изменение толщины стенки трубы

Если значение колонки 02 TypeObject установлено в 3 (Переход толщины)

Колонка 03 Object_Code должна содержать код 0

Колонка 05 Object_Code_T может содержать текстовое название обьекта, например 'Изменение толщины стенки трубы'.

Колонка 10 Depth_max должна содержать значение толщины стенки трубы в десятых долях миллиметра.
Например, значение 107 соответствует тольщине стенки в 10.7 мм.

Остальные колонки должны быть пустыми.

### Продольный шов

Если значение колонки 02 TypeObject установлено в 4 (Продольный шов)

Колонка 03 Object_Code должна содержать один из следующих кодов.

- 0 Продольный шов. Колонка 11 OrientTD должна содержать ориентацию шва в формате "часы,минуты"
- 1 Двойной прод. шов Колонки 11 OrientTD и 12 OrientBD должны содержать ориентации двух швов в формате "часы,минуты"
- 2 Цельнотянутая труба.
- 3 Спиральный шов. Колонка 11 OrientTD должна содержать ориентацию точки примыкания спирального шва к ближайшему поперемному шву в формате "часы,минуты".

Для спиралешовной трубы указываются два обьекта "Спиральный шов", задающие примыкание спирального шва к начальному и конечному поперечному шву.

Остальные колонки должны быть пустыми.

### Категория трубопровода

Если значение колонки 02 TypeObject установлено в 5 (Категория трубопровода)

Колонка 03 Object_Code должна содержать код 0.

Колонка 05 Object_Code_T может содержать текстовое название обьекта, например 'Категория трубопровода'.

Колонка 10 Depth_max должна содержать код категории трубопровода.

Остальные колонки должны быть пустыми.

### Переход диаметра

Если значение колонки 02 TypeObject установлено в 6 (Переход диаметра)

Колонка 03 Object_Code должна содержать код 0

Колонка 05 Object_Code_T может содержать текстовое название обьекта, например 'Изменение диаметра трубы'.

Колонка 09 Depth_min должна содержать начальное значение диамера трубы в миллиметрах.

Колонка 10 Depth_max должна содержать конечное значение диамера трубы в миллиметрах.

Остальные колонки должны быть пустыми.

## Схема использования колонок по типам обьектов

```text
                                   All  Weld  Mark  Defect  Wall  Seam  Category  Diam
01 DistOd                          +    +     +     +       +     +     +         +
02 TypeObject                      +    +     +     +       +     +     +         +
03 Object_Code                          +     +     +       +     +     +         +
04 ObjectName                           +     +     
05 Object_Code_T                        +     +     +       +           +         +
06 Marker                          +    +     +     +       +     +     +         +
07 Length                                           +
08 Width                                            +
09 Depth_min                            +           +                             +
10 Depth_max                            +           +       +           +         +
11 OrientTD                                         +             +
12 OrientBD                                         +             +
13 MPoint_Orient                                    +
14 MPoint_Dist                                      +
15 Type_Def                                         +
16 DistML                          +    +     +     +       +     +     +         +
17 DistMR                          +    +     +     +       +     +     +         +
18 DistStL                         -      
19 DistStR                         -      
20 LinkStL                         -      
21 LinkStR                         -      
22 LinkML                          -     
23 LinkMR                          -     
24 Comments                        +    +     +     +       +     +     +         +
25 Latitude                        +    +     +     +       +     +     +         +
26 Longtitude                      +    +     +     +       +     +     +         +
27 Altitude                        +    +     +     +       +     +     +         +
```
