# -*- coding: utf-8 -*-
# Quasarr
# Project by https://github.com/rix1337

logo = 'data:image/png;base64,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'
al = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAA9UlEQVR4nBXBv0rDQADA4d8ld8EQ2yJiGxAchOqgQSFEEEGfQV18DgcHwYcQ36GDg07+wUlwcBApCnUrbYcKIrRIa0qTy534fSI+vbMCi7GSUe7zr6QmOEJjEUhhDcZReHLEQXiLNoKn4S66CHBMjjTKJ0+nHPZPOJrtEPguc+17GuE5fjCD9H57rHYuCT/H3HxUmaYp5aDPRnZBd2kfp9d6I15fYe/qmdryJiVvge3GI1tRnW7rHbF2fG0rXy9E5QFJnoFSNF1Jc1jhp5YgkrMHm2kYtF9R+TdYS6aqzNdjPBek0RolYDHaoSgsWHClQE/GGA1/SzpdtJMWu3cAAAAASUVORK5CYII='
by = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAMAAADz0U65AAAATlBMVEX///8crf/29fQDo//J7f/u7u7w+v/2/P/8/PyytLWenp6IhoWTwNfPz8+mpaVYxP94eHhryf+75fyB0f+oxNPl5eW4yNGrr68xsfmUlJQWKuGqAAAAQklEQVQI1yWLSRKAIBADMzOAsgiC+/8/aiwvSR+6AUB15mJyZ42ev8ldclI4MWvXuvwQCaGblPxQCmNP9fgyqGf+AkFFAeZ3L10cAAAAAElFTkSuQmCC'
dd = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAABCElEQVR4nAXBP0sCYRzA8e89d6eQ4SRkdNKQOEVSvQQbegdB4dAgLY1tLS1NvYFoDIIIGtqKXPq3JJGWEQkaDQliGJnaPXf6e/p8rGrt4/CxUl777fZQylYGg4iReHyMxez8kXN1c5c/Pj1D7AhKQqKujQgqCDSrK35evTca/InD+sYmyXSWdqeLFvCHhka9bpyvdgsdCpl0msRkin1/xMLcLKXbIs3mp6UG/R5vL2VKzzV29g4oFAokkh7XxQuGgcbxtTYy6Fr97xaZ6QmeHu55rVYIf9poHeAMR8ZCNLvbW8TGY5x0OrgK7KhLEIY4U6nUeS63tBwGWowR5dgziME4bsTyPO/yH3LufRKlNxKMAAAAAElFTkSuQmCC'
dt = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAA4ElEQVR4nD2PsWrCUBSGv3ubBoq+QevQUhAXV6dMRcyTZBV8CCfxCTq4ZOmSJwg+giB4t16p1NCpSFECyY2n5EL7LeeD8/PDr5qmEa01+XrNz35PaAxFUXCrNQ/DIVophbWW19WKt+WSp16PYLvlvtNBHY8ESZLg6ppPaxmMRgymUz4WC577fR5nM3SapryMx0RRxPf5jDjHXRi21bQEWZZhjCGeTIiDgOvpxM3hQLXb+QAiImVZSlVV0tS1XEXkPY7laz5vX0K74h/n/KnyXNxm41351B+tKoVcLt5Vt8svgsSBPKnRQSAAAAAASUVORK5CYII='
dw = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAA70lEQVR4nAXBTUrDQBiA4febmfjbpqZUsFkJxS6UIq4EvYS46CUExRPkBL2HFM/gIdxIFq4Ff2JNia3JzBefR+bzuZ1Op+E+y/q6Fd/GSe8qijZH1lpfN00uADdZNt5NDh7GJ8dng2HKxvYOBtB6jctms/5S3ePpxeWklw69tZE1IqKqrIxT81U1d4PReCJJ338HXBVURCCokhelMZW467YTt9pi1rUntPCHYJ0ljiyubMJh0yJFuZSk26ENjufPFV0CCeAUfLEo8V7pRBHWOMJvBc5Q+xpnIf8pl+fvi1Lztw9zlO6T7sWw9jy9vPIPUL1kPErau3YAAAAASUVORK5CYII='
fx = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAABB0lEQVR4nB2LP0sCcQBA3/2Uzugu8E4IoT9cSYhUENFWYSA1FFTQ4hK5SENNDW19hoYcImhvaGgLguYgcIk0haLOE7wrNGzo5A4v9K3vPWknmwt0LYrrunieTygkAAm300EIQTg5nWB3e5O39w9s54t4fISEYfBZq/H4VETIsoxp1ftyJpWkR7lSZXFhnsFIhLBtOxR9n1KliqZFeX4po+saZ4VLTMtC9M61TJrTk2OarR9WV5bIpJfZ2ljH8zxEw3EovVaZm01xd//AsKpwfXNLLKaTmDSQ9vJHwWE+x3ezRbv9i6oqTBkTmLU65xdXSNn9g0CWB2jYDuNjo/y5Lqoy1A+63S7/GeVj+5KBt3UAAAAASUVORK5CYII='
mb = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAABE0lEQVR4nAEIAff+AQAAAACHttAxAQ0Kjd7o7ToDAQH/GREOxcDT4HK+cErSAYy70DHs/AG6tNjoFNzn6gD5+fwAQjElAIE/JuqWxdZEBBwVD5RSIhsUnsTV/JBRNwT9/v4AjcDU/DsgOxbW6RqUArra5zf39vb/KRwTBKPN3gBMKhwA3unyBJHE2P/i7/U6Auvz+ACkzt4AaTkmAN/u9AARCQYAQysdALXW5ADl8fYAAi4bEMbD5vQBMxoR/CwYEACVxtkAfUMr/PoECAEZDwrFAiAPCmwpEAjq/gcKBAUDAQCQwtcAMSIZBDkbDukIBAJtAmU5KNIP//1F1ePrvScWD/hSLR/4uNXkvAHz9kZ+RS/T0LpzUht5tWAAAAAASUVORK5CYII='
nx = 'data:image/png;base64,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'
sf = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAA8ElEQVR4nBXBv0rDQADA4d/lz1lqmlREECUIFTq4FBeHDA6uPkRfwwfxBRx19gmk4GZBBAcjCAUrWEkaTUzucjnx+0R6kzQboZDCb7AWdNmiMo3KLHUmlCcDR/Z2DujvJXRth6kNqqgoXufo6kk6lpzwcEr7fUrx7POTugh9xPZkilE5jh9MsJ2mreaUi0eKdIa7CUIogjjB8wcnyOiM0rmkH+8ih8dY1gTxOeHoA69eLRCOxBvsE21JOmVo8gy3N6T+fMNbPdwiwzG6XFJ/vWC1xY9GvN9dsZxdI+4vxo3rtxLH8q/TFvPbYhqL0Z76AydWbEnTqqOqAAAAAElFTkSuQmCC'
sl = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAA/ElEQVR4nE3PrUpDYRzH8d/z5tnRozugImIYgjAwGY5egGUG64JRkxgWvIFV0zCIwVsQLLYhWgSDLizJiowVFUHZdJ7zvP7Ftu8NfPgybOwvImcFet0C6FhMtrYTSQg1Ru/id3W7sfTxmc3rQpeE4gk8BZJiigF1kWYLe9rSGZEvR4o/AvRAxBLB8SObzXVqXb/tBjFdJjOCtliJI/U6fDo/CQSwf4ozIM2OGrm2xyGEClQCReO76tZmTabZYcsHmnHOfSvJ+8axCiNtlJDtztdNkLmxbViyEIx7669YxPPlZG44uD99wXs9ltqNbvF8aSbvBgBH9WAWMZX+AJIYacQLryqFAAAAAElFTkSuQmCC'
wd = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAA90lEQVR4nC3OsS5DUQAG4P8/Pb2kiS4mliaEkMYgTBiQiMVk6C6RsHmAxuoFbHTzCmIR9QSWLko6kIiQCnqHq+fec84vEt8TfMS/5s3jniFf36uD9sTH6Fg9rQ8aDQY2r7trhJmFUY1kW9I4gF0I9wGuZUOM04x+B4o9EvMSZ0D1EVWYkklsnn51TFIOhJ2DwgaN6QiqgsbRh00rseu9J1WsUngGOBmhSvaZnZwdbA1MkWfrwQ2PvXMvwbk7n7taLPKppFpe+cvb8DN8gi09RGmkbEv9GHQLqQZi+bB19WZDdN+WlYskRe/0aNsBaO+fXy4ZxEWKC7/R+XkmFbstdAAAAABJRU5ErkJggg=='
