INSERT INTO <DATABASE_NAME>.pybrv_meta.pybrv_business_rule_check_result (
    batch_id,
    unique_rule_identifier,    
    execution_id,              
    team_name,                 
    rule_name,                 
    data_domain,               
    table_checked, 
    severity,
    rule_category,            
    bookmark_column_name,      
    bookmark_start_date,       
    bookmark_end_date,         
    status,                    
    pass_record_count,         
    fail_record_count,         
    pass_percentage,           
    threshold,                 
    failed_keys,               
    failed_query,              
    test_case_comments,        
    remarks,                   
    last_modified_ts
)
SELECT
    <BATCH_ID>,
    <UNIQUE_RULE_IDENTIFIER>,
    <EXECUTION_ID>,
    '<TEAM_NAME>',
    '<RULE_NAME>',
    '<DOMAIN_NAME>',
    '<TABLES_CHECKED>',
    '<SEVERITY>',
    '<RULE_CATEGORY>',
    '<BOOKMARK_COLUMN>',
    '<BOOKMARK_START_DATE>'::DATE,  
    '<BOOKMARK_END_DATE>'::DATE,   
    <STATUS>,
    <PASS_RECORD_COUNT>,
    <FAIL_RECORD_COUNT>,
    <PASS_PERCENTAGE>,
    <PASS_THRESHOLD>,
    '<FAILED_KEYS>',
    '<FAILED_QUERY>',
    '<COMMENTS>',
    '<REMARKS>',
    CURRENT_TIMESTAMP AT TIME ZONE 'UTC' AS LAST_MODIFIED_TS;  



