<TAGS>
MERGE INTO <DATABASE_NAME>.pybrv_meta.pybrv_unique_rule_mapping AS target 
USING (
    SELECT 
        <UNIQUE_RULE_IDENTIFIER> AS UNIQUE_RULE_IDENTIFIER
) AS source
ON target.UNIQUE_RULE_IDENTIFIER = source.UNIQUE_RULE_IDENTIFIER

WHEN MATCHED THEN 
UPDATE SET
    TEAM_NAME = '<TEAM_NAME>',
    data_domain = '<DOMAIN_NAME>',
    RULE_CATEGORY = '<RULE_CATEGORY_NAME>',
    RULE_ID = <RULE_ID>,
    RULE_NAME = '<RULE_NAME>',
    LAST_MODIFIED_TS = CURRENT_TIMESTAMP

WHEN NOT MATCHED THEN 
INSERT (
    UNIQUE_RULE_IDENTIFIER,
    TEAM_NAME,
    data_domain,
    RULE_CATEGORY,
    RULE_ID,
    RULE_NAME,
    LAST_MODIFIED_TS
)
VALUES (
    <UNIQUE_RULE_IDENTIFIER>,
    '<TEAM_NAME>',
    '<DOMAIN_NAME>',
    '<RULE_CATEGORY_NAME>',
    <RULE_ID>,
    '<RULE_NAME>',
   CURRENT_TIMESTAMP
);
