# coding: utf-8

"""
    Workspace Data Service

    This page lists current APIs.  All v0.2 APIs are subject to change without notice.  Changelog at [https://github.com/DataBiosphere/terra-workspace-data-service/releases](https://github.com/DataBiosphere/terra-workspace-data-service/releases) 

    The version of the OpenAPI document: v0.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from wds_client.models.attribute_schema import AttributeSchema
from typing import Optional, Set
from typing_extensions import Self

class RecordTypeSchema(BaseModel):
    """
    RecordTypeSchema
    """ # noqa: E501
    name: StrictStr = Field(description="Record type name, valid characters for record type names are limited to letters, numbers, spaces, dashes, and underscores.")
    attributes: List[AttributeSchema]
    count: StrictInt = Field(description="Number of records of this type")
    primary_key: StrictStr = Field(description="Attribute name that contains the value to uniquely identify each record, defined as a primary key column in the underlying table.", alias="primaryKey")
    __properties: ClassVar[List[str]] = ["name", "attributes", "count", "primaryKey"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RecordTypeSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item_attributes in self.attributes:
                if _item_attributes:
                    _items.append(_item_attributes.to_dict())
            _dict['attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RecordTypeSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "attributes": [AttributeSchema.from_dict(_item) for _item in obj["attributes"]] if obj.get("attributes") is not None else None,
            "count": obj.get("count"),
            "primaryKey": obj.get("primaryKey")
        })
        return _obj


