# Generated by Django 4.2.4 on 2023-10-27 08:49
import os

from django.contrib.auth.hashers import make_password

import app.users.models
from django.db import migrations, models
import django.utils.timezone


def create_superuser(apps, schema_editor):
    user_model = apps.get_model("users", "User")
    user_model.objects.create(
        email=os.environ.get("SUPER_USER_EMAIL"),
        password=make_password(os.environ.get("SUPER_USER_PASSWORD")),
        is_staff=True,
        is_superuser=True,
    )


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="User",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("password", models.CharField(max_length=128, verbose_name="password")),
                (
                    "last_login",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="last login"
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="생성일시"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="수정일시"),
                ),
                (
                    "email",
                    models.EmailField(max_length=254, unique=True, verbose_name="이메일"),
                ),
                ("is_staff", models.BooleanField(default=False, verbose_name="스태프")),
                (
                    "is_superuser",
                    models.BooleanField(default=False, verbose_name="슈퍼 유저 여부"),
                ),
                ("is_active", models.BooleanField(default=True, verbose_name="활성화 여부")),
                (
                    "date_joined",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="가입일"
                    ),
                ),
            ],
            options={
                "verbose_name": "사용자",
                "verbose_name_plural": "사용자",
                "db_table": "users",
            },
            managers=[
                ("objects", app.users.models.UserManager()),
            ],
        ),
        migrations.RunPython(create_superuser),
    ]
