# Cost

Here we discuss some aspects regarding the economic cost of running the Denario agents.

## How Much Money Is Needed?

With $10, it is possible to generate hundreds of ideas, methods, and draft hundreds of papers, provided the analysis has already been completed. Running analyses (i.e., obtaining actual results) remains inexpensive when using lightweight models such as gpt-4o-mini. Most papers produced with the first public release of Denario were generated using either gemini-2.5-pro or gpt-4.1, which are more resource-intensive and costly. Generating research analysis for a single idea typically costs around $2–$5 with these models.

## Risk of Overspending

Careful monitoring of LLM provider usage is essential. API keys should never be shared, and it is important to supervise Denario's output to avoid unnecessary expenses, such as the system getting stuck on an indentation bug or other irrelevant issues. The same precautions apply as with other AI automation tools, such as Claude Code or Cursor agents.

## Rate Limits

New users are likely to encounter token rate limits when using OpenAI models. This may cause Denario to pause temporarily if too much text or code is generated. To increase token rate limits, refer to [OpenAI's rate limit documentation](https://platform.openai.com/docs/guides/rate-limits).

If rate limits are a problem for you, please contact us at [denario.astropilot.ai@gmail.com](mailto:denario.astropilot.ai@gmail.com).

!!! warning

    Never share your API keys. Always monitor your usage and costs on each provider's platform.
