"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListOnPremisesInstancesCommand = exports.$Command = void 0;
const middleware_endpoint_1 = require("@smithy/middleware-endpoint");
const middleware_serde_1 = require("@smithy/middleware-serde");
const smithy_client_1 = require("@smithy/smithy-client");
Object.defineProperty(exports, "$Command", { enumerable: true, get: function () { return smithy_client_1.Command; } });
const EndpointParameters_1 = require("../endpoint/EndpointParameters");
const Aws_json1_1_1 = require("../protocols/Aws_json1_1");
class ListOnPremisesInstancesCommand extends smithy_client_1.Command
    .classBuilder()
    .ep({
    ...EndpointParameters_1.commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        (0, middleware_serde_1.getSerdePlugin)(config, this.serialize, this.deserialize),
        (0, middleware_endpoint_1.getEndpointPlugin)(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CodeDeploy_20141006", "ListOnPremisesInstances", {})
    .n("CodeDeployClient", "ListOnPremisesInstancesCommand")
    .f(void 0, void 0)
    .ser(Aws_json1_1_1.se_ListOnPremisesInstancesCommand)
    .de(Aws_json1_1_1.de_ListOnPremisesInstancesCommand)
    .build() {
}
exports.ListOnPremisesInstancesCommand = ListOnPremisesInstancesCommand;
