"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilDeploymentSuccessful = exports.waitForDeploymentSuccessful = void 0;
const util_waiter_1 = require("@smithy/util-waiter");
const GetDeploymentCommand_1 = require("../commands/GetDeploymentCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new GetDeploymentCommand_1.GetDeploymentCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.deploymentInfo.status;
            };
            if (returnComparator() === "Succeeded") {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                return result.deploymentInfo.status;
            };
            if (returnComparator() === "Failed") {
                return { state: util_waiter_1.WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                return result.deploymentInfo.status;
            };
            if (returnComparator() === "Stopped") {
                return { state: util_waiter_1.WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForDeploymentSuccessful = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    return (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForDeploymentSuccessful = waitForDeploymentSuccessful;
const waitUntilDeploymentSuccessful = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    const result = await (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
    return (0, util_waiter_1.checkExceptions)(result);
};
exports.waitUntilDeploymentSuccessful = waitUntilDeploymentSuccessful;
