import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CodeDeployClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CodeDeployClient";
import { DeleteResourcesByExternalIdInput, DeleteResourcesByExternalIdOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DeleteResourcesByExternalIdCommand}.
 */
export interface DeleteResourcesByExternalIdCommandInput extends DeleteResourcesByExternalIdInput {
}
/**
 * @public
 *
 * The output of {@link DeleteResourcesByExternalIdCommand}.
 */
export interface DeleteResourcesByExternalIdCommandOutput extends DeleteResourcesByExternalIdOutput, __MetadataBearer {
}
declare const DeleteResourcesByExternalIdCommand_base: {
    new (input: DeleteResourcesByExternalIdCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteResourcesByExternalIdCommandInput, DeleteResourcesByExternalIdCommandOutput, CodeDeployClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * @public
 * <p>Deletes resources linked to an external ID. This action only applies if you have
 *             configured blue/green deployments through CloudFormation. </p>
 *          <note>
 *             <p>It is not necessary to call this action directly. CloudFormation calls it
 *                 on your behalf when it needs to delete stack resources. This action is offered
 *                 publicly in case you need to delete resources to comply with General Data Protection
 *                 Regulation (GDPR) requirements.</p>
 *          </note>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CodeDeployClient, DeleteResourcesByExternalIdCommand } from "@aws-sdk/client-codedeploy"; // ES Modules import
 * // const { CodeDeployClient, DeleteResourcesByExternalIdCommand } = require("@aws-sdk/client-codedeploy"); // CommonJS import
 * const client = new CodeDeployClient(config);
 * const input = { // DeleteResourcesByExternalIdInput
 *   externalId: "STRING_VALUE",
 * };
 * const command = new DeleteResourcesByExternalIdCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DeleteResourcesByExternalIdCommandInput - {@link DeleteResourcesByExternalIdCommandInput}
 * @returns {@link DeleteResourcesByExternalIdCommandOutput}
 * @see {@link DeleteResourcesByExternalIdCommandInput} for command's `input` shape.
 * @see {@link DeleteResourcesByExternalIdCommandOutput} for command's `response` shape.
 * @see {@link CodeDeployClientResolvedConfig | config} for CodeDeployClient's `config` shape.
 *
 * @throws {@link CodeDeployServiceException}
 * <p>Base exception class for all service exceptions from CodeDeploy service.</p>
 *
 */
export declare class DeleteResourcesByExternalIdCommand extends DeleteResourcesByExternalIdCommand_base {
}
