"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveAWSSDKSigV4Config = exports.resolveAwsSdkSigV4Config = void 0;
const core_1 = require("@smithy/core");
const signature_v4_1 = require("@smithy/signature-v4");
const resolveAwsSdkSigV4Config = (config) => {
    let normalizedCreds;
    if (config.credentials) {
        normalizedCreds = (0, core_1.memoizeIdentityProvider)(config.credentials, core_1.isIdentityExpired, core_1.doesIdentityRequireRefresh);
    }
    if (!normalizedCreds) {
        if (config.credentialDefaultProvider) {
            normalizedCreds = (0, core_1.normalizeProvider)(config.credentialDefaultProvider(config));
        }
        else {
            normalizedCreds = async () => { throw new Error("`credentials` is missing"); };
        }
    }
    const { signingEscapePath = true, systemClockOffset = config.systemClockOffset || 0, sha256, } = config;
    let signer;
    if (config.signer) {
        signer = (0, core_1.normalizeProvider)(config.signer);
    }
    else if (config.regionInfoProvider) {
        signer = () => (0, core_1.normalizeProvider)(config.region)()
            .then(async (region) => [
            (await config.regionInfoProvider(region, {
                useFipsEndpoint: await config.useFipsEndpoint(),
                useDualstackEndpoint: await config.useDualstackEndpoint(),
            })) || {},
            region,
        ])
            .then(([regionInfo, region]) => {
            const { signingRegion, signingService } = regionInfo;
            config.signingRegion = config.signingRegion || signingRegion || region;
            config.signingName = config.signingName || signingService || config.serviceId;
            const params = {
                ...config,
                credentials: normalizedCreds,
                region: config.signingRegion,
                service: config.signingName,
                sha256,
                uriEscapePath: signingEscapePath,
            };
            const SignerCtor = config.signerConstructor || signature_v4_1.SignatureV4;
            return new SignerCtor(params);
        });
    }
    else {
        signer = async (authScheme) => {
            authScheme = Object.assign({}, {
                name: "sigv4",
                signingName: config.signingName || config.defaultSigningName,
                signingRegion: await (0, core_1.normalizeProvider)(config.region)(),
                properties: {},
            }, authScheme);
            const signingRegion = authScheme.signingRegion;
            const signingService = authScheme.signingName;
            config.signingRegion = config.signingRegion || signingRegion;
            config.signingName = config.signingName || signingService || config.serviceId;
            const params = {
                ...config,
                credentials: normalizedCreds,
                region: config.signingRegion,
                service: config.signingName,
                sha256,
                uriEscapePath: signingEscapePath,
            };
            const SignerCtor = config.signerConstructor || signature_v4_1.SignatureV4;
            return new SignerCtor(params);
        };
    }
    return {
        ...config,
        systemClockOffset,
        signingEscapePath,
        credentials: normalizedCreds,
        signer,
    };
};
exports.resolveAwsSdkSigV4Config = resolveAwsSdkSigV4Config;
exports.resolveAWSSDKSigV4Config = exports.resolveAwsSdkSigV4Config;
