# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from .......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .cipher_algorithm import CipherAlgorithm
from .host_key_algorithm import HostKeyAlgorithm
from .key_exchange_algorithm import KeyExchangeAlgorithm
from .mac_algorithm import MacAlgorithm
from .ssh_auth_method import SshAuthMethod


class SshServerInfo(UniversalBaseModel):
    server_version: typing.Optional[str] = pydantic.Field(alias="serverVersion", default=None)
    target: typing.Optional[str] = None
    supported_auth_methods: typing.Optional[typing.List[SshAuthMethod]] = pydantic.Field(
        alias="supportedAuthMethods", default=None
    )
    supported_ciphers: typing.Optional[typing.List[CipherAlgorithm]] = pydantic.Field(
        alias="supportedCiphers", default=None
    )
    supported_macs: typing.Optional[typing.List[MacAlgorithm]] = pydantic.Field(alias="supportedMacs", default=None)
    supported_kex: typing.Optional[typing.List[KeyExchangeAlgorithm]] = pydantic.Field(
        alias="supportedKex", default=None
    )
    host_key_algos: typing.Optional[typing.List[HostKeyAlgorithm]] = pydantic.Field(alias="hostKeyAlgos", default=None)
    raw_ascii: typing.Optional[str] = pydantic.Field(alias="rawASCII", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow
