# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from .....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ....common.resources.protocol.resources.grpc.grpc_service import GrpcService
from ....common.resources.protocol.resources.ntlm.ntlm_os_info import NtlmOsInfo
from ....common.resources.protocol.resources.ntlm.ntlm_target_info import NtlmTargetInfo
from ....common.resources.protocol.resources.smb.smb_version import SmbVersion
from ....common.resources.protocol.resources.ssh.cipher_algorithm import CipherAlgorithm
from ....common.resources.protocol.resources.ssh.host_key_algorithm import HostKeyAlgorithm
from ....common.resources.protocol.resources.ssh.key_exchange_algorithm import KeyExchangeAlgorithm
from ....common.resources.protocol.resources.ssh.mac_algorithm import MacAlgorithm
from ....common.resources.protocol.resources.ssh.ssh_auth_method import SshAuthMethod


class ServiceMetadata_Generic(UniversalBaseModel):
    type: typing.Literal["generic"] = "generic"
    metadata: typing.Optional[typing.Dict[str, str]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Smb(UniversalBaseModel):
    type: typing.Literal["smb"] = "smb"
    smb_version: typing.Optional[SmbVersion] = pydantic.Field(alias="smbVersion", default=None)
    supported_smb_versions: typing.Optional[typing.List[SmbVersion]] = pydantic.Field(
        alias="supportedSmbVersions", default=None
    )
    signing_required: typing.Optional[bool] = pydantic.Field(alias="signingRequired", default=None)
    encryption_supported: typing.Optional[bool] = pydantic.Field(alias="encryptionSupported", default=None)
    encryption_required: typing.Optional[bool] = pydantic.Field(alias="encryptionRequired", default=None)
    lan_manager_version: typing.Optional[str] = pydantic.Field(alias="lanManagerVersion", default=None)
    mapped_os_version: typing.Optional[str] = pydantic.Field(alias="mappedOsVersion", default=None)
    target_info: typing.Optional[NtlmTargetInfo] = pydantic.Field(alias="targetInfo", default=None)
    os_info: typing.Optional[NtlmOsInfo] = pydantic.Field(alias="osInfo", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Ssh(UniversalBaseModel):
    type: typing.Literal["ssh"] = "ssh"
    server_version: typing.Optional[str] = pydantic.Field(alias="serverVersion", default=None)
    target: typing.Optional[str] = None
    supported_auth_methods: typing.Optional[typing.List[SshAuthMethod]] = pydantic.Field(
        alias="supportedAuthMethods", default=None
    )
    supported_ciphers: typing.Optional[typing.List[CipherAlgorithm]] = pydantic.Field(
        alias="supportedCiphers", default=None
    )
    supported_macs: typing.Optional[typing.List[MacAlgorithm]] = pydantic.Field(alias="supportedMacs", default=None)
    supported_kex: typing.Optional[typing.List[KeyExchangeAlgorithm]] = pydantic.Field(
        alias="supportedKex", default=None
    )
    host_key_algos: typing.Optional[typing.List[HostKeyAlgorithm]] = pydantic.Field(alias="hostKeyAlgos", default=None)
    raw_ascii: typing.Optional[str] = pydantic.Field(alias="rawASCII", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Ldap(UniversalBaseModel):
    type: typing.Literal["ldap"] = "ldap"
    base_dn: typing.Optional[str] = pydantic.Field(alias="baseDN", default=None)
    default_naming_context: typing.Optional[str] = pydantic.Field(alias="defaultNamingContext", default=None)
    schema_naming_context: typing.Optional[str] = pydantic.Field(alias="schemaNamingContext", default=None)
    configuration_naming_context: typing.Optional[str] = pydantic.Field(
        alias="configurationNamingContext", default=None
    )
    supports_tls: typing.Optional[bool] = pydantic.Field(alias="supportsTLS", default=None)
    supports_start_tls: typing.Optional[bool] = pydantic.Field(alias="supportsStartTLS", default=None)
    supports_sasl: typing.Optional[bool] = pydantic.Field(alias="supportsSASL", default=None)
    supported_ldap_version: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="supportedLdapVersion", default=None
    )
    supported_sasl_mechanisms: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="supportedSaslMechanisms", default=None
    )
    supported_capabilities: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="supportedCapabilities", default=None
    )
    anonymous_bind_allowed: typing.Optional[bool] = pydantic.Field(alias="anonymousBindAllowed", default=None)
    null_bind_allowed: typing.Optional[bool] = pydantic.Field(alias="nullBindAllowed", default=None)
    mapped_os_version: typing.Optional[str] = pydantic.Field(alias="mappedOsVersion", default=None)
    target_info: typing.Optional[NtlmTargetInfo] = pydantic.Field(alias="targetInfo", default=None)
    os_info: typing.Optional[NtlmOsInfo] = pydantic.Field(alias="osInfo", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Dns(UniversalBaseModel):
    type: typing.Literal["dns"] = "dns"
    response_code: typing.Optional[str] = pydantic.Field(alias="responseCode", default=None)
    authoritative: typing.Optional[bool] = None
    recursion_available: typing.Optional[bool] = pydantic.Field(alias="recursionAvailable", default=None)
    dns_version: typing.Optional[str] = pydantic.Field(alias="dnsVersion", default=None)
    edns_0_support: typing.Optional[bool] = pydantic.Field(alias="edns0Support", default=None)
    udp_buffer_size: typing.Optional[str] = pydantic.Field(alias="udpBufferSize", default=None)
    server_name: typing.Optional[str] = pydantic.Field(alias="serverName", default=None)
    supported_record_types: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="supportedRecordTypes", default=None
    )
    dnssec_enabled: typing.Optional[bool] = pydantic.Field(alias="dnssecEnabled", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Ntp(UniversalBaseModel):
    type: typing.Literal["ntp"] = "ntp"
    version: typing.Optional[str] = None
    stratum: typing.Optional[str] = None
    leap_indicator: typing.Optional[str] = pydantic.Field(alias="leapIndicator", default=None)
    mode: typing.Optional[str] = None
    reference_id: typing.Optional[str] = pydantic.Field(alias="referenceId", default=None)
    reference_ip: typing.Optional[str] = pydantic.Field(alias="referenceIp", default=None)
    root_delay: typing.Optional[str] = pydantic.Field(alias="rootDelay", default=None)
    root_dispersion: typing.Optional[str] = pydantic.Field(alias="rootDispersion", default=None)
    precision: typing.Optional[int] = None
    poll: typing.Optional[int] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Snmp(UniversalBaseModel):
    type: typing.Literal["snmp"] = "snmp"
    versions: typing.Optional[typing.List[str]] = None
    community_strings: typing.Optional[typing.List[str]] = pydantic.Field(alias="communityStrings", default=None)
    system_description: typing.Optional[str] = pydantic.Field(alias="systemDescription", default=None)
    v_3_engine_id: typing.Optional[str] = pydantic.Field(alias="v3EngineId", default=None)
    v_3_engine_id_format: typing.Optional[str] = pydantic.Field(alias="v3EngineIdFormat", default=None)
    v_3_engine_id_data: typing.Optional[str] = pydantic.Field(alias="v3EngineIdData", default=None)
    v_3_engine_boots: typing.Optional[int] = pydantic.Field(alias="v3EngineBoots", default=None)
    v_3_engine_time: typing.Optional[int] = pydantic.Field(alias="v3EngineTime", default=None)
    v_3_engine_uptime: typing.Optional[str] = pydantic.Field(alias="v3EngineUptime", default=None)
    v_3_enterprise: typing.Optional[int] = pydantic.Field(alias="v3Enterprise", default=None)
    v_3_enterprise_name: typing.Optional[str] = pydantic.Field(alias="v3EnterpriseName", default=None)
    sys_object_id: typing.Optional[str] = pydantic.Field(alias="sysObjectId", default=None)
    sys_uptime: typing.Optional[str] = pydantic.Field(alias="sysUptime", default=None)
    sys_contact: typing.Optional[str] = pydantic.Field(alias="sysContact", default=None)
    sys_name: typing.Optional[str] = pydantic.Field(alias="sysName", default=None)
    sys_location: typing.Optional[str] = pydantic.Field(alias="sysLocation", default=None)
    sys_services: typing.Optional[int] = pydantic.Field(alias="sysServices", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Mongodb(UniversalBaseModel):
    type: typing.Literal["mongodb"] = "mongodb"
    version: typing.Optional[str] = None
    build_info: typing.Optional[str] = pydantic.Field(alias="buildInfo", default=None)
    unauthenticated_access: typing.Optional[bool] = pydantic.Field(alias="unauthenticatedAccess", default=None)
    storage_engine: typing.Optional[str] = pydantic.Field(alias="storageEngine", default=None)
    replication_enabled: typing.Optional[bool] = pydantic.Field(alias="replicationEnabled", default=None)
    auth_mechanisms: typing.Optional[typing.List[str]] = pydantic.Field(alias="authMechanisms", default=None)
    max_bson_object_size: typing.Optional[int] = pydantic.Field(alias="maxBsonObjectSize", default=None)
    max_message_size_bytes: typing.Optional[int] = pydantic.Field(alias="maxMessageSizeBytes", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Grpc(UniversalBaseModel):
    type: typing.Literal["grpc"] = "grpc"
    reflection_supported: bool = pydantic.Field(alias="reflectionSupported")
    services: typing.Optional[typing.List[GrpcService]] = None
    raw_descriptor_set: typing.Optional[str] = pydantic.Field(alias="rawDescriptorSet", default=None)
    supported_compression: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="supportedCompression", default=None
    )
    max_message_size: typing.Optional[int] = pydantic.Field(alias="maxMessageSize", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Bgp(UniversalBaseModel):
    type: typing.Literal["bgp"] = "bgp"
    version: typing.Optional[str] = None
    message_type: typing.Optional[str] = pydantic.Field(alias="messageType", default=None)
    asn: typing.Optional[int] = None
    router_id: typing.Optional[str] = pydantic.Field(alias="routerId", default=None)
    hold_time: typing.Optional[int] = pydantic.Field(alias="holdTime", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Dcerpc(UniversalBaseModel):
    type: typing.Literal["dcerpc"] = "dcerpc"
    version: typing.Optional[str] = None
    packet_type: typing.Optional[str] = pydantic.Field(alias="packetType", default=None)
    fragment_length: typing.Optional[str] = pydantic.Field(alias="fragmentLength", default=None)
    interfaces: typing.Optional[typing.List[str]] = None
    auth_level: typing.Optional[str] = pydantic.Field(alias="authLevel", default=None)
    max_transmit_frag: typing.Optional[int] = pydantic.Field(alias="maxTransmitFrag", default=None)
    max_receive_frag: typing.Optional[int] = pydantic.Field(alias="maxReceiveFrag", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Ipp(UniversalBaseModel):
    type: typing.Literal["ipp"] = "ipp"
    server: typing.Optional[str] = None
    status_code: typing.Optional[str] = pydantic.Field(alias="statusCode", default=None)
    http_status: typing.Optional[str] = pydantic.Field(alias="httpStatus", default=None)
    scheme: typing.Optional[str] = None
    printer_name: typing.Optional[str] = pydantic.Field(alias="printerName", default=None)
    printer_state: typing.Optional[str] = pydantic.Field(alias="printerState", default=None)
    printer_uri: typing.Optional[typing.List[str]] = pydantic.Field(alias="printerUri", default=None)
    supported_operations: typing.Optional[typing.List[str]] = pydantic.Field(alias="supportedOperations", default=None)
    document_formats: typing.Optional[typing.List[str]] = pydantic.Field(alias="documentFormats", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Winrm(UniversalBaseModel):
    type: typing.Literal["winrm"] = "winrm"
    server: typing.Optional[str] = None
    status_code: typing.Optional[str] = pydantic.Field(alias="statusCode", default=None)
    scheme: typing.Optional[str] = None
    product_version: typing.Optional[str] = pydantic.Field(alias="productVersion", default=None)
    protocol_version: typing.Optional[str] = pydantic.Field(alias="protocolVersion", default=None)
    max_envelope_size: typing.Optional[int] = pydantic.Field(alias="maxEnvelopeSize", default=None)
    max_timeout_ms: typing.Optional[int] = pydantic.Field(alias="maxTimeoutMs", default=None)
    auth_schemes: typing.Optional[typing.List[str]] = pydantic.Field(alias="authSchemes", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Kerberos(UniversalBaseModel):
    type: typing.Literal["kerberos"] = "kerberos"
    krb_message: typing.Optional[str] = pydantic.Field(alias="krbMessage", default=None)
    error_code: typing.Optional[str] = pydantic.Field(alias="errorCode", default=None)
    realm: typing.Optional[str] = None
    supported_enctypes: typing.Optional[typing.List[str]] = pydantic.Field(alias="supportedEnctypes", default=None)
    kdc_address: typing.Optional[str] = pydantic.Field(alias="kdcAddress", default=None)
    pre_auth_required: typing.Optional[bool] = pydantic.Field(alias="preAuthRequired", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Sip(UniversalBaseModel):
    type: typing.Literal["sip"] = "sip"
    status: typing.Optional[str] = None
    server: typing.Optional[str] = None
    user_agent: typing.Optional[str] = pydantic.Field(alias="userAgent", default=None)
    allow: typing.Optional[str] = None
    supported_methods: typing.Optional[typing.List[str]] = pydantic.Field(alias="supportedMethods", default=None)
    supported_codecs: typing.Optional[typing.List[str]] = pydantic.Field(alias="supportedCodecs", default=None)
    registrar_uri: typing.Optional[str] = pydantic.Field(alias="registrarUri", default=None)
    realm: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Ssdp(UniversalBaseModel):
    type: typing.Literal["ssdp"] = "ssdp"
    status: typing.Optional[str] = None
    server: typing.Optional[str] = None
    location: typing.Optional[str] = None
    cache_control: typing.Optional[str] = pydantic.Field(alias="cacheControl", default=None)
    usn: typing.Optional[str] = None
    service_type: typing.Optional[str] = pydantic.Field(alias="serviceType", default=None)
    search_target: typing.Optional[str] = pydantic.Field(alias="searchTarget", default=None)
    ext: typing.Optional[str] = None
    boot_id: typing.Optional[str] = pydantic.Field(alias="bootId", default=None)
    config_id: typing.Optional[str] = pydantic.Field(alias="configId", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Tftp(UniversalBaseModel):
    type: typing.Literal["tftp"] = "tftp"
    opcode: typing.Optional[str] = None
    error_code: typing.Optional[str] = pydantic.Field(alias="errorCode", default=None)
    error_message: typing.Optional[str] = pydantic.Field(alias="errorMessage", default=None)
    block_number: typing.Optional[str] = pydantic.Field(alias="blockNumber", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Netbios(UniversalBaseModel):
    type: typing.Literal["netbios"] = "netbios"
    service: typing.Optional[str] = None
    netbios_names: typing.Optional[typing.List[str]] = pydantic.Field(alias="netbiosNames", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Ipmi(UniversalBaseModel):
    type: typing.Literal["ipmi"] = "ipmi"
    version: typing.Optional[str] = None
    auth_type: typing.Optional[str] = pydantic.Field(alias="authType", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Ubiquiti(UniversalBaseModel):
    type: typing.Literal["ubiquiti"] = "ubiquiti"
    protocol_version: typing.Optional[str] = pydantic.Field(alias="protocolVersion", default=None)
    command: typing.Optional[str] = None
    mac_address: typing.Optional[str] = pydantic.Field(alias="macAddress", default=None)
    mac_address_alt: typing.Optional[str] = pydantic.Field(alias="macAddressAlt", default=None)
    hostname: typing.Optional[str] = None
    model: typing.Optional[str] = None
    essid: typing.Optional[str] = None
    firmware: typing.Optional[str] = None
    uptime: typing.Optional[str] = None
    default: typing.Optional[str] = None
    locating: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Fgfm(UniversalBaseModel):
    type: typing.Literal["fgfm"] = "fgfm"
    vendor: typing.Optional[str] = None
    product: typing.Optional[str] = None
    certificate_authority: typing.Optional[str] = pydantic.Field(alias="certificateAuthority", default=None)
    support_domain: typing.Optional[str] = pydantic.Field(alias="supportDomain", default=None)
    management_enabled: typing.Optional[bool] = pydantic.Field(alias="managementEnabled", default=None)
    port: typing.Optional[int] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Pcworx(UniversalBaseModel):
    type: typing.Literal["pcworx"] = "pcworx"
    version: typing.Optional[str] = None
    device_type: typing.Optional[str] = pydantic.Field(alias="deviceType", default=None)
    device_name: typing.Optional[str] = pydantic.Field(alias="deviceName", default=None)
    project_name: typing.Optional[str] = pydantic.Field(alias="projectName", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Opcua(UniversalBaseModel):
    type: typing.Literal["opcua"] = "opcua"
    version: typing.Optional[str] = None
    server_name: typing.Optional[str] = pydantic.Field(alias="serverName", default=None)
    application_uri: typing.Optional[str] = pydantic.Field(alias="applicationUri", default=None)
    product_uri: typing.Optional[str] = pydantic.Field(alias="productUri", default=None)
    endpoint_url: typing.Optional[str] = pydantic.Field(alias="endpointUrl", default=None)
    security_mode: typing.Optional[str] = pydantic.Field(alias="securityMode", default=None)
    security_policy: typing.Optional[str] = pydantic.Field(alias="securityPolicy", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_X11(UniversalBaseModel):
    type: typing.Literal["x11"] = "x11"
    version: typing.Optional[str] = None
    protocol_major: typing.Optional[int] = pydantic.Field(alias="protocolMajor", default=None)
    protocol_minor: typing.Optional[int] = pydantic.Field(alias="protocolMinor", default=None)
    vendor: typing.Optional[str] = None
    release_number: typing.Optional[int] = pydantic.Field(alias="releaseNumber", default=None)
    auth_required: typing.Optional[bool] = pydantic.Field(alias="authRequired", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Xdmcp(UniversalBaseModel):
    type: typing.Literal["xdmcp"] = "xdmcp"
    version: typing.Optional[str] = None
    authentication_name: typing.Optional[typing.List[str]] = pydantic.Field(alias="authenticationName", default=None)
    status: typing.Optional[str] = None
    session_id: typing.Optional[str] = pydantic.Field(alias="sessionId", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Pcom(UniversalBaseModel):
    type: typing.Literal["pcom"] = "pcom"
    version: typing.Optional[str] = None
    plc_model: typing.Optional[str] = pydantic.Field(alias="plcModel", default=None)
    plc_name: typing.Optional[str] = pydantic.Field(alias="plcName", default=None)
    firmware_version: typing.Optional[str] = pydantic.Field(alias="firmwareVersion", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Iec104(UniversalBaseModel):
    type: typing.Literal["iec104"] = "iec104"
    version: typing.Optional[str] = None
    asdu_address: typing.Optional[str] = pydantic.Field(alias="asduAddress", default=None)
    cause_of_transmission: typing.Optional[str] = pydantic.Field(alias="causeOfTransmission", default=None)
    common_address: typing.Optional[str] = pydantic.Field(alias="commonAddress", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Ike(UniversalBaseModel):
    type: typing.Literal["ike"] = "ike"
    version: typing.Optional[str] = None
    initiator_spi: typing.Optional[str] = pydantic.Field(alias="initiatorSpi", default=None)
    responder_spi: typing.Optional[str] = pydantic.Field(alias="responderSpi", default=None)
    exchange_type: typing.Optional[str] = pydantic.Field(alias="exchangeType", default=None)
    flags: typing.Optional[str] = None
    message_id: typing.Optional[str] = pydantic.Field(alias="messageId", default=None)
    vendor_ids: typing.Optional[typing.List[str]] = pydantic.Field(alias="vendorIds", default=None)
    encryption_algorithms: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="encryptionAlgorithms", default=None
    )
    hash_algorithms: typing.Optional[typing.List[str]] = pydantic.Field(alias="hashAlgorithms", default=None)
    authentication_methods: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="authenticationMethods", default=None
    )
    dh_groups: typing.Optional[typing.List[str]] = pydantic.Field(alias="dhGroups", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Gesrtp(UniversalBaseModel):
    type: typing.Literal["gesrtp"] = "gesrtp"
    version: typing.Optional[str] = None
    device_type: typing.Optional[str] = pydantic.Field(alias="deviceType", default=None)
    firmware_version: typing.Optional[str] = pydantic.Field(alias="firmwareVersion", default=None)
    device_id: typing.Optional[str] = pydantic.Field(alias="deviceId", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Fins(UniversalBaseModel):
    type: typing.Literal["fins"] = "fins"
    version: typing.Optional[str] = None
    plc_model: typing.Optional[str] = pydantic.Field(alias="plcModel", default=None)
    node_address: typing.Optional[str] = pydantic.Field(alias="nodeAddress", default=None)
    unit_address: typing.Optional[str] = pydantic.Field(alias="unitAddress", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Atg(UniversalBaseModel):
    type: typing.Literal["atg"] = "atg"
    version: typing.Optional[str] = None
    manufacturer: typing.Optional[str] = None
    model: typing.Optional[str] = None
    tank_id: typing.Optional[str] = pydantic.Field(alias="tankId", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Ard(UniversalBaseModel):
    type: typing.Literal["ard"] = "ard"
    version: typing.Optional[str] = None
    machine_name: typing.Optional[str] = pydantic.Field(alias="machineName", default=None)
    os_version: typing.Optional[str] = pydantic.Field(alias="osVersion", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Slp(UniversalBaseModel):
    type: typing.Literal["slp"] = "slp"
    version: typing.Optional[str] = None
    services: typing.Optional[typing.List[str]] = None
    scopes: typing.Optional[typing.List[str]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Pptp(UniversalBaseModel):
    type: typing.Literal["pptp"] = "pptp"
    version: typing.Optional[str] = None
    hostname: typing.Optional[str] = None
    vendor: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Msmq(UniversalBaseModel):
    type: typing.Literal["msmq"] = "msmq"
    version: typing.Optional[str] = None
    queue_manager: typing.Optional[str] = pydantic.Field(alias="queueManager", default=None)
    machine_id: typing.Optional[str] = pydantic.Field(alias="machineId", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Mms(UniversalBaseModel):
    type: typing.Literal["mms"] = "mms"
    version: typing.Optional[str] = None
    vendor_name: typing.Optional[str] = pydantic.Field(alias="vendorName", default=None)
    model_name: typing.Optional[str] = pydantic.Field(alias="modelName", default=None)
    revision: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Hart(UniversalBaseModel):
    type: typing.Literal["hart"] = "hart"
    version: typing.Optional[str] = None
    device_type: typing.Optional[str] = pydantic.Field(alias="deviceType", default=None)
    manufacturer: typing.Optional[str] = None
    device_id: typing.Optional[str] = pydantic.Field(alias="deviceId", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Fox(UniversalBaseModel):
    type: typing.Literal["fox"] = "fox"
    version: typing.Optional[str] = None
    station_name: typing.Optional[str] = pydantic.Field(alias="stationName", default=None)
    host_id: typing.Optional[str] = pydantic.Field(alias="hostId", default=None)
    host_address: typing.Optional[str] = pydantic.Field(alias="hostAddress", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Memcached(UniversalBaseModel):
    type: typing.Literal["memcached"] = "memcached"
    version: typing.Optional[str] = None
    pid: typing.Optional[str] = None
    uptime: typing.Optional[str] = None
    pointer_size: typing.Optional[str] = pydantic.Field(alias="pointerSize", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


class ServiceMetadata_Unistream(UniversalBaseModel):
    type: typing.Literal["unistream"] = "unistream"
    version: typing.Optional[str] = None
    product_name: typing.Optional[str] = pydantic.Field(alias="productName", default=None)
    vendor_id: typing.Optional[str] = pydantic.Field(alias="vendorId", default=None)
    serial_number: typing.Optional[str] = pydantic.Field(alias="serialNumber", default=None)
    device_type: typing.Optional[str] = pydantic.Field(alias="deviceType", default=None)
    device_ip: typing.Optional[str] = pydantic.Field(alias="deviceIp", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow


ServiceMetadata = typing.Union[
    ServiceMetadata_Generic,
    ServiceMetadata_Smb,
    ServiceMetadata_Ssh,
    ServiceMetadata_Ldap,
    ServiceMetadata_Dns,
    ServiceMetadata_Ntp,
    ServiceMetadata_Snmp,
    ServiceMetadata_Mongodb,
    ServiceMetadata_Grpc,
    ServiceMetadata_Bgp,
    ServiceMetadata_Dcerpc,
    ServiceMetadata_Ipp,
    ServiceMetadata_Winrm,
    ServiceMetadata_Kerberos,
    ServiceMetadata_Sip,
    ServiceMetadata_Ssdp,
    ServiceMetadata_Tftp,
    ServiceMetadata_Netbios,
    ServiceMetadata_Ipmi,
    ServiceMetadata_Ubiquiti,
    ServiceMetadata_Fgfm,
    ServiceMetadata_Pcworx,
    ServiceMetadata_Opcua,
    ServiceMetadata_X11,
    ServiceMetadata_Xdmcp,
    ServiceMetadata_Pcom,
    ServiceMetadata_Iec104,
    ServiceMetadata_Ike,
    ServiceMetadata_Gesrtp,
    ServiceMetadata_Fins,
    ServiceMetadata_Atg,
    ServiceMetadata_Ard,
    ServiceMetadata_Slp,
    ServiceMetadata_Pptp,
    ServiceMetadata_Msmq,
    ServiceMetadata_Mms,
    ServiceMetadata_Hart,
    ServiceMetadata_Fox,
    ServiceMetadata_Memcached,
    ServiceMetadata_Unistream,
]
