# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from .....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .certificate import Certificate
from .cipher_suite import CipherSuite
from .tls_version import TlsVersion
from .tls_version_support import TlsVersionSupport


class TlsConfiguration(UniversalBaseModel):
    negotiated_version: TlsVersion = pydantic.Field(alias="negotiatedVersion")
    negotiated_cipher_suite: CipherSuite = pydantic.Field(alias="negotiatedCipherSuite")
    compression_enabled: bool = pydantic.Field(alias="compressionEnabled")
    secure_renegotiation_supported: bool = pydantic.Field(alias="secureRenegotiationSupported")
    version_support: typing.List[TlsVersionSupport] = pydantic.Field(alias="versionSupport")
    supported_elliptic_curves: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="supportedEllipticCurves", default=None
    )
    certificates: typing.List[Certificate]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            extra = pydantic.Extra.allow
