# eis_insurance
The EMIL InsuranceService API description

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.79.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.emil.de](https://www.emil.de)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install eis.insurance
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/emilDev/eis-insurance-sdk.git`)

Then import the package:
```python
import eis.insurance
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import eis.insurance
```

## Getting Started

The environment variables must be set in order to properly use this SDK.

```shell 
export EMIL_USERNAME=XXXXXXX
export EMIL_PASSWORD=XXXXXXX
```

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
import time
import eis.insurance
from pprint import pprint
from eis.insurance.api import booking_funnel_versions_api
# Defining the host is optional and defaults to https://apiv2.emil.de
# See configuration.py for a list of all supported configuration parameters.
configuration = eis.insurance.Configuration(
    host = "https://apiv2.emil.de"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Bearer is automatically handled with exported environment variables. However, you
# can manuallay configure Bearer authorization (JWT): bearer
configuration = eis.insurance.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# After manual token becomes invalid, the SDK will default to re-login automatically
# with environment variable credentials.


# Enter a context with an instance of the API client
with eis.insurance.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = booking_funnel_versions_api.BookingFunnelVersionsApi(api_client)
    code = "code_example" # str | 
    version = 3.14 # float | 
    authorization = "Authorization_example" # str | Bearer Token (optional)

    try:
        # Retrieve the booking funnel version
        api_instance.get_booking_funnel_version(code, version, authorization=authorization)
    except eis.insurance.ApiException as e:
        print("Exception when calling BookingFunnelVersionsApi->get_booking_funnel_version: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://apiv2.emil.de*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BookingFunnelVersionsApi* | [**get_booking_funnel_version**](docs/BookingFunnelVersionsApi.md#get_booking_funnel_version) | **GET** /insuranceservice/v1/booking-funnels/{code}/versions/{version} | Retrieve the booking funnel version
*BookingFunnelVersionsApi* | [**list_booking_funnel_versions**](docs/BookingFunnelVersionsApi.md#list_booking_funnel_versions) | **GET** /insuranceservice/v1/booking-funnels/{code}/versions | List booking funnel versions
*BookingFunnelsApi* | [**create_booking_funnel**](docs/BookingFunnelsApi.md#create_booking_funnel) | **POST** /insuranceservice/v1/booking-funnels | Create the booking funnel
*BookingFunnelsApi* | [**delete_booking_funnel**](docs/BookingFunnelsApi.md#delete_booking_funnel) | **DELETE** /insuranceservice/v1/booking-funnels/{code} | Delete the booking funnel
*BookingFunnelsApi* | [**get_booking_funnel**](docs/BookingFunnelsApi.md#get_booking_funnel) | **GET** /insuranceservice/v1/booking-funnels/{code} | Retrieve the booking funnel
*BookingFunnelsApi* | [**list_booking_funnels**](docs/BookingFunnelsApi.md#list_booking_funnels) | **GET** /insuranceservice/v1/booking-funnels | List booking funnels
*BookingFunnelsApi* | [**patch_booking_funnel**](docs/BookingFunnelsApi.md#patch_booking_funnel) | **PATCH** /insuranceservice/v1/booking-funnels/{code} | 
*BookingFunnelsApi* | [**update_booking_funnel**](docs/BookingFunnelsApi.md#update_booking_funnel) | **PUT** /insuranceservice/v1/booking-funnels/{code} | Update the booking funnel
*CommissionAgreementItemsApi* | [**create_commission_agreement_item**](docs/CommissionAgreementItemsApi.md#create_commission_agreement_item) | **POST** /insuranceservice/v1/commission-agreements/versions/{code}/items | Create the Commission agreement item
*CommissionAgreementItemsApi* | [**delete_commission_agreement_item**](docs/CommissionAgreementItemsApi.md#delete_commission_agreement_item) | **DELETE** /insuranceservice/v1/commission-agreements/versions/items/{code} | Delete the commission agreement item
*CommissionAgreementItemsApi* | [**get_commission_agreement_item**](docs/CommissionAgreementItemsApi.md#get_commission_agreement_item) | **GET** /insuranceservice/v1/commission-agreements/versions/items/{code} | Retrieve the commission agreement item
*CommissionAgreementItemsApi* | [**list_commission_agreement_items**](docs/CommissionAgreementItemsApi.md#list_commission_agreement_items) | **GET** /insuranceservice/v1/commission-agreements/versions/items | List commission agreement items
*CommissionAgreementItemsApi* | [**update_commission_agreement_item**](docs/CommissionAgreementItemsApi.md#update_commission_agreement_item) | **PUT** /insuranceservice/v1/commission-agreements/versions/items/{code} | Update the commission agreement item
*CommissionAgreementProductsApi* | [**create_commission_agreement_product**](docs/CommissionAgreementProductsApi.md#create_commission_agreement_product) | **POST** /insuranceservice/v1/commission-agreements/{code}/products | Create the Commission agreement product
*CommissionAgreementProductsApi* | [**delete_commission_agreement_product**](docs/CommissionAgreementProductsApi.md#delete_commission_agreement_product) | **DELETE** /insuranceservice/v1/commission-agreements/products/{code} | Delete the commission agreement product
*CommissionAgreementProductsApi* | [**get_commission_agreement_product**](docs/CommissionAgreementProductsApi.md#get_commission_agreement_product) | **GET** /insuranceservice/v1/commission-agreements/products/{code} | Retrieve the commission agreement product
*CommissionAgreementProductsApi* | [**list_commission_agreement_products**](docs/CommissionAgreementProductsApi.md#list_commission_agreement_products) | **GET** /insuranceservice/v1/commission-agreements/products | List commission agreement products
*CommissionAgreementProductsApi* | [**update_commission_agreement_product**](docs/CommissionAgreementProductsApi.md#update_commission_agreement_product) | **PUT** /insuranceservice/v1/commission-agreements/products/{code} | Update the commission agreement product
*CommissionAgreementVersionsApi* | [**create_commission_agreement_version**](docs/CommissionAgreementVersionsApi.md#create_commission_agreement_version) | **POST** /insuranceservice/v1/commission-agreements/{code}/versions | Create the Commission agreement version
*CommissionAgreementVersionsApi* | [**delete_commission_agreement_version**](docs/CommissionAgreementVersionsApi.md#delete_commission_agreement_version) | **DELETE** /insuranceservice/v1/commission-agreements/versions/{code} | Delete the commission agreement version
*CommissionAgreementVersionsApi* | [**get_commission_agreement_version**](docs/CommissionAgreementVersionsApi.md#get_commission_agreement_version) | **GET** /insuranceservice/v1/commission-agreements/versions/{code} | Retrieve the commission agreement version
*CommissionAgreementVersionsApi* | [**list_commission_agreement_versions**](docs/CommissionAgreementVersionsApi.md#list_commission_agreement_versions) | **GET** /insuranceservice/v1/commission-agreements/versions | List commission agreement versions
*CommissionAgreementsApi* | [**create_commission_agreement**](docs/CommissionAgreementsApi.md#create_commission_agreement) | **POST** /insuranceservice/v1/commission-agreements | Create the Commission agreement
*CommissionAgreementsApi* | [**delete_commission_agreement**](docs/CommissionAgreementsApi.md#delete_commission_agreement) | **DELETE** /insuranceservice/v1/commission-agreements/{code} | Delete the commission agreement
*CommissionAgreementsApi* | [**get_commission_agreement**](docs/CommissionAgreementsApi.md#get_commission_agreement) | **GET** /insuranceservice/v1/commission-agreements/{code} | Retrieve the commission agreement
*CommissionAgreementsApi* | [**list_commission_agreements**](docs/CommissionAgreementsApi.md#list_commission_agreements) | **GET** /insuranceservice/v1/commission-agreements | List commission agreements
*CommissionAgreementsApi* | [**update_commission_agreement**](docs/CommissionAgreementsApi.md#update_commission_agreement) | **PUT** /insuranceservice/v1/commission-agreements/{code} | Update the commission agreement
*CommissionRecipientsApi* | [**create_commission_recipient**](docs/CommissionRecipientsApi.md#create_commission_recipient) | **POST** /insuranceservice/v1/commission-agreements/{code}/recipients | Create the Commission recipient
*CommissionRecipientsApi* | [**delete_commission_recipient**](docs/CommissionRecipientsApi.md#delete_commission_recipient) | **DELETE** /insuranceservice/v1/commission-agreements/recipients/{code} | Delete the commission recipient
*CommissionRecipientsApi* | [**get_commission_recipient**](docs/CommissionRecipientsApi.md#get_commission_recipient) | **GET** /insuranceservice/v1/commission-agreements/recipients/{code} | Retrieve the commission recipient
*CommissionRecipientsApi* | [**list_commission_recipients**](docs/CommissionRecipientsApi.md#list_commission_recipients) | **GET** /insuranceservice/v1/commission-agreements/recipients | List commission recipients
*CommissionRecipientsApi* | [**update_commission_recipient**](docs/CommissionRecipientsApi.md#update_commission_recipient) | **PUT** /insuranceservice/v1/commission-agreements/recipients/{code} | Update the commission recipient
*EmilFunctionsApi* | [**create_emil_function**](docs/EmilFunctionsApi.md#create_emil_function) | **POST** /insuranceservice/v1/emil-functions | Create the Emil function
*EmilFunctionsApi* | [**create_emil_function_secret**](docs/EmilFunctionsApi.md#create_emil_function_secret) | **POST** /insuranceservice/v1/emil-functions/secrets | Create the Emil function secret
*EmilFunctionsApi* | [**delete_emil_function**](docs/EmilFunctionsApi.md#delete_emil_function) | **DELETE** /insuranceservice/v1/emil-functions/{id} | Delete the Emil function
*EmilFunctionsApi* | [**delete_emil_function_secret**](docs/EmilFunctionsApi.md#delete_emil_function_secret) | **DELETE** /insuranceservice/v1/emil-functions/secrets/{name} | Delete the Emil function secret
*EmilFunctionsApi* | [**execute_emil_function**](docs/EmilFunctionsApi.md#execute_emil_function) | **POST** /insuranceservice/v1/emil-functions/{slug}/execute | Execute the Emil function
*EmilFunctionsApi* | [**get_emil_function**](docs/EmilFunctionsApi.md#get_emil_function) | **GET** /insuranceservice/v1/emil-functions/{id} | Retrieve the Emil function
*EmilFunctionsApi* | [**get_emil_function_secret**](docs/EmilFunctionsApi.md#get_emil_function_secret) | **GET** /insuranceservice/v1/emil-functions/secrets/{name} | Retrieve the Emil function secret
*EmilFunctionsApi* | [**list_emil_function_secrets**](docs/EmilFunctionsApi.md#list_emil_function_secrets) | **GET** /insuranceservice/v1/emil-functions/secrets | List Emil function secrets
*EmilFunctionsApi* | [**list_emil_functions**](docs/EmilFunctionsApi.md#list_emil_functions) | **GET** /insuranceservice/v1/emil-functions | List Emil functions
*EmilFunctionsApi* | [**update_emil_function**](docs/EmilFunctionsApi.md#update_emil_function) | **PUT** /insuranceservice/v1/emil-functions/{id} | Update the Emil function
*EmilFunctionsApi* | [**update_emil_function_secret**](docs/EmilFunctionsApi.md#update_emil_function_secret) | **PUT** /insuranceservice/v1/emil-functions/secrets/{name} | Update the Emil function secret
*HealthCheckApi* | [**check**](docs/HealthCheckApi.md#check) | **GET** /insuranceservice/health | Health Check
*InsuredObjectTypesApi* | [**list_insured_object_types**](docs/InsuredObjectTypesApi.md#list_insured_object_types) | **GET** /insuranceservice/v1/insured-object-types | List insured object types
*InsuredObjectsApi* | [**create_insured_object**](docs/InsuredObjectsApi.md#create_insured_object) | **POST** /insuranceservice/v1/insured-objects | Create the insured object
*InsuredObjectsApi* | [**delete_insured_object**](docs/InsuredObjectsApi.md#delete_insured_object) | **DELETE** /insuranceservice/v1/insured-objects/{id} | Delete the insured object
*InsuredObjectsApi* | [**get_insured_object**](docs/InsuredObjectsApi.md#get_insured_object) | **GET** /insuranceservice/v1/insured-objects/{id} | Retrieve the insured object
*InsuredObjectsApi* | [**list_insured_objects**](docs/InsuredObjectsApi.md#list_insured_objects) | **GET** /insuranceservice/v1/insured-objects | List insured objects
*LeadStatusesApi* | [**create_lead_status**](docs/LeadStatusesApi.md#create_lead_status) | **POST** /insuranceservice/v1/lead-statuses | Create the lead status
*LeadStatusesApi* | [**delete_lead_status**](docs/LeadStatusesApi.md#delete_lead_status) | **DELETE** /insuranceservice/v1/lead-statuses/{code} | Delete the lead status
*LeadStatusesApi* | [**get_lead_status**](docs/LeadStatusesApi.md#get_lead_status) | **GET** /insuranceservice/v1/lead-statuses/{code} | Retrieve the lead status
*LeadStatusesApi* | [**list_lead_statuses**](docs/LeadStatusesApi.md#list_lead_statuses) | **GET** /insuranceservice/v1/lead-statuses | List lead statuses
*LeadStatusesApi* | [**update_lead_status**](docs/LeadStatusesApi.md#update_lead_status) | **PUT** /insuranceservice/v1/lead-statuses/{code} | Update the lead status
*LeadVersionsApi* | [**get_lead_version**](docs/LeadVersionsApi.md#get_lead_version) | **GET** /insuranceservice/v1/leads/{code}/versions/{version} | Retrieve the lead version
*LeadVersionsApi* | [**list_lead_versions**](docs/LeadVersionsApi.md#list_lead_versions) | **GET** /insuranceservice/v1/leads/{code}/versions | List lead versions
*LeadsApi* | [**clone_lead**](docs/LeadsApi.md#clone_lead) | **POST** /insuranceservice/v1/leads/{code}/clone | Clone the lead
*LeadsApi* | [**create_lead**](docs/LeadsApi.md#create_lead) | **POST** /insuranceservice/v1/leads | Create the lead
*LeadsApi* | [**create_lead_async**](docs/LeadsApi.md#create_lead_async) | **POST** /insuranceservice/v1/leads-async | Create the lead asynchronously
*LeadsApi* | [**create_lead_sync**](docs/LeadsApi.md#create_lead_sync) | **POST** /insuranceservice/v1/leads-sync | Create the lead
*LeadsApi* | [**delete_lead**](docs/LeadsApi.md#delete_lead) | **DELETE** /insuranceservice/v1/leads/{code} | Delete the lead
*LeadsApi* | [**get_lead**](docs/LeadsApi.md#get_lead) | **GET** /insuranceservice/v1/leads/{code} | Retrieve the lead
*LeadsApi* | [**list_leads**](docs/LeadsApi.md#list_leads) | **GET** /insuranceservice/v1/leads | List leads
*LeadsApi* | [**patch_lead**](docs/LeadsApi.md#patch_lead) | **PATCH** /insuranceservice/v1/leads/{code} | Patch the lead
*LeadsApi* | [**update_lead**](docs/LeadsApi.md#update_lead) | **PUT** /insuranceservice/v1/leads/{code} | Update the lead
*LeadsApi* | [**update_lead_sync**](docs/LeadsApi.md#update_lead_sync) | **PUT** /insuranceservice/v1/leads-sync/{code} | Update the lead
*NamedRangesApi* | [**create_named_range**](docs/NamedRangesApi.md#create_named_range) | **POST** /insuranceservice/v1/named-ranges | Create the named range 
*NamedRangesApi* | [**delete_named_range**](docs/NamedRangesApi.md#delete_named_range) | **DELETE** /insuranceservice/v1/named-ranges/{id} | Delete the named range
*NamedRangesApi* | [**filter_named_ranges**](docs/NamedRangesApi.md#filter_named_ranges) | **GET** /insuranceservice/v1/named-ranges/{code}/records | Filters the named range file rows.
*NamedRangesApi* | [**get_named_range**](docs/NamedRangesApi.md#get_named_range) | **GET** /insuranceservice/v1/named-ranges/{id} | Retrieve the named range
*NamedRangesApi* | [**list_named_ranges**](docs/NamedRangesApi.md#list_named_ranges) | **GET** /insuranceservice/v1/named-ranges | List named ranges
*NamedRangesApi* | [**update_named_range**](docs/NamedRangesApi.md#update_named_range) | **PUT** /insuranceservice/v1/named-ranges/{id} | Update the named range
*PartnerLinksApi* | [**delete_partner_link**](docs/PartnerLinksApi.md#delete_partner_link) | **DELETE** /insuranceservice/v1/partner-link/{id} | Delete the partner link
*PartnerLinksApi* | [**get_partner_link**](docs/PartnerLinksApi.md#get_partner_link) | **GET** /insuranceservice/v1/partner-link/{id} | Retrieve the partner link
*PartnerLinksApi* | [**link_partner**](docs/PartnerLinksApi.md#link_partner) | **POST** /insuranceservice/v1/partner-link | Create the partner link
*PartnerLinksApi* | [**list_partner_links**](docs/PartnerLinksApi.md#list_partner_links) | **GET** /insuranceservice/v1/partner-link | List partner links
*PartnerLinksApi* | [**unlink_partner**](docs/PartnerLinksApi.md#unlink_partner) | **PATCH** /insuranceservice/v1/partner-link/{id}/unlink | Ends the partner link
*PartnerLinksApi* | [**update_partner_link**](docs/PartnerLinksApi.md#update_partner_link) | **PUT** /insuranceservice/v1/partner-link/{id} | Update the partner link
*PartnerRolesApi* | [**create_partner_role**](docs/PartnerRolesApi.md#create_partner_role) | **POST** /insuranceservice/v1/partner-roles | Create the partner role
*PartnerRolesApi* | [**delete_partner_role**](docs/PartnerRolesApi.md#delete_partner_role) | **DELETE** /insuranceservice/v1/partner-roles/{code} | Delete the partner role
*PartnerRolesApi* | [**get_partner_role**](docs/PartnerRolesApi.md#get_partner_role) | **GET** /insuranceservice/v1/partner-roles/{code} | Retrieve the partner role
*PartnerRolesApi* | [**list_partner_role**](docs/PartnerRolesApi.md#list_partner_role) | **GET** /insuranceservice/v1/partner-roles | List partner roles
*PartnerRolesApi* | [**update_partner_role**](docs/PartnerRolesApi.md#update_partner_role) | **PUT** /insuranceservice/v1/partner-roles/{code} | Update the partner role
*PoliciesApi* | [**activate_policy**](docs/PoliciesApi.md#activate_policy) | **POST** /insuranceservice/v1/policies/{policyCode}/activate | Activate a suspended policy by tenant
*PoliciesApi* | [**create_draft_policy**](docs/PoliciesApi.md#create_draft_policy) | **POST** /insuranceservice/v1/policies/{policyCode}/draft | Create the draft-policy
*PoliciesApi* | [**create_policy**](docs/PoliciesApi.md#create_policy) | **POST** /insuranceservice/v1/policies | Create the policy
*PoliciesApi* | [**delete_draft_policy**](docs/PoliciesApi.md#delete_draft_policy) | **DELETE** /insuranceservice/v1/policies/{policyCode}/draft | Delete the draft-policy
*PoliciesApi* | [**get_draft_policy**](docs/PoliciesApi.md#get_draft_policy) | **GET** /insuranceservice/v1/policies/{policyCode}/draft | Retrieve the draft-policy
*PoliciesApi* | [**get_policy**](docs/PoliciesApi.md#get_policy) | **GET** /insuranceservice/v1/policies/{code} | Retrieve the policy
*PoliciesApi* | [**get_policy_data_by_date**](docs/PoliciesApi.md#get_policy_data_by_date) | **GET** /insuranceservice/v1/policies/{code}/current-version | Retrieve current policy version
*PoliciesApi* | [**list_policies**](docs/PoliciesApi.md#list_policies) | **GET** /insuranceservice/v1/policies | List policies
*PoliciesApi* | [**list_policy_objects**](docs/PoliciesApi.md#list_policy_objects) | **GET** /insuranceservice/v1/policies/policy-objects | List policy objects
*PoliciesApi* | [**list_policy_versions**](docs/PoliciesApi.md#list_policy_versions) | **GET** /insuranceservice/v1/policies/{policyCode}/versions | List policy versions
*PoliciesApi* | [**patch_draft_policy**](docs/PoliciesApi.md#patch_draft_policy) | **PATCH** /insuranceservice/v1/policies/{policyCode}/draft | Update the draft-policy
*PoliciesApi* | [**patch_policy**](docs/PoliciesApi.md#patch_policy) | **PATCH** /insuranceservice/v1/policies/{code} | Update the policy
*PoliciesApi* | [**restore_policy_version**](docs/PoliciesApi.md#restore_policy_version) | **POST** /insuranceservice/v1/policies/{policyCode}/restore-policy-version | Restore a policy version by versionId
*PoliciesApi* | [**suspend_policy**](docs/PoliciesApi.md#suspend_policy) | **POST** /insuranceservice/v1/policies/{policyCode}/suspend | Suspend a policy by tenant
*PoliciesApi* | [**terminate_policy**](docs/PoliciesApi.md#terminate_policy) | **POST** /insuranceservice/v1/policies/{policyCode}/terminate | Terminate a policy by tenant
*PoliciesApi* | [**update_policy**](docs/PoliciesApi.md#update_policy) | **PUT** /insuranceservice/v1/policies/{code} | Update the policy
*PoliciesApi* | [**withdraw_policy**](docs/PoliciesApi.md#withdraw_policy) | **POST** /insuranceservice/v1/policies/{policyCode}/withdraw | Withdraw policy by tenant
*PremiumFormulasApi* | [**create_premium_formula**](docs/PremiumFormulasApi.md#create_premium_formula) | **POST** /insuranceservice/v1/premium-formulas | Create the premium formula 
*PremiumFormulasApi* | [**delete_premium_formula**](docs/PremiumFormulasApi.md#delete_premium_formula) | **DELETE** /insuranceservice/v1/premium-formulas/{id} | Delete the premium formula
*PremiumFormulasApi* | [**get_premium_formula**](docs/PremiumFormulasApi.md#get_premium_formula) | **GET** /insuranceservice/v1/premium-formulas/{id} | Retrieve the premium formula
*PremiumFormulasApi* | [**list_premium_formulas**](docs/PremiumFormulasApi.md#list_premium_formulas) | **GET** /insuranceservice/v1/premium-formulas | List premium formulas
*PremiumFormulasApi* | [**swap_premium_formulas_order**](docs/PremiumFormulasApi.md#swap_premium_formulas_order) | **POST** /insuranceservice/v1/premium-formulas/reorder | Swaps premium formulas order
*PremiumFormulasApi* | [**update_premium_formula**](docs/PremiumFormulasApi.md#update_premium_formula) | **PUT** /insuranceservice/v1/premium-formulas/{id} | Update the premium formula
*ProductFactorsApi* | [**delete_product_factor**](docs/ProductFactorsApi.md#delete_product_factor) | **DELETE** /insuranceservice/v1/product-factors/{id} | 
*ProductFactorsApi* | [**get_product_factor**](docs/ProductFactorsApi.md#get_product_factor) | **GET** /insuranceservice/v1/product-factors/{id} | Retrieve the product factor
*ProductFactorsApi* | [**get_product_factor_value**](docs/ProductFactorsApi.md#get_product_factor_value) | **GET** /insuranceservice/v1/product-factors/values | Get product factor value
*ProductFactorsApi* | [**get_product_factors_for_version**](docs/ProductFactorsApi.md#get_product_factors_for_version) | **GET** /insuranceservice/v1/product-factors/for-version | List product factors for version
*ProductFactorsApi* | [**list_product_factors**](docs/ProductFactorsApi.md#list_product_factors) | **GET** /insuranceservice/v1/product-factors | List product factors
*ProductFactorsApi* | [**store_product_factors**](docs/ProductFactorsApi.md#store_product_factors) | **POST** /insuranceservice/v1/product-factors | Upload product factors
*ProductFactorsApi* | [**validate_product_factors**](docs/ProductFactorsApi.md#validate_product_factors) | **POST** /insuranceservice/v1/product-factors/validate | Validate product factors
*ProductFieldsApi* | [**create_product_field**](docs/ProductFieldsApi.md#create_product_field) | **POST** /insuranceservice/v1/product-fields | Create the product field
*ProductFieldsApi* | [**delete_product_field**](docs/ProductFieldsApi.md#delete_product_field) | **DELETE** /insuranceservice/v1/product-fields/{id} | Delete the product
*ProductFieldsApi* | [**get_product_field**](docs/ProductFieldsApi.md#get_product_field) | **GET** /insuranceservice/v1/product-fields/{id} | Retrieve the product field
*ProductFieldsApi* | [**list_product_field_types**](docs/ProductFieldsApi.md#list_product_field_types) | **GET** /insuranceservice/v1/product-fields/types | List product field types
*ProductFieldsApi* | [**list_product_fields**](docs/ProductFieldsApi.md#list_product_fields) | **GET** /insuranceservice/v1/product-fields | List product fields
*ProductFieldsApi* | [**swap_product_fields_order**](docs/ProductFieldsApi.md#swap_product_fields_order) | **POST** /insuranceservice/v1/product-fields/reorder | Swaps product fields order
*ProductFieldsApi* | [**update_product_field**](docs/ProductFieldsApi.md#update_product_field) | **PUT** /insuranceservice/v1/product-fields/{id} | Update the product
*ProductVersionsApi* | [**get_product_version**](docs/ProductVersionsApi.md#get_product_version) | **GET** /insuranceservice/v1/product-versions/{id} | Retrieve the product version
*ProductVersionsApi* | [**update_product_version**](docs/ProductVersionsApi.md#update_product_version) | **PUT** /insuranceservice/v1/product-versions/{id} | Update the product version
*ProductsApi* | [**create_product**](docs/ProductsApi.md#create_product) | **POST** /insuranceservice/v1/products | Create the product
*ProductsApi* | [**delete_product**](docs/ProductsApi.md#delete_product) | **DELETE** /insuranceservice/v1/products/{id} | Delete the product
*ProductsApi* | [**get_product_by_code**](docs/ProductsApi.md#get_product_by_code) | **GET** /insuranceservice/v1/products/code/{code} | Retrieve the product
*ProductsApi* | [**get_product_by_identifier**](docs/ProductsApi.md#get_product_by_identifier) | **GET** /insuranceservice/v1/products/get-by-identifier | Retrieve the product
*ProductsApi* | [**list_products**](docs/ProductsApi.md#list_products) | **GET** /insuranceservice/v1/products | List products
*ProductsApi* | [**update_product**](docs/ProductsApi.md#update_product) | **PUT** /insuranceservice/v1/products/{id} | Update the product
*StatusTransitionRulesApi* | [**create_status_transition_rule**](docs/StatusTransitionRulesApi.md#create_status_transition_rule) | **POST** /insuranceservice/v1/status-transitions/rules | Create the status transition rule
*StatusTransitionRulesApi* | [**delete_status_transition_rule**](docs/StatusTransitionRulesApi.md#delete_status_transition_rule) | **DELETE** /insuranceservice/v1/status-transitions/rules/{code} | Delete the status transition rule
*StatusTransitionRulesApi* | [**get_status_transition_rule**](docs/StatusTransitionRulesApi.md#get_status_transition_rule) | **GET** /insuranceservice/v1/status-transitions/rules/{code} | Retrieve the status transition rule
*StatusTransitionRulesApi* | [**list_status_transition_rules**](docs/StatusTransitionRulesApi.md#list_status_transition_rules) | **GET** /insuranceservice/v1/status-transitions/rules | List status transition rules
*StatusTransitionRulesApi* | [**patch_status_transition_rule**](docs/StatusTransitionRulesApi.md#patch_status_transition_rule) | **PATCH** /insuranceservice/v1/status-transitions/rules/{code} | Patch the status transition rule
*StatusTransitionRulesApi* | [**update_status_transition_rule**](docs/StatusTransitionRulesApi.md#update_status_transition_rule) | **PUT** /insuranceservice/v1/status-transitions/rules/{code} | Update the status transition rule


## Documentation For Models

 - [ActivatePolicyRequestDto](docs/ActivatePolicyRequestDto.md)
 - [ActivatePolicyResponseClass](docs/ActivatePolicyResponseClass.md)
 - [BookingFunnelClass](docs/BookingFunnelClass.md)
 - [CalculateCustomPremiumRequestDto](docs/CalculateCustomPremiumRequestDto.md)
 - [CalculatePremiumRequestDto](docs/CalculatePremiumRequestDto.md)
 - [CalculateProductFieldsRequestDto](docs/CalculateProductFieldsRequestDto.md)
 - [CloneLeadRequestDto](docs/CloneLeadRequestDto.md)
 - [CloneProductVersionRequestDto](docs/CloneProductVersionRequestDto.md)
 - [CommissionAgreementClass](docs/CommissionAgreementClass.md)
 - [CommissionAgreementItemClass](docs/CommissionAgreementItemClass.md)
 - [CommissionAgreementProductClass](docs/CommissionAgreementProductClass.md)
 - [CommissionAgreementVersionClass](docs/CommissionAgreementVersionClass.md)
 - [CommissionRecipientClass](docs/CommissionRecipientClass.md)
 - [CreateAccountRequestDto](docs/CreateAccountRequestDto.md)
 - [CreateBankAccountRequestDto](docs/CreateBankAccountRequestDto.md)
 - [CreateBookingFunnelRequestDto](docs/CreateBookingFunnelRequestDto.md)
 - [CreateBookingFunnelResponseClass](docs/CreateBookingFunnelResponseClass.md)
 - [CreateCommissionAgreementItemDto](docs/CreateCommissionAgreementItemDto.md)
 - [CreateCommissionAgreementItemRequestDto](docs/CreateCommissionAgreementItemRequestDto.md)
 - [CreateCommissionAgreementItemResponseClass](docs/CreateCommissionAgreementItemResponseClass.md)
 - [CreateCommissionAgreementProductRequestDto](docs/CreateCommissionAgreementProductRequestDto.md)
 - [CreateCommissionAgreementProductResponseClass](docs/CreateCommissionAgreementProductResponseClass.md)
 - [CreateCommissionAgreementRequestDto](docs/CreateCommissionAgreementRequestDto.md)
 - [CreateCommissionAgreementResponseClass](docs/CreateCommissionAgreementResponseClass.md)
 - [CreateCommissionAgreementVersionRequestDto](docs/CreateCommissionAgreementVersionRequestDto.md)
 - [CreateCommissionAgreementVersionResponseClass](docs/CreateCommissionAgreementVersionResponseClass.md)
 - [CreateCommissionRecipientRequestDto](docs/CreateCommissionRecipientRequestDto.md)
 - [CreateCommissionRecipientResponseClass](docs/CreateCommissionRecipientResponseClass.md)
 - [CreateCustomApplicationRequestDto](docs/CreateCustomApplicationRequestDto.md)
 - [CreateDraftPolicyRequestDto](docs/CreateDraftPolicyRequestDto.md)
 - [CreateDummyPolicyRequestDto](docs/CreateDummyPolicyRequestDto.md)
 - [CreateEmilFunctionRequestDto](docs/CreateEmilFunctionRequestDto.md)
 - [CreateEmilFunctionSecretRequestDto](docs/CreateEmilFunctionSecretRequestDto.md)
 - [CreateInsuredObjectRequestDto](docs/CreateInsuredObjectRequestDto.md)
 - [CreateInsuredObjectResponseClass](docs/CreateInsuredObjectResponseClass.md)
 - [CreateLeadAsyncResponseClass](docs/CreateLeadAsyncResponseClass.md)
 - [CreateLeadPolicyRequestDto](docs/CreateLeadPolicyRequestDto.md)
 - [CreateLeadRequestDto](docs/CreateLeadRequestDto.md)
 - [CreateLeadResponseClass](docs/CreateLeadResponseClass.md)
 - [CreateLeadStatusRequestDto](docs/CreateLeadStatusRequestDto.md)
 - [CreateLeadStatusResponseClass](docs/CreateLeadStatusResponseClass.md)
 - [CreateNamedRangeRequestDto](docs/CreateNamedRangeRequestDto.md)
 - [CreateNamedRangeResponseClass](docs/CreateNamedRangeResponseClass.md)
 - [CreateNamedRequestS3DataClass](docs/CreateNamedRequestS3DataClass.md)
 - [CreatePartnerRoleRequestDto](docs/CreatePartnerRoleRequestDto.md)
 - [CreatePartnerRoleResponseClass](docs/CreatePartnerRoleResponseClass.md)
 - [CreatePaymentMethodRequestDto](docs/CreatePaymentMethodRequestDto.md)
 - [CreatePolicyRequestDto](docs/CreatePolicyRequestDto.md)
 - [CreatePolicyResponseClass](docs/CreatePolicyResponseClass.md)
 - [CreatePremiumFormulaRequestDto](docs/CreatePremiumFormulaRequestDto.md)
 - [CreatePremiumFormulaResponseClass](docs/CreatePremiumFormulaResponseClass.md)
 - [CreateProductFieldRequestDto](docs/CreateProductFieldRequestDto.md)
 - [CreateProductFieldResponseClass](docs/CreateProductFieldResponseClass.md)
 - [CreateProductRequestDto](docs/CreateProductRequestDto.md)
 - [CreateProductResponseClass](docs/CreateProductResponseClass.md)
 - [CreateProductVersionRequestDto](docs/CreateProductVersionRequestDto.md)
 - [CreateStatusTransitionRuleRequestDto](docs/CreateStatusTransitionRuleRequestDto.md)
 - [CreateStatusTransitionRuleResponseClass](docs/CreateStatusTransitionRuleResponseClass.md)
 - [CsvProductFactorDto](docs/CsvProductFactorDto.md)
 - [DeleteDraftPolicyRequestDto](docs/DeleteDraftPolicyRequestDto.md)
 - [DeleteResponseClass](docs/DeleteResponseClass.md)
 - [EmilFunctionClass](docs/EmilFunctionClass.md)
 - [EmilFunctionSecretClass](docs/EmilFunctionSecretClass.md)
 - [EmptyResponseClass](docs/EmptyResponseClass.md)
 - [ExecuteEmilFunctionRequestDto](docs/ExecuteEmilFunctionRequestDto.md)
 - [FilterNamedRangeRequestDto](docs/FilterNamedRangeRequestDto.md)
 - [FilterNamedRangeResponseClass](docs/FilterNamedRangeResponseClass.md)
 - [GetBookingFunnelResponseClass](docs/GetBookingFunnelResponseClass.md)
 - [GetBookingFunnelVersionRequestDto](docs/GetBookingFunnelVersionRequestDto.md)
 - [GetCommissionAgreementItemResponseClass](docs/GetCommissionAgreementItemResponseClass.md)
 - [GetCommissionAgreementProductResponseClass](docs/GetCommissionAgreementProductResponseClass.md)
 - [GetCommissionAgreementResponseClass](docs/GetCommissionAgreementResponseClass.md)
 - [GetCommissionAgreementVersionResponseClass](docs/GetCommissionAgreementVersionResponseClass.md)
 - [GetCommissionRecipientResponseClass](docs/GetCommissionRecipientResponseClass.md)
 - [GetDraftPolicyRequestDto](docs/GetDraftPolicyRequestDto.md)
 - [GetEmilFunctionSecretResponseClass](docs/GetEmilFunctionSecretResponseClass.md)
 - [GetInsuredObjectResponseClass](docs/GetInsuredObjectResponseClass.md)
 - [GetLeadResponseClass](docs/GetLeadResponseClass.md)
 - [GetLeadStatusResponseClass](docs/GetLeadStatusResponseClass.md)
 - [GetLeadVersionRequestDto](docs/GetLeadVersionRequestDto.md)
 - [GetLeadVersionResponseClass](docs/GetLeadVersionResponseClass.md)
 - [GetNamedRangeResponseClass](docs/GetNamedRangeResponseClass.md)
 - [GetPartnerLinkResponseClass](docs/GetPartnerLinkResponseClass.md)
 - [GetPartnerRoleResponseClass](docs/GetPartnerRoleResponseClass.md)
 - [GetPolicyDataByDateRequestDto](docs/GetPolicyDataByDateRequestDto.md)
 - [GetPolicyRequestDto](docs/GetPolicyRequestDto.md)
 - [GetPolicyResponseClass](docs/GetPolicyResponseClass.md)
 - [GetPremiumFormulaRequestDto](docs/GetPremiumFormulaRequestDto.md)
 - [GetPremiumFormulaResponseClass](docs/GetPremiumFormulaResponseClass.md)
 - [GetProductFactorResponseClass](docs/GetProductFactorResponseClass.md)
 - [GetProductFactorValueRequestDto](docs/GetProductFactorValueRequestDto.md)
 - [GetProductFactorValueResponseClass](docs/GetProductFactorValueResponseClass.md)
 - [GetProductFactorsForVersionRequestDto](docs/GetProductFactorsForVersionRequestDto.md)
 - [GetProductFactorsForVersionResponseClass](docs/GetProductFactorsForVersionResponseClass.md)
 - [GetProductFieldRequestDto](docs/GetProductFieldRequestDto.md)
 - [GetProductFieldResponseClass](docs/GetProductFieldResponseClass.md)
 - [GetProductRequestDto](docs/GetProductRequestDto.md)
 - [GetProductResponseClass](docs/GetProductResponseClass.md)
 - [GetProductVersionRequestDto](docs/GetProductVersionRequestDto.md)
 - [GetProductVersionResponseClass](docs/GetProductVersionResponseClass.md)
 - [GetStatusTransitionRuleResponseClass](docs/GetStatusTransitionRuleResponseClass.md)
 - [GroupedProductFactorClass](docs/GroupedProductFactorClass.md)
 - [GroupedProductFactorValueClass](docs/GroupedProductFactorValueClass.md)
 - [GroupedProductFactorsResponseClass](docs/GroupedProductFactorsResponseClass.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [InsuredObjectClass](docs/InsuredObjectClass.md)
 - [InsuredObjectTypeClass](docs/InsuredObjectTypeClass.md)
 - [InvoiceItemClass](docs/InvoiceItemClass.md)
 - [InvoiceStatusClass](docs/InvoiceStatusClass.md)
 - [LeadBankAccountClass](docs/LeadBankAccountClass.md)
 - [LeadClass](docs/LeadClass.md)
 - [LeadStatusClass](docs/LeadStatusClass.md)
 - [LinkLeadPartnerRequestDto](docs/LinkLeadPartnerRequestDto.md)
 - [LinkPartnerRequestDto](docs/LinkPartnerRequestDto.md)
 - [LinkPartnerResponseClass](docs/LinkPartnerResponseClass.md)
 - [ListBookingFunnelsResponseClass](docs/ListBookingFunnelsResponseClass.md)
 - [ListCommissionAgreementItemsResponseClass](docs/ListCommissionAgreementItemsResponseClass.md)
 - [ListCommissionAgreementProductsResponseClass](docs/ListCommissionAgreementProductsResponseClass.md)
 - [ListCommissionAgreementVersionsResponseClass](docs/ListCommissionAgreementVersionsResponseClass.md)
 - [ListCommissionAgreementsResponseClass](docs/ListCommissionAgreementsResponseClass.md)
 - [ListCommissionRecipientsResponseClass](docs/ListCommissionRecipientsResponseClass.md)
 - [ListEmilFunctionSecretsResponseClass](docs/ListEmilFunctionSecretsResponseClass.md)
 - [ListEmilFunctionsResponseClass](docs/ListEmilFunctionsResponseClass.md)
 - [ListInsuredObjectTypesResponseClass](docs/ListInsuredObjectTypesResponseClass.md)
 - [ListInsuredObjectsResponseClass](docs/ListInsuredObjectsResponseClass.md)
 - [ListLeadStatusesResponseClass](docs/ListLeadStatusesResponseClass.md)
 - [ListLeadVersionsResponseClass](docs/ListLeadVersionsResponseClass.md)
 - [ListLeadsResponseClass](docs/ListLeadsResponseClass.md)
 - [ListNamedRangesResponseClass](docs/ListNamedRangesResponseClass.md)
 - [ListPartnerLinksResponseClass](docs/ListPartnerLinksResponseClass.md)
 - [ListPartnerRolesResponseClass](docs/ListPartnerRolesResponseClass.md)
 - [ListPoliciesResponseClass](docs/ListPoliciesResponseClass.md)
 - [ListPolicyObjectsResponseClass](docs/ListPolicyObjectsResponseClass.md)
 - [ListPolicyVersionResponseClass](docs/ListPolicyVersionResponseClass.md)
 - [ListPolicyVersionsRequestDto](docs/ListPolicyVersionsRequestDto.md)
 - [ListPremiumFormulasResponseClass](docs/ListPremiumFormulasResponseClass.md)
 - [ListProductFactorsResponseClass](docs/ListProductFactorsResponseClass.md)
 - [ListProductFieldTypesResponseClass](docs/ListProductFieldTypesResponseClass.md)
 - [ListProductFieldsResponseClass](docs/ListProductFieldsResponseClass.md)
 - [ListProductsResponseClass](docs/ListProductsResponseClass.md)
 - [ListRequestDto](docs/ListRequestDto.md)
 - [ListStatusTransitionRulesResponseClass](docs/ListStatusTransitionRulesResponseClass.md)
 - [NamedRangeClass](docs/NamedRangeClass.md)
 - [OmitTypeClass](docs/OmitTypeClass.md)
 - [PartnerClass](docs/PartnerClass.md)
 - [PartnerLinkClass](docs/PartnerLinkClass.md)
 - [PartnerRoleClass](docs/PartnerRoleClass.md)
 - [PatchBookingFunnelRequestDto](docs/PatchBookingFunnelRequestDto.md)
 - [PatchBookingFunnelResponseClass](docs/PatchBookingFunnelResponseClass.md)
 - [PatchDraftPolicyRequestDto](docs/PatchDraftPolicyRequestDto.md)
 - [PatchLeadRequestDto](docs/PatchLeadRequestDto.md)
 - [PatchLeadResponseClass](docs/PatchLeadResponseClass.md)
 - [PatchPolicyRequestDto](docs/PatchPolicyRequestDto.md)
 - [PatchPolicyResponseClass](docs/PatchPolicyResponseClass.md)
 - [PatchStatusTransitionRuleRequestDto](docs/PatchStatusTransitionRuleRequestDto.md)
 - [PatchStatusTransitionRuleResponseClass](docs/PatchStatusTransitionRuleResponseClass.md)
 - [PolicyClass](docs/PolicyClass.md)
 - [PolicyObjectClass](docs/PolicyObjectClass.md)
 - [PolicyObjectDto](docs/PolicyObjectDto.md)
 - [PolicyPremiumClass](docs/PolicyPremiumClass.md)
 - [PolicyPremiumItemClass](docs/PolicyPremiumItemClass.md)
 - [PolicyVersionClass](docs/PolicyVersionClass.md)
 - [PremiumFormulaClass](docs/PremiumFormulaClass.md)
 - [PremiumOverrideDto](docs/PremiumOverrideDto.md)
 - [PremiumOverrideRequestClass](docs/PremiumOverrideRequestClass.md)
 - [PremiumOverrideRequestDto](docs/PremiumOverrideRequestDto.md)
 - [ProductClass](docs/ProductClass.md)
 - [ProductFactorClass](docs/ProductFactorClass.md)
 - [ProductFactorForVersionClass](docs/ProductFactorForVersionClass.md)
 - [ProductFactorValueClass](docs/ProductFactorValueClass.md)
 - [ProductFactorValueForVersionClass](docs/ProductFactorValueForVersionClass.md)
 - [ProductFieldClass](docs/ProductFieldClass.md)
 - [ProductFieldTypeClass](docs/ProductFieldTypeClass.md)
 - [ProductVersionClass](docs/ProductVersionClass.md)
 - [RestCloneLeadAccountRequestDto](docs/RestCloneLeadAccountRequestDto.md)
 - [RestorePolicyVersionRequestDto](docs/RestorePolicyVersionRequestDto.md)
 - [RestorePolicyVersionResponseClass](docs/RestorePolicyVersionResponseClass.md)
 - [SepaDto](docs/SepaDto.md)
 - [SharedCreateLeadPolicyRequestDto](docs/SharedCreateLeadPolicyRequestDto.md)
 - [SharedInvoiceClass](docs/SharedInvoiceClass.md)
 - [SharedLeadPolicyObjectDto](docs/SharedLeadPolicyObjectDto.md)
 - [SharedProductFieldClass](docs/SharedProductFieldClass.md)
 - [SharedUpdateNamedRangeRequestDto](docs/SharedUpdateNamedRangeRequestDto.md)
 - [SharedUpdatePremiumFormulaRequestDto](docs/SharedUpdatePremiumFormulaRequestDto.md)
 - [StatusTransitionRuleClass](docs/StatusTransitionRuleClass.md)
 - [StoreProductFactorsRequestDto](docs/StoreProductFactorsRequestDto.md)
 - [StoreProductFactorsResponseClass](docs/StoreProductFactorsResponseClass.md)
 - [SuspendPolicyRequestDto](docs/SuspendPolicyRequestDto.md)
 - [SuspendPolicyResponseClass](docs/SuspendPolicyResponseClass.md)
 - [SwapPremiumFormulasOrderRequestDto](docs/SwapPremiumFormulasOrderRequestDto.md)
 - [SwapProductFieldsOrderRequestDto](docs/SwapProductFieldsOrderRequestDto.md)
 - [TagClass](docs/TagClass.md)
 - [TerminatePolicyRequestDto](docs/TerminatePolicyRequestDto.md)
 - [TerminatePolicyResponseClass](docs/TerminatePolicyResponseClass.md)
 - [TimesliceClass](docs/TimesliceClass.md)
 - [UnlinkPartnerResponseClass](docs/UnlinkPartnerResponseClass.md)
 - [UpdateBookingFunnelRequestDto](docs/UpdateBookingFunnelRequestDto.md)
 - [UpdateBookingFunnelResponseClass](docs/UpdateBookingFunnelResponseClass.md)
 - [UpdateCommissionAgreementItemRequestDto](docs/UpdateCommissionAgreementItemRequestDto.md)
 - [UpdateCommissionAgreementItemResponseClass](docs/UpdateCommissionAgreementItemResponseClass.md)
 - [UpdateCommissionAgreementProductRequestDto](docs/UpdateCommissionAgreementProductRequestDto.md)
 - [UpdateCommissionAgreementProductResponseClass](docs/UpdateCommissionAgreementProductResponseClass.md)
 - [UpdateCommissionAgreementRequestDto](docs/UpdateCommissionAgreementRequestDto.md)
 - [UpdateCommissionAgreementResponseClass](docs/UpdateCommissionAgreementResponseClass.md)
 - [UpdateCommissionRecipientRequestDto](docs/UpdateCommissionRecipientRequestDto.md)
 - [UpdateCommissionRecipientResponseClass](docs/UpdateCommissionRecipientResponseClass.md)
 - [UpdateEmilFunctionRequestDto](docs/UpdateEmilFunctionRequestDto.md)
 - [UpdateEmilFunctionSecretRequestDto](docs/UpdateEmilFunctionSecretRequestDto.md)
 - [UpdateInsuredObjectRequestDto](docs/UpdateInsuredObjectRequestDto.md)
 - [UpdateLeadRequestDto](docs/UpdateLeadRequestDto.md)
 - [UpdateLeadResponseClass](docs/UpdateLeadResponseClass.md)
 - [UpdateLeadStatusRequestDto](docs/UpdateLeadStatusRequestDto.md)
 - [UpdateLeadStatusResponseClass](docs/UpdateLeadStatusResponseClass.md)
 - [UpdateNamedRangeRequestDto](docs/UpdateNamedRangeRequestDto.md)
 - [UpdateNamedRangeResponseClass](docs/UpdateNamedRangeResponseClass.md)
 - [UpdatePartnerLinkRequestDto](docs/UpdatePartnerLinkRequestDto.md)
 - [UpdatePartnerLinkResponseClass](docs/UpdatePartnerLinkResponseClass.md)
 - [UpdatePartnerRoleRequestDto](docs/UpdatePartnerRoleRequestDto.md)
 - [UpdatePartnerRoleResponseClass](docs/UpdatePartnerRoleResponseClass.md)
 - [UpdatePolicyRequestDto](docs/UpdatePolicyRequestDto.md)
 - [UpdatePolicyResponseClass](docs/UpdatePolicyResponseClass.md)
 - [UpdatePremiumFormulaRequestDto](docs/UpdatePremiumFormulaRequestDto.md)
 - [UpdatePremiumFormulaResponseClass](docs/UpdatePremiumFormulaResponseClass.md)
 - [UpdateProductFieldRequestDto](docs/UpdateProductFieldRequestDto.md)
 - [UpdateProductFieldResponseClass](docs/UpdateProductFieldResponseClass.md)
 - [UpdateProductRequestDto](docs/UpdateProductRequestDto.md)
 - [UpdateProductResponseClass](docs/UpdateProductResponseClass.md)
 - [UpdateProductVersionRequestDto](docs/UpdateProductVersionRequestDto.md)
 - [UpdateProductVersionResponseClass](docs/UpdateProductVersionResponseClass.md)
 - [UpdateStatusTransitionRuleRequestDto](docs/UpdateStatusTransitionRuleRequestDto.md)
 - [UpdateStatusTransitionRuleResponseClass](docs/UpdateStatusTransitionRuleResponseClass.md)
 - [UploadedDocumentDto](docs/UploadedDocumentDto.md)
 - [ValidateProductFactorsRequestDto](docs/ValidateProductFactorsRequestDto.md)
 - [WithdrawPolicyResponseClass](docs/WithdrawPolicyResponseClass.md)


## Documentation For Authorization


## bearer

- **Type**: Bearer authentication (JWT)


## Author

kontakt@emil.de


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in eis.insurance.apis and eis.insurance.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from eis.insurance.api.default_api import DefaultApi`
- `from eis.insurance.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import eis.insurance
from eis.insurance.apis import *
from eis.insurance.models import *
```

