"""
    EMIL InsuranceService

    The EMIL InsuranceService API description  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.insurance.api_client import ApiClient, Endpoint as _Endpoint
from eis.insurance.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from eis.insurance.model.activate_policy_request_dto import ActivatePolicyRequestDto
from eis.insurance.model.activate_policy_response_class import ActivatePolicyResponseClass
from eis.insurance.model.create_draft_policy_request_dto import CreateDraftPolicyRequestDto
from eis.insurance.model.create_policy_request_dto import CreatePolicyRequestDto
from eis.insurance.model.create_policy_response_class import CreatePolicyResponseClass
from eis.insurance.model.delete_response_class import DeleteResponseClass
from eis.insurance.model.get_policy_response_class import GetPolicyResponseClass
from eis.insurance.model.list_policies_response_class import ListPoliciesResponseClass
from eis.insurance.model.list_policy_objects_response_class import ListPolicyObjectsResponseClass
from eis.insurance.model.list_policy_version_response_class import ListPolicyVersionResponseClass
from eis.insurance.model.patch_draft_policy_request_dto import PatchDraftPolicyRequestDto
from eis.insurance.model.patch_policy_request_dto import PatchPolicyRequestDto
from eis.insurance.model.patch_policy_response_class import PatchPolicyResponseClass
from eis.insurance.model.restore_policy_version_request_dto import RestorePolicyVersionRequestDto
from eis.insurance.model.restore_policy_version_response_class import RestorePolicyVersionResponseClass
from eis.insurance.model.suspend_policy_request_dto import SuspendPolicyRequestDto
from eis.insurance.model.suspend_policy_response_class import SuspendPolicyResponseClass
from eis.insurance.model.terminate_policy_request_dto import TerminatePolicyRequestDto
from eis.insurance.model.terminate_policy_response_class import TerminatePolicyResponseClass
from eis.insurance.model.update_policy_request_dto import UpdatePolicyRequestDto
from eis.insurance.model.update_policy_response_class import UpdatePolicyResponseClass
from eis.insurance.model.withdraw_policy_response_class import WithdrawPolicyResponseClass


class PoliciesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.activate_policy_endpoint = _Endpoint(
            settings={
                'response_type': (ActivatePolicyResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{policyCode}/activate',
                'operation_id': 'activate_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_code',
                    'activate_policy_request_dto',
                    'authorization',
                ],
                'required': [
                    'policy_code',
                    'activate_policy_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_code':
                        (str,),
                    'activate_policy_request_dto':
                        (ActivatePolicyRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'policy_code': 'policyCode',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'policy_code': 'path',
                    'activate_policy_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_draft_policy_endpoint = _Endpoint(
            settings={
                'response_type': (CreatePolicyResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{policyCode}/draft',
                'operation_id': 'create_draft_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_code',
                    'create_draft_policy_request_dto',
                    'authorization',
                ],
                'required': [
                    'policy_code',
                    'create_draft_policy_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_code':
                        (str,),
                    'create_draft_policy_request_dto':
                        (CreateDraftPolicyRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'policy_code': 'policyCode',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'policy_code': 'path',
                    'create_draft_policy_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_policy_endpoint = _Endpoint(
            settings={
                'response_type': (CreatePolicyResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies',
                'operation_id': 'create_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_policy_request_dto',
                    'authorization',
                ],
                'required': [
                    'create_policy_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_policy_request_dto':
                        (CreatePolicyRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'create_policy_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_draft_policy_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{policyCode}/draft',
                'operation_id': 'delete_draft_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_code',
                    'authorization',
                ],
                'required': [
                    'policy_code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_code':
                        (str,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'policy_code': 'policyCode',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'policy_code': 'path',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_draft_policy_endpoint = _Endpoint(
            settings={
                'response_type': (GetPolicyResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{policyCode}/draft',
                'operation_id': 'get_draft_policy',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_code',
                    'authorization',
                    'expand',
                ],
                'required': [
                    'policy_code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_code':
                        (str,),
                    'authorization':
                        (str,),
                    'expand':
                        (str,),
                },
                'attribute_map': {
                    'policy_code': 'policyCode',
                    'authorization': 'Authorization',
                    'expand': 'expand',
                },
                'location_map': {
                    'policy_code': 'path',
                    'authorization': 'header',
                    'expand': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_policy_endpoint = _Endpoint(
            settings={
                'response_type': (GetPolicyResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{code}',
                'operation_id': 'get_policy',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'authorization',
                    'expand',
                ],
                'required': [
                    'code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'authorization':
                        (str,),
                    'expand':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                    'expand': 'expand',
                },
                'location_map': {
                    'code': 'path',
                    'authorization': 'header',
                    'expand': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_policy_data_by_date_endpoint = _Endpoint(
            settings={
                'response_type': (GetPolicyResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{code}/current-version',
                'operation_id': 'get_policy_data_by_date',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'authorization',
                    'timeslice_date',
                    'expand',
                ],
                'required': [
                    'code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'authorization':
                        (str,),
                    'timeslice_date':
                        (str,),
                    'expand':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                    'timeslice_date': 'timesliceDate',
                    'expand': 'expand',
                },
                'location_map': {
                    'code': 'path',
                    'authorization': 'header',
                    'timeslice_date': 'query',
                    'expand': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_policies_endpoint = _Endpoint(
            settings={
                'response_type': (ListPoliciesResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies',
                'operation_id': 'list_policies',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'page_size',
                    'page_token',
                    'filter',
                    'search',
                    'order',
                    'expand',
                    'filters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'page_size':
                        (float,),
                    'page_token':
                        (str,),
                    'filter':
                        (str,),
                    'search':
                        (str,),
                    'order':
                        (str,),
                    'expand':
                        (str,),
                    'filters':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'page_size': 'pageSize',
                    'page_token': 'pageToken',
                    'filter': 'filter',
                    'search': 'search',
                    'order': 'order',
                    'expand': 'expand',
                    'filters': 'filters',
                },
                'location_map': {
                    'authorization': 'header',
                    'page_size': 'query',
                    'page_token': 'query',
                    'filter': 'query',
                    'search': 'query',
                    'order': 'query',
                    'expand': 'query',
                    'filters': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_policy_objects_endpoint = _Endpoint(
            settings={
                'response_type': (ListPolicyObjectsResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/policy-objects',
                'operation_id': 'list_policy_objects',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'page_size',
                    'page_token',
                    'filter',
                    'search',
                    'order',
                    'expand',
                    'filters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'page_size':
                        (float,),
                    'page_token':
                        (str,),
                    'filter':
                        (str,),
                    'search':
                        (str,),
                    'order':
                        (str,),
                    'expand':
                        (str,),
                    'filters':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'page_size': 'pageSize',
                    'page_token': 'pageToken',
                    'filter': 'filter',
                    'search': 'search',
                    'order': 'order',
                    'expand': 'expand',
                    'filters': 'filters',
                },
                'location_map': {
                    'authorization': 'header',
                    'page_size': 'query',
                    'page_token': 'query',
                    'filter': 'query',
                    'search': 'query',
                    'order': 'query',
                    'expand': 'query',
                    'filters': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_policy_versions_endpoint = _Endpoint(
            settings={
                'response_type': (ListPolicyVersionResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{policyCode}/versions',
                'operation_id': 'list_policy_versions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_code',
                    'authorization',
                    'page_size',
                    'page_token',
                    'filter',
                    'search',
                    'order',
                    'expand',
                    'filters',
                ],
                'required': [
                    'policy_code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_code':
                        (str,),
                    'authorization':
                        (str,),
                    'page_size':
                        (float,),
                    'page_token':
                        (str,),
                    'filter':
                        (str,),
                    'search':
                        (str,),
                    'order':
                        (str,),
                    'expand':
                        (str,),
                    'filters':
                        (str,),
                },
                'attribute_map': {
                    'policy_code': 'policyCode',
                    'authorization': 'Authorization',
                    'page_size': 'pageSize',
                    'page_token': 'pageToken',
                    'filter': 'filter',
                    'search': 'search',
                    'order': 'order',
                    'expand': 'expand',
                    'filters': 'filters',
                },
                'location_map': {
                    'policy_code': 'path',
                    'authorization': 'header',
                    'page_size': 'query',
                    'page_token': 'query',
                    'filter': 'query',
                    'search': 'query',
                    'order': 'query',
                    'expand': 'query',
                    'filters': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.patch_draft_policy_endpoint = _Endpoint(
            settings={
                'response_type': (PatchPolicyResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{policyCode}/draft',
                'operation_id': 'patch_draft_policy',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_code',
                    'patch_draft_policy_request_dto',
                    'authorization',
                ],
                'required': [
                    'policy_code',
                    'patch_draft_policy_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_code':
                        (str,),
                    'patch_draft_policy_request_dto':
                        (PatchDraftPolicyRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'policy_code': 'policyCode',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'policy_code': 'path',
                    'patch_draft_policy_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.patch_policy_endpoint = _Endpoint(
            settings={
                'response_type': (PatchPolicyResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{code}',
                'operation_id': 'patch_policy',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'patch_policy_request_dto',
                    'authorization',
                ],
                'required': [
                    'code',
                    'patch_policy_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'patch_policy_request_dto':
                        (PatchPolicyRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'code': 'path',
                    'patch_policy_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.restore_policy_version_endpoint = _Endpoint(
            settings={
                'response_type': (RestorePolicyVersionResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{policyCode}/restore-policy-version',
                'operation_id': 'restore_policy_version',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_code',
                    'restore_policy_version_request_dto',
                    'authorization',
                ],
                'required': [
                    'policy_code',
                    'restore_policy_version_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_code':
                        (str,),
                    'restore_policy_version_request_dto':
                        (RestorePolicyVersionRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'policy_code': 'policyCode',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'policy_code': 'path',
                    'restore_policy_version_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.suspend_policy_endpoint = _Endpoint(
            settings={
                'response_type': (SuspendPolicyResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{policyCode}/suspend',
                'operation_id': 'suspend_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_code',
                    'suspend_policy_request_dto',
                    'authorization',
                ],
                'required': [
                    'policy_code',
                    'suspend_policy_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_code':
                        (str,),
                    'suspend_policy_request_dto':
                        (SuspendPolicyRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'policy_code': 'policyCode',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'policy_code': 'path',
                    'suspend_policy_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.terminate_policy_endpoint = _Endpoint(
            settings={
                'response_type': (TerminatePolicyResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{policyCode}/terminate',
                'operation_id': 'terminate_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_code',
                    'terminate_policy_request_dto',
                    'authorization',
                ],
                'required': [
                    'policy_code',
                    'terminate_policy_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_code':
                        (str,),
                    'terminate_policy_request_dto':
                        (TerminatePolicyRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'policy_code': 'policyCode',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'policy_code': 'path',
                    'terminate_policy_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_policy_endpoint = _Endpoint(
            settings={
                'response_type': (UpdatePolicyResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{code}',
                'operation_id': 'update_policy',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'update_policy_request_dto',
                    'authorization',
                ],
                'required': [
                    'code',
                    'update_policy_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'update_policy_request_dto':
                        (UpdatePolicyRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'code': 'path',
                    'update_policy_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.withdraw_policy_endpoint = _Endpoint(
            settings={
                'response_type': (WithdrawPolicyResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/policies/{policyCode}/withdraw',
                'operation_id': 'withdraw_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_code',
                    'body',
                    'authorization',
                ],
                'required': [
                    'policy_code',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_code':
                        (str,),
                    'body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'policy_code': 'policyCode',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'policy_code': 'path',
                    'body': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def activate_policy(
        self,
        policy_code,
        activate_policy_request_dto,
        **kwargs
    ):
        """Activate a suspended policy by tenant  # noqa: E501

        Request to activate an existing suspended policy by tenant.  **Required Permissions**  \"policy-management.policies.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.activate_policy(policy_code, activate_policy_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            policy_code (str): The policy code.
            activate_policy_request_dto (ActivatePolicyRequestDto):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ActivatePolicyResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['policy_code'] = \
            policy_code
        kwargs['activate_policy_request_dto'] = \
            activate_policy_request_dto
        return self.activate_policy_endpoint.call_with_http_info(**kwargs)

    def create_draft_policy(
        self,
        policy_code,
        create_draft_policy_request_dto,
        **kwargs
    ):
        """Create the draft-policy  # noqa: E501

        This will create a draft policy in the database.  **Required Permissions**  \"policy-management.policies.create\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_draft_policy(policy_code, create_draft_policy_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            policy_code (str): Unique identifier for the object.
            create_draft_policy_request_dto (CreateDraftPolicyRequestDto):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreatePolicyResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['policy_code'] = \
            policy_code
        kwargs['create_draft_policy_request_dto'] = \
            create_draft_policy_request_dto
        return self.create_draft_policy_endpoint.call_with_http_info(**kwargs)

    def create_policy(
        self,
        create_policy_request_dto,
        **kwargs
    ):
        """Create the policy  # noqa: E501

        This will create a policy in the database. Policy creation is usually part     of a complex workflow that starts with lead creation. Creating directly a policy without prior knowledge     might result in an unusable policy. Look into lead creation for more information.  **Required Permissions**  \"policy-management.policies.create\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_policy(create_policy_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            create_policy_request_dto (CreatePolicyRequestDto):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreatePolicyResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_policy_request_dto'] = \
            create_policy_request_dto
        return self.create_policy_endpoint.call_with_http_info(**kwargs)

    def delete_draft_policy(
        self,
        policy_code,
        **kwargs
    ):
        """Delete the draft-policy  # noqa: E501

        Permanently deletes the draft-policy. Supply the unique code that was returned when you created the draft-policy and this will delete it.  **Required Permissions**  \"policy-management.policies.delete\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_draft_policy(policy_code, async_req=True)
        >>> result = thread.get()

        Args:
            policy_code (str): Unique identifier for the object.

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeleteResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['policy_code'] = \
            policy_code
        return self.delete_draft_policy_endpoint.call_with_http_info(**kwargs)

    def get_draft_policy(
        self,
        policy_code,
        **kwargs
    ):
        """Retrieve the draft-policy  # noqa: E501

        Retrieves the details of the draft-policy that was previously created. Supply the unique draft-policy code      that was returned when you created it and Emil Api will return the corresponding draft-policy information.  **Required Permissions**  \"policy-management.policies.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_draft_policy(policy_code, async_req=True)
        >>> result = thread.get()

        Args:
            policy_code (str): Unique identifier for the object.

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            expand (str): Fields to expand response by.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetPolicyResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['policy_code'] = \
            policy_code
        return self.get_draft_policy_endpoint.call_with_http_info(**kwargs)

    def get_policy(
        self,
        code,
        **kwargs
    ):
        """Retrieve the policy  # noqa: E501

        Retrieves the details of the policy that was previously created. Supply the unique policy code      that was returned when you created it and Emil Api will return the corresponding policy information.  **Required Permissions**  \"policy-management.policies.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_policy(code, async_req=True)
        >>> result = thread.get()

        Args:
            code (str): Unique identifier for the object.

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            expand (str): You can expand policy in this endpoint. ' +       'By default, versions and partnerLinks will be an empty array. Allowed values: versions, product, timelines, premiums, premiumItems, premiumFormulas, currentVersion, currentTimelines, currentPremiums, currentPremiumItems, currentPremiumFormulas, partnerLinks.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetPolicyResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        return self.get_policy_endpoint.call_with_http_info(**kwargs)

    def get_policy_data_by_date(
        self,
        code,
        **kwargs
    ):
        """Retrieve current policy version  # noqa: E501

        This endpoint will return the current version of the policy. It is possible to filter the       response by a specific date and the system will return the valid data that was (or will be) at the       provided date.  **Required Permissions**  \"policy-management.policies.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_policy_data_by_date(code, async_req=True)
        >>> result = thread.get()

        Args:
            code (str): Unique identifier for the object.

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            timeslice_date (str): This date is used to filter data of the policy, to select the appropriate timeslice.       If no date is specified, the system returns all the timeslices available.. [optional]
            expand (str): Expand to fetch additional information for current version or specified timeslice of the policy.<br/>       <br/>       <i>Expand by: \"premiums\", \"premiumItems\", \"premiumFormulas\", \"timelines,product\", or \"timelines,partnerLinks\"<i>. [optional] if omitted the server will use the default value of "timelines,product"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetPolicyResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        return self.get_policy_data_by_date_endpoint.call_with_http_info(**kwargs)

    def list_policies(
        self,
        **kwargs
    ):
        """List policies  # noqa: E501

        Returns a list of policies you have previously created.          The policies are returned in sorted order, with the oldest one appearing first.          For more information about pagination, read the Pagination documentation.  **Required Permissions**  \"policy-management.policies.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_policies(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            page_size (float): A limit on the number of objects to be returned.     Limit ranges between 1 and 50. Default: 10.. [optional]
            page_token (str): A cursor for use in pagination.     pageToken is an ID that defines your place in the list.     For instance, if you make a list request and receive 100 objects and pageToken=1, your subsequent call can include pageToken=2 in order to fetch the next page of the list.. [optional]
            filter (str): Filter the response by one or multiple fields.            In general, fetching filtered responses will conserve bandwidth and reduce response time.<br/>           <br/>           <i>Allowed values: id, code, leadCode, policyNumber, holder, policyStartDate, productSlug, productVersionId, productId, accountCode, productName, status, statuses, createdAt, policyData, partnerCode</i>. [optional]
            search (str): To search the list by any field, pass search=xxx to fetch the result.. [optional]
            order (str): Order allows you to specify the desired order of entities retrieved from the server by           ascending (ASC) or descending (DESC) order.<br/>           <br/>           <i>Allowed values: id, policyNumber, createdAt, updatedAt, policyStartDate, productVersionId, productId</i>. [optional]
            expand (str): Expand to fetch additional information about the list items.       Expanding resources can reduce the number of API calls required to accomplish a task.       Use with discretion as some expanded fields can drastically increase payload size.<br/>       <br/>       <i>Allowed values: versions, product, timelines, premiums, premiumItems, premiumFormulas, currentVersion, currentTimelines, currentPremiums, currentPremiumItems, currentPremiumFormulas, partnerLinks<i>. [optional]
            filters (str): Filters the response by one or multiple fields.            Advanced filter functionality allows you to perform more complex filtering operations.<br/>           <br/>           <i>Allowed values: id, code, leadCode, policyNumber, holder, policyStartDate, productSlug, productVersionId, productId, accountCode, productName, status, statuses, createdAt, policyData, partnerCode</i>. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListPoliciesResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_policies_endpoint.call_with_http_info(**kwargs)

    def list_policy_objects(
        self,
        **kwargs
    ):
        """List policy objects  # noqa: E501

        Returns a list of policy objects you have previously created.          The policy objects are returned in sorted order, with the oldest one appearing first.          For more information about pagination, read the Pagination documentation.  **Required Permissions**  \"policy-management.policies.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_policy_objects(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            page_size (float): A limit on the number of objects to be returned.     Limit ranges between 1 and 50. Default: 10.. [optional]
            page_token (str): A cursor for use in pagination.     pageToken is an ID that defines your place in the list.     For instance, if you make a list request and receive 100 objects and pageToken=1, your subsequent call can include pageToken=2 in order to fetch the next page of the list.. [optional]
            filter (str): Filter the response by one or multiple fields.            In general, fetching filtered responses will conserve bandwidth and reduce response time.<br/>           <br/>           <i>Allowed values: id, code, insuredObjectId, insuredObjectName, policyCode, date</i>. [optional]
            search (str): To search the list by any field, pass search=xxx to fetch the result.. [optional]
            order (str): Order allows you to specify the desired order of entities retrieved from the server by           ascending (ASC) or descending (DESC) order.<br/>           <br/>           <i>Allowed values: id, code, timesliceId, insuredObjectId, createdAt, updatedAt</i>. [optional]
            expand (str): Expand to fetch additional information about the list items.       Expanding resources can reduce the number of API calls required to accomplish a task.       Use with discretion as some expanded fields can drastically increase payload size.<br/>       <br/>       . [optional]
            filters (str): Filters the response by one or multiple fields.            Advanced filter functionality allows you to perform more complex filtering operations.<br/>           <br/>           <i>Allowed values: id, code, insuredObjectId, insuredObjectName, policyCode, date</i>. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListPolicyObjectsResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_policy_objects_endpoint.call_with_http_info(**kwargs)

    def list_policy_versions(
        self,
        policy_code,
        **kwargs
    ):
        """List policy versions  # noqa: E501

        Returns a list of policy versions you have previously created.          The policy versions are returned in sorted order, with the oldest one appearing first.          For more information about pagination, read the Pagination documentation.  **Required Permissions**  \"policy-management.policies.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_policy_versions(policy_code, async_req=True)
        >>> result = thread.get()

        Args:
            policy_code (str):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            page_size (float): A limit on the number of objects to be returned.     Limit ranges between 1 and 50. Default: 10.. [optional]
            page_token (str): A cursor for use in pagination.     pageToken is an ID that defines your place in the list.     For instance, if you make a list request and receive 100 objects and pageToken=1, your subsequent call can include pageToken=2 in order to fetch the next page of the list.. [optional]
            filter (str): Filter the response by one or multiple fields.            In general, fetching filtered responses will conserve bandwidth and reduce response time.<br/>           <br/>           <i>Allowed values: id, policyId</i>. [optional]
            search (str): To search the list by any field, pass search=xxx to fetch the result.. [optional]
            order (str): Order allows you to specify the desired order of entities retrieved from the server by           ascending (ASC) or descending (DESC) order.<br/>           <br/>           <i>Allowed values: id, policyId, createdAt, updatedAt</i>. [optional]
            expand (str): Expand to fetch additional information about the list items.       Expanding resources can reduce the number of API calls required to accomplish a task.       Use with discretion as some expanded fields can drastically increase payload size.<br/>       <br/>       <i>Allowed values: timelines, premiums, premiumItems, premiumFormulas<i>. [optional]
            filters (str): Filters the response by one or multiple fields.            Advanced filter functionality allows you to perform more complex filtering operations.<br/>           <br/>           <i>Allowed values: id, policyId</i>. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListPolicyVersionResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['policy_code'] = \
            policy_code
        return self.list_policy_versions_endpoint.call_with_http_info(**kwargs)

    def patch_draft_policy(
        self,
        policy_code,
        patch_draft_policy_request_dto,
        **kwargs
    ):
        """Update the draft-policy  # noqa: E501

        Updates the specified draft-policy by setting the values of the parameters passed. Any parameters not provided will be left unchanged.  **Required Permissions**  \"policy-management.policies.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_draft_policy(policy_code, patch_draft_policy_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            policy_code (str): Unique identifier for the object.
            patch_draft_policy_request_dto (PatchDraftPolicyRequestDto):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PatchPolicyResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['policy_code'] = \
            policy_code
        kwargs['patch_draft_policy_request_dto'] = \
            patch_draft_policy_request_dto
        return self.patch_draft_policy_endpoint.call_with_http_info(**kwargs)

    def patch_policy(
        self,
        code,
        patch_policy_request_dto,
        **kwargs
    ):
        """Update the policy  # noqa: E501

        Updates the specified policy by setting the values of the parameters passed. Any parameters not provided will be left unchanged.  **Required Permissions**  \"policy-management.policies.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_policy(code, patch_policy_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            code (str): Unique identifier for the object.
            patch_policy_request_dto (PatchPolicyRequestDto):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PatchPolicyResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        kwargs['patch_policy_request_dto'] = \
            patch_policy_request_dto
        return self.patch_policy_endpoint.call_with_http_info(**kwargs)

    def restore_policy_version(
        self,
        policy_code,
        restore_policy_version_request_dto,
        **kwargs
    ):
        """Restore a policy version by versionId  # noqa: E501

        Request to restore an existing policy version by versionId.  **Required Permissions**  \"policy-management.policies.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.restore_policy_version(policy_code, restore_policy_version_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            policy_code (str): The policy code.
            restore_policy_version_request_dto (RestorePolicyVersionRequestDto):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RestorePolicyVersionResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['policy_code'] = \
            policy_code
        kwargs['restore_policy_version_request_dto'] = \
            restore_policy_version_request_dto
        return self.restore_policy_version_endpoint.call_with_http_info(**kwargs)

    def suspend_policy(
        self,
        policy_code,
        suspend_policy_request_dto,
        **kwargs
    ):
        """Suspend a policy by tenant  # noqa: E501

        Request to suspend an existing policy by tenant.  **Required Permissions**  \"policy-management.policies.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.suspend_policy(policy_code, suspend_policy_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            policy_code (str): The policy code.
            suspend_policy_request_dto (SuspendPolicyRequestDto):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SuspendPolicyResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['policy_code'] = \
            policy_code
        kwargs['suspend_policy_request_dto'] = \
            suspend_policy_request_dto
        return self.suspend_policy_endpoint.call_with_http_info(**kwargs)

    def terminate_policy(
        self,
        policy_code,
        terminate_policy_request_dto,
        **kwargs
    ):
        """Terminate a policy by tenant  # noqa: E501

        Request to terminate an existing policy by tenant.  **Required Permissions**  \"policy-management.policies.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.terminate_policy(policy_code, terminate_policy_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            policy_code (str): The policy code.
            terminate_policy_request_dto (TerminatePolicyRequestDto):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TerminatePolicyResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['policy_code'] = \
            policy_code
        kwargs['terminate_policy_request_dto'] = \
            terminate_policy_request_dto
        return self.terminate_policy_endpoint.call_with_http_info(**kwargs)

    def update_policy(
        self,
        code,
        update_policy_request_dto,
        **kwargs
    ):
        """Update the policy  # noqa: E501

        Updates the specified policy by setting the values of the parameters passed. Any parameters not provided will be left unchanged.  **Required Permissions**  \"policy-management.policies.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_policy(code, update_policy_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            code (str): Unique identifier for the object.
            update_policy_request_dto (UpdatePolicyRequestDto):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdatePolicyResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        kwargs['update_policy_request_dto'] = \
            update_policy_request_dto
        return self.update_policy_endpoint.call_with_http_info(**kwargs)

    def withdraw_policy(
        self,
        policy_code,
        body,
        **kwargs
    ):
        """Withdraw policy by tenant  # noqa: E501

        Withdraw policy by tenant.  **Required Permissions**  \"policy-management.policies.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.withdraw_policy(policy_code, body, async_req=True)
        >>> result = thread.get()

        Args:
            policy_code (str): The policy code.
            body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            WithdrawPolicyResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['policy_code'] = \
            policy_code
        kwargs['body'] = \
            body
        return self.withdraw_policy_endpoint.call_with_http_info(**kwargs)

