"""
    EMIL InsuranceService

    The EMIL InsuranceService API description  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.insurance.api_client import ApiClient, Endpoint as _Endpoint
from eis.insurance.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from eis.insurance.model.create_product_field_request_dto import CreateProductFieldRequestDto
from eis.insurance.model.create_product_field_response_class import CreateProductFieldResponseClass
from eis.insurance.model.delete_response_class import DeleteResponseClass
from eis.insurance.model.empty_response_class import EmptyResponseClass
from eis.insurance.model.get_product_field_response_class import GetProductFieldResponseClass
from eis.insurance.model.list_product_field_types_response_class import ListProductFieldTypesResponseClass
from eis.insurance.model.list_product_fields_response_class import ListProductFieldsResponseClass
from eis.insurance.model.swap_product_fields_order_request_dto import SwapProductFieldsOrderRequestDto
from eis.insurance.model.update_product_field_request_dto import UpdateProductFieldRequestDto
from eis.insurance.model.update_product_field_response_class import UpdateProductFieldResponseClass


class ProductFieldsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_product_field_endpoint = _Endpoint(
            settings={
                'response_type': (CreateProductFieldResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/product-fields',
                'operation_id': 'create_product_field',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_product_field_request_dto',
                    'authorization',
                ],
                'required': [
                    'create_product_field_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_product_field_request_dto':
                        (CreateProductFieldRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'create_product_field_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_product_field_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/product-fields/{id}',
                'operation_id': 'delete_product_field',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'authorization',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (float,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'id': 'path',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_product_field_endpoint = _Endpoint(
            settings={
                'response_type': (GetProductFieldResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/product-fields/{id}',
                'operation_id': 'get_product_field',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'authorization',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (float,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'id': 'path',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_product_field_types_endpoint = _Endpoint(
            settings={
                'response_type': (ListProductFieldTypesResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/product-fields/types',
                'operation_id': 'list_product_field_types',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'page_size',
                    'page_token',
                    'filter',
                    'search',
                    'order',
                    'expand',
                    'filters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'page_size':
                        (float,),
                    'page_token':
                        (str,),
                    'filter':
                        (str,),
                    'search':
                        (str,),
                    'order':
                        (str,),
                    'expand':
                        (str,),
                    'filters':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'page_size': 'pageSize',
                    'page_token': 'pageToken',
                    'filter': 'filter',
                    'search': 'search',
                    'order': 'order',
                    'expand': 'expand',
                    'filters': 'filters',
                },
                'location_map': {
                    'authorization': 'header',
                    'page_size': 'query',
                    'page_token': 'query',
                    'filter': 'query',
                    'search': 'query',
                    'order': 'query',
                    'expand': 'query',
                    'filters': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_product_fields_endpoint = _Endpoint(
            settings={
                'response_type': (ListProductFieldsResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/product-fields',
                'operation_id': 'list_product_fields',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'page_size',
                    'page_token',
                    'filter',
                    'search',
                    'order',
                    'expand',
                    'filters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'page_size':
                        (float,),
                    'page_token':
                        (str,),
                    'filter':
                        (str,),
                    'search':
                        (str,),
                    'order':
                        (str,),
                    'expand':
                        (str,),
                    'filters':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'page_size': 'pageSize',
                    'page_token': 'pageToken',
                    'filter': 'filter',
                    'search': 'search',
                    'order': 'order',
                    'expand': 'expand',
                    'filters': 'filters',
                },
                'location_map': {
                    'authorization': 'header',
                    'page_size': 'query',
                    'page_token': 'query',
                    'filter': 'query',
                    'search': 'query',
                    'order': 'query',
                    'expand': 'query',
                    'filters': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.swap_product_fields_order_endpoint = _Endpoint(
            settings={
                'response_type': (EmptyResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/product-fields/reorder',
                'operation_id': 'swap_product_fields_order',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'swap_product_fields_order_request_dto',
                    'authorization',
                ],
                'required': [
                    'swap_product_fields_order_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'swap_product_fields_order_request_dto':
                        (SwapProductFieldsOrderRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'swap_product_fields_order_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_product_field_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateProductFieldResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/product-fields/{id}',
                'operation_id': 'update_product_field',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'update_product_field_request_dto',
                    'authorization',
                ],
                'required': [
                    'id',
                    'update_product_field_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (float,),
                    'update_product_field_request_dto':
                        (UpdateProductFieldRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'id': 'path',
                    'update_product_field_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_product_field(
        self,
        create_product_field_request_dto,
        **kwargs
    ):
        """Create the product field  # noqa: E501

        Create a product field in the database.  **Required Permissions**  \"policy-management.products.create\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_product_field(create_product_field_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            create_product_field_request_dto (CreateProductFieldRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateProductFieldResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_product_field_request_dto'] = \
            create_product_field_request_dto
        return self.create_product_field_endpoint.call_with_http_info(**kwargs)

    def delete_product_field(
        self,
        id,
        **kwargs
    ):
        """Delete the product  # noqa: E501

        Permanently deletes the product. Supply the unique id that was returned when you created the product and this will delete it.  **Required Permissions**  \"policy-management.products.delete\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_product_field(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (float):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeleteResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.delete_product_field_endpoint.call_with_http_info(**kwargs)

    def get_product_field(
        self,
        id,
        **kwargs
    ):
        """Retrieve the product field  # noqa: E501

        Retrieves the details of the product field that was previously created.        Supply the unique product field id that was returned when you created it and Emil Api will return the corresponding product field information.  **Required Permissions**  \"policy-management.products.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_product_field(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (float):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetProductFieldResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_product_field_endpoint.call_with_http_info(**kwargs)

    def list_product_field_types(
        self,
        **kwargs
    ):
        """List product field types  # noqa: E501

        Returns a list of product field types you have previously created.        The product field types are returned in sorted order, with the oldest one appearing first.        For more information about pagination, read the Pagination documentation.  **Required Permissions**  \"policy-management.products.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_product_field_types(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            authorization (str): Bearer Token. [optional]
            page_size (float): Page size.. [optional]
            page_token (str): Page token.. [optional]
            filter (str): List filter. [optional]
            search (str): Search query.. [optional]
            order (str): Ordering criteria.. [optional]
            expand (str): Extra fields to fetch.. [optional]
            filters (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListProductFieldTypesResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_product_field_types_endpoint.call_with_http_info(**kwargs)

    def list_product_fields(
        self,
        **kwargs
    ):
        """List product fields  # noqa: E501

        Returns a list of product fields you have previously created.        The product fields are returned in sorted order, with the oldest one appearing first.        For more information about pagination, read the Pagination documentation.  **Required Permissions**  \"policy-management.products.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_product_fields(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            authorization (str): Bearer Token. [optional]
            page_size (float): Page size.. [optional]
            page_token (str): Page token.. [optional]
            filter (str): List filter. [optional]
            search (str): Search query.. [optional]
            order (str): Ordering criteria.. [optional]
            expand (str): Extra fields to fetch.. [optional]
            filters (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListProductFieldsResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_product_fields_endpoint.call_with_http_info(**kwargs)

    def swap_product_fields_order(
        self,
        swap_product_fields_order_request_dto,
        **kwargs
    ):
        """Swaps product fields order  # noqa: E501

        Order of the product field is mostly used for display for both the product and policy.This function will swap the order of two product fields, resulting in the two fields swapping their place in the list, be it on product or policy page.  **Required Permissions**  \"policy-management.products.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.swap_product_fields_order(swap_product_fields_order_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            swap_product_fields_order_request_dto (SwapProductFieldsOrderRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EmptyResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['swap_product_fields_order_request_dto'] = \
            swap_product_fields_order_request_dto
        return self.swap_product_fields_order_endpoint.call_with_http_info(**kwargs)

    def update_product_field(
        self,
        id,
        update_product_field_request_dto,
        **kwargs
    ):
        """Update the product  # noqa: E501

        Updates the specified product by setting the values of the parameters passed. Any parameters not provided will be left unchanged.  **Required Permissions**  \"policy-management.products.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_product_field(id, update_product_field_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            id (float):
            update_product_field_request_dto (UpdateProductFieldRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateProductFieldResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['update_product_field_request_dto'] = \
            update_product_field_request_dto
        return self.update_product_field_endpoint.call_with_http_info(**kwargs)

