"""
    EMIL InsuranceService

    The EMIL InsuranceService API description  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.insurance.api_client import ApiClient, Endpoint as _Endpoint
from eis.insurance.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from eis.insurance.model.create_product_request_dto import CreateProductRequestDto
from eis.insurance.model.create_product_response_class import CreateProductResponseClass
from eis.insurance.model.delete_response_class import DeleteResponseClass
from eis.insurance.model.get_product_response_class import GetProductResponseClass
from eis.insurance.model.list_products_response_class import ListProductsResponseClass
from eis.insurance.model.update_product_request_dto import UpdateProductRequestDto
from eis.insurance.model.update_product_response_class import UpdateProductResponseClass


class ProductsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_product_endpoint = _Endpoint(
            settings={
                'response_type': (CreateProductResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/products',
                'operation_id': 'create_product',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_product_request_dto',
                    'authorization',
                ],
                'required': [
                    'create_product_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_product_request_dto':
                        (CreateProductRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'create_product_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_product_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/products/{id}',
                'operation_id': 'delete_product',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'authorization',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (float,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'id': 'path',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_product_by_code_endpoint = _Endpoint(
            settings={
                'response_type': (GetProductResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/products/code/{code}',
                'operation_id': 'get_product_by_code',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'authorization',
                    'id',
                    'slug',
                    'expand',
                ],
                'required': [
                    'code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'authorization':
                        (str,),
                    'id':
                        (float,),
                    'slug':
                        (str,),
                    'expand':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                    'id': 'id',
                    'slug': 'slug',
                    'expand': 'expand',
                },
                'location_map': {
                    'code': 'path',
                    'authorization': 'header',
                    'id': 'query',
                    'slug': 'query',
                    'expand': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_product_by_identifier_endpoint = _Endpoint(
            settings={
                'response_type': (GetProductResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/products/get-by-identifier',
                'operation_id': 'get_product_by_identifier',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'id',
                    'code',
                    'slug',
                    'expand',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'id':
                        (float,),
                    'code':
                        (str,),
                    'slug':
                        (str,),
                    'expand':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'id': 'id',
                    'code': 'code',
                    'slug': 'slug',
                    'expand': 'expand',
                },
                'location_map': {
                    'authorization': 'header',
                    'id': 'query',
                    'code': 'query',
                    'slug': 'query',
                    'expand': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_products_endpoint = _Endpoint(
            settings={
                'response_type': (ListProductsResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/products',
                'operation_id': 'list_products',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'page_size',
                    'page_token',
                    'filter',
                    'search',
                    'order',
                    'expand',
                    'filters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'page_size':
                        (float,),
                    'page_token':
                        (str,),
                    'filter':
                        (str,),
                    'search':
                        (str,),
                    'order':
                        (str,),
                    'expand':
                        (str,),
                    'filters':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'page_size': 'pageSize',
                    'page_token': 'pageToken',
                    'filter': 'filter',
                    'search': 'search',
                    'order': 'order',
                    'expand': 'expand',
                    'filters': 'filters',
                },
                'location_map': {
                    'authorization': 'header',
                    'page_size': 'query',
                    'page_token': 'query',
                    'filter': 'query',
                    'search': 'query',
                    'order': 'query',
                    'expand': 'query',
                    'filters': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_product_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateProductResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/products/{id}',
                'operation_id': 'update_product',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'update_product_request_dto',
                    'authorization',
                ],
                'required': [
                    'id',
                    'update_product_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (float,),
                    'update_product_request_dto':
                        (UpdateProductRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'id': 'path',
                    'update_product_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_product(
        self,
        create_product_request_dto,
        **kwargs
    ):
        """Create the product  # noqa: E501

        Create a blank product. The product cannot be used as long    as it is missing product factors, insured objects and premium formulas.  **Required Permissions**  \"policy-management.products.create\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_product(create_product_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            create_product_request_dto (CreateProductRequestDto):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateProductResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_product_request_dto'] = \
            create_product_request_dto
        return self.create_product_endpoint.call_with_http_info(**kwargs)

    def delete_product(
        self,
        id,
        **kwargs
    ):
        """Delete the product  # noqa: E501

        Permanently deletes the product. Supply the unique id that was returned when you created the product and this will delete it.  **Required Permissions**  \"policy-management.products.delete\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_product(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (float):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeleteResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.delete_product_endpoint.call_with_http_info(**kwargs)

    def get_product_by_code(
        self,
        code,
        **kwargs
    ):
        """Retrieve the product  # noqa: E501

        Retrieves the details of the product that was previously created. Supply the unique product code      that was returned when you created it and Emil Api will return the corresponding product information.  **Required Permissions**  \"policy-management.products.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_product_by_code(code, async_req=True)
        >>> result = thread.get()

        Args:
            code (str): Unique identifier for the object.

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            id (float): Unique identifier referencing the product.. [optional]
            slug (str): A slug is a human-readable, unique identifier, used to identify a resource     instead of a less human-readable identifier like an id.. [optional]
            expand (str): Fields to expand response by. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetProductResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        return self.get_product_by_code_endpoint.call_with_http_info(**kwargs)

    def get_product_by_identifier(
        self,
        **kwargs
    ):
        """Retrieve the product  # noqa: E501

        Retrieves the details of the product that was previously created. Supply the unique product code      that was returned when you created it and Emil Api will return the corresponding product information.  **Required Permissions**  \"policy-management.products.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_product_by_identifier(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            id (float): Unique identifier referencing the product.. [optional]
            code (str): Unique identifier of the product that this object belongs to.. [optional]
            slug (str): A slug is a human-readable, unique identifier, used to identify a resource     instead of a less human-readable identifier like an id.. [optional]
            expand (str): Fields to expand response by. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetProductResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_product_by_identifier_endpoint.call_with_http_info(**kwargs)

    def list_products(
        self,
        **kwargs
    ):
        """List products  # noqa: E501

        Returns a list of products you have previously created.        The products are returned in sorted order, with the oldest one appearing first.        For more information about pagination, read the Pagination documentation.  **Required Permissions**  \"policy-management.products.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_products(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            page_size (float): Page size.. [optional]
            page_token (str): Page token.. [optional]
            filter (str): List filter. [optional]
            search (str): Search query.. [optional]
            order (str): Ordering criteria.. [optional]
            expand (str): You can expand product versions and insured object types list in this endpoint. By default, versions & insuredObjectTypes will be an empty array.. [optional]
            filters (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListProductsResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_products_endpoint.call_with_http_info(**kwargs)

    def update_product(
        self,
        id,
        update_product_request_dto,
        **kwargs
    ):
        """Update the product  # noqa: E501

        Updates the specified product by setting the values of the parameters passed. Any parameters not provided will be left unchanged.  **Required Permissions**  \"policy-management.products.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_product(id, update_product_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            id (float):
            update_product_request_dto (UpdateProductRequestDto):

        Keyword Args:
            authorization (str): Bearer Token: provided by the login endpoint under the name accessToken.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateProductResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['update_product_request_dto'] = \
            update_product_request_dto
        return self.update_product_endpoint.call_with_http_info(**kwargs)

