"""
    EMIL InsuranceService

    The EMIL InsuranceService API description  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.insurance.api_client import ApiClient, Endpoint as _Endpoint
from eis.insurance.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from eis.insurance.model.create_status_transition_rule_request_dto import CreateStatusTransitionRuleRequestDto
from eis.insurance.model.create_status_transition_rule_response_class import CreateStatusTransitionRuleResponseClass
from eis.insurance.model.delete_response_class import DeleteResponseClass
from eis.insurance.model.get_status_transition_rule_response_class import GetStatusTransitionRuleResponseClass
from eis.insurance.model.list_status_transition_rules_response_class import ListStatusTransitionRulesResponseClass
from eis.insurance.model.patch_status_transition_rule_request_dto import PatchStatusTransitionRuleRequestDto
from eis.insurance.model.patch_status_transition_rule_response_class import PatchStatusTransitionRuleResponseClass
from eis.insurance.model.update_status_transition_rule_request_dto import UpdateStatusTransitionRuleRequestDto
from eis.insurance.model.update_status_transition_rule_response_class import UpdateStatusTransitionRuleResponseClass


class StatusTransitionRulesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_status_transition_rule_endpoint = _Endpoint(
            settings={
                'response_type': (CreateStatusTransitionRuleResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/status-transitions/rules',
                'operation_id': 'create_status_transition_rule',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_status_transition_rule_request_dto',
                    'authorization',
                ],
                'required': [
                    'create_status_transition_rule_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_status_transition_rule_request_dto':
                        (CreateStatusTransitionRuleRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'create_status_transition_rule_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_status_transition_rule_endpoint = _Endpoint(
            settings={
                'response_type': (DeleteResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/status-transitions/rules/{code}',
                'operation_id': 'delete_status_transition_rule',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'authorization',
                ],
                'required': [
                    'code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'code': 'path',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_status_transition_rule_endpoint = _Endpoint(
            settings={
                'response_type': (GetStatusTransitionRuleResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/status-transitions/rules/{code}',
                'operation_id': 'get_status_transition_rule',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'authorization',
                    'expand',
                ],
                'required': [
                    'code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'authorization':
                        (str,),
                    'expand':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                    'expand': 'expand',
                },
                'location_map': {
                    'code': 'path',
                    'authorization': 'header',
                    'expand': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_status_transition_rules_endpoint = _Endpoint(
            settings={
                'response_type': (ListStatusTransitionRulesResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/status-transitions/rules',
                'operation_id': 'list_status_transition_rules',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'authorization',
                    'page_size',
                    'page_token',
                    'filter',
                    'search',
                    'order',
                    'expand',
                    'filters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'authorization':
                        (str,),
                    'page_size':
                        (float,),
                    'page_token':
                        (str,),
                    'filter':
                        (str,),
                    'search':
                        (str,),
                    'order':
                        (str,),
                    'expand':
                        (str,),
                    'filters':
                        (str,),
                },
                'attribute_map': {
                    'authorization': 'Authorization',
                    'page_size': 'pageSize',
                    'page_token': 'pageToken',
                    'filter': 'filter',
                    'search': 'search',
                    'order': 'order',
                    'expand': 'expand',
                    'filters': 'filters',
                },
                'location_map': {
                    'authorization': 'header',
                    'page_size': 'query',
                    'page_token': 'query',
                    'filter': 'query',
                    'search': 'query',
                    'order': 'query',
                    'expand': 'query',
                    'filters': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.patch_status_transition_rule_endpoint = _Endpoint(
            settings={
                'response_type': (PatchStatusTransitionRuleResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/status-transitions/rules/{code}',
                'operation_id': 'patch_status_transition_rule',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'patch_status_transition_rule_request_dto',
                    'authorization',
                ],
                'required': [
                    'code',
                    'patch_status_transition_rule_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'patch_status_transition_rule_request_dto':
                        (PatchStatusTransitionRuleRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'code': 'path',
                    'patch_status_transition_rule_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_status_transition_rule_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateStatusTransitionRuleResponseClass,),
                'auth': [
                    'bearer'
                ],
                'endpoint_path': '/insuranceservice/v1/status-transitions/rules/{code}',
                'operation_id': 'update_status_transition_rule',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'code',
                    'update_status_transition_rule_request_dto',
                    'authorization',
                ],
                'required': [
                    'code',
                    'update_status_transition_rule_request_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'code':
                        (str,),
                    'update_status_transition_rule_request_dto':
                        (UpdateStatusTransitionRuleRequestDto,),
                    'authorization':
                        (str,),
                },
                'attribute_map': {
                    'code': 'code',
                    'authorization': 'Authorization',
                },
                'location_map': {
                    'code': 'path',
                    'update_status_transition_rule_request_dto': 'body',
                    'authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_status_transition_rule(
        self,
        create_status_transition_rule_request_dto,
        **kwargs
    ):
        """Create the status transition rule  # noqa: E501

        This will create a status transition rule. Status transition rules allow or deny a transition from        one status to another based on custom conditions.  **Required Permissions**  \"policy-management.products.create\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_status_transition_rule(create_status_transition_rule_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            create_status_transition_rule_request_dto (CreateStatusTransitionRuleRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateStatusTransitionRuleResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_status_transition_rule_request_dto'] = \
            create_status_transition_rule_request_dto
        return self.create_status_transition_rule_endpoint.call_with_http_info(**kwargs)

    def delete_status_transition_rule(
        self,
        code,
        **kwargs
    ):
        """Delete the status transition rule  # noqa: E501

        Permanently deletes the status transition rule. Supply the unique code that was returned when you created the status transition rule and this will delete it.  **Required Permissions**  \"policy-management.products.delete\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_status_transition_rule(code, async_req=True)
        >>> result = thread.get()

        Args:
            code (str):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeleteResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        return self.delete_status_transition_rule_endpoint.call_with_http_info(**kwargs)

    def get_status_transition_rule(
        self,
        code,
        **kwargs
    ):
        """Retrieve the status transition rule  # noqa: E501

        Retrieves the details of the status transition rule that was previously created. Supply the unique status transition rule code      that was returned when you created it and Emil Api will return the corresponding status transition rule information.  **Required Permissions**  \"policy-management.products.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_status_transition_rule(code, async_req=True)
        >>> result = thread.get()

        Args:
            code (str): Unique identifier for the object.

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            expand (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetStatusTransitionRuleResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        return self.get_status_transition_rule_endpoint.call_with_http_info(**kwargs)

    def list_status_transition_rules(
        self,
        **kwargs
    ):
        """List status transition rules  # noqa: E501

        Returns a list of status transition rules you have previously created.        The status transition rules are returned in sorted order, with the oldest one appearing first.        For more information about pagination, read the Pagination documentation.  **Required Permissions**  \"policy-management.products.view\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_status_transition_rules(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            authorization (str): Bearer Token. [optional]
            page_size (float): A limit on the number of objects to be returned.     Limit ranges between 1 and 50. Default: 10.. [optional]
            page_token (str): A cursor for use in pagination.     pageToken is an ID that defines your place in the list.     For instance, if you make a list request and receive 100 objects and pageToken=1, your subsequent call can include pageToken=2 in order to fetch the next page of the list.. [optional]
            filter (str): Filter the response by one or multiple fields.     In general, fetching filtered responses will conserve bandwidth and reduce response time.. [optional]
            search (str): To search the list by any field, pass search=xxx to fetch the result.. [optional]
            order (str): The order parameter determines how the results should be sorted according to a specified field.     It functions similarly to an SQL ORDER BY.     Sorting can be performed in either ascending (ASC) or descending (DESC) order.     Default: ASC.. [optional]
            expand (str): Use this parameter to fetch additional information about the list items.     The expand query parameter increases the set of fields that appear in the response in addition to the default ones.     Expanding resources can reduce the number of API calls required to accomplish a task.     However, use this with parsimony as some expanded fields can drastically increase payload size.. [optional]
            filters (str): Filters the response by one or multiple fields.          Advanced filter functionality allows you to perform more complex filtering operations.          In general, fetching filtered responses conserves bandwidth and reduces response time.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListStatusTransitionRulesResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_status_transition_rules_endpoint.call_with_http_info(**kwargs)

    def patch_status_transition_rule(
        self,
        code,
        patch_status_transition_rule_request_dto,
        **kwargs
    ):
        """Patch the status transition rule  # noqa: E501

        Updates the specified status transition rule by setting the values of the parameters passed.       Any parameters not provided will be left unchanged.  **Required Permissions**  \"policy-management.products.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_status_transition_rule(code, patch_status_transition_rule_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            code (str): Unique identifier for the object.
            patch_status_transition_rule_request_dto (PatchStatusTransitionRuleRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PatchStatusTransitionRuleResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        kwargs['patch_status_transition_rule_request_dto'] = \
            patch_status_transition_rule_request_dto
        return self.patch_status_transition_rule_endpoint.call_with_http_info(**kwargs)

    def update_status_transition_rule(
        self,
        code,
        update_status_transition_rule_request_dto,
        **kwargs
    ):
        """Update the status transition rule  # noqa: E501

        Updates the specified status transition rule by setting the values of the parameters passed. Any parameters not provided will be left unchanged.  **Required Permissions**  \"policy-management.products.update\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_status_transition_rule(code, update_status_transition_rule_request_dto, async_req=True)
        >>> result = thread.get()

        Args:
            code (str): Unique identifier for the object.
            update_status_transition_rule_request_dto (UpdateStatusTransitionRuleRequestDto):

        Keyword Args:
            authorization (str): Bearer Token. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateStatusTransitionRuleResponseClass
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['code'] = \
            code
        kwargs['update_status_transition_rule_request_dto'] = \
            update_status_transition_rule_request_dto
        return self.update_status_transition_rule_endpoint.call_with_http_info(**kwargs)

