"""
    EMIL InsuranceService

    The EMIL InsuranceService API description  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.insurance.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from eis.insurance.exceptions import ApiAttributeError


def lazy_import():
    from eis.insurance.model.create_account_request_dto import CreateAccountRequestDto
    from eis.insurance.model.create_bank_account_request_dto import CreateBankAccountRequestDto
    from eis.insurance.model.create_payment_method_request_dto import CreatePaymentMethodRequestDto
    from eis.insurance.model.link_lead_partner_request_dto import LinkLeadPartnerRequestDto
    from eis.insurance.model.premium_override_request_dto import PremiumOverrideRequestDto
    from eis.insurance.model.shared_create_lead_policy_request_dto import SharedCreateLeadPolicyRequestDto
    from eis.insurance.model.uploaded_document_dto import UploadedDocumentDto
    globals()['CreateAccountRequestDto'] = CreateAccountRequestDto
    globals()['CreateBankAccountRequestDto'] = CreateBankAccountRequestDto
    globals()['CreatePaymentMethodRequestDto'] = CreatePaymentMethodRequestDto
    globals()['LinkLeadPartnerRequestDto'] = LinkLeadPartnerRequestDto
    globals()['PremiumOverrideRequestDto'] = PremiumOverrideRequestDto
    globals()['SharedCreateLeadPolicyRequestDto'] = SharedCreateLeadPolicyRequestDto
    globals()['UploadedDocumentDto'] = UploadedDocumentDto


class CreateLeadRequestDto(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'account': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'policy': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'code': (str,),  # noqa: E501
            'product_version_id': (float,),  # noqa: E501
            'account_code': (str,),  # noqa: E501
            'bank_account': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'custom_data': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'uploaded_document': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'premium_override': ([PremiumOverrideRequestDto],),  # noqa: E501
            'payment_method': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'validate': (bool,),  # noqa: E501
            'partner': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'account': 'account',  # noqa: E501
        'policy': 'policy',  # noqa: E501
        'code': 'code',  # noqa: E501
        'product_version_id': 'productVersionId',  # noqa: E501
        'account_code': 'accountCode',  # noqa: E501
        'bank_account': 'bankAccount',  # noqa: E501
        'custom_data': 'customData',  # noqa: E501
        'uploaded_document': 'uploadedDocument',  # noqa: E501
        'status': 'status',  # noqa: E501
        'premium_override': 'premiumOverride',  # noqa: E501
        'payment_method': 'paymentMethod',  # noqa: E501
        'validate': 'validate',  # noqa: E501
        'partner': 'partner',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, account, policy, *args, **kwargs):  # noqa: E501
        """CreateLeadRequestDto - a model defined in OpenAPI

        Args:
            account (bool, date, datetime, dict, float, int, list, str, none_type): Account object. The create lead request should either contain accountCode or account.     The account content will be validated if the 'validate' flag is set to true. an empty object is required if 'validate flag is set to false.
            policy (bool, date, datetime, dict, float, int, list, str, none_type): The policy object contains necessary information to create a policy.     The Policy content will be validated if the 'validate' flag is set to true

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            code (str): The lead code is used in cases where the lead has been initiated before the lead creation.. [optional]  # noqa: E501
            product_version_id (float): The product version id of the product version to be used for the lead.     The product version id will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
            account_code (str): The account code is used in cases where the account has been created before the lead.     The create lead request should include either the 'accountCode' or 'account'.     The account code will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
            bank_account (bool, date, datetime, dict, float, int, list, str, none_type): Bank account details, to be used for direct debit payments,     the created bank account will be attached to the lead for later use, such as paying claims.     The bank account content will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
            custom_data ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Optional custom data for the lead.     This field is useful for edge cases where the lead requires additional data for the risk carrier,     such as creating an application in the risk carrier platform or performing a premium calculation.     The custom data should include three main entities: 'data', 'provider', and 'productCode'.     The 'data' entity contains information used in the risk carrier platform,     the 'provider' field contains the name of the provider (usually the risk carrier's name), the provider must be supported in EMIL,     The 'productCode' field contains the product code in EMIL. [optional]  # noqa: E501
            uploaded_document (bool, date, datetime, dict, float, int, list, str, none_type): Used to pass pre-uploaded documents to the lead.     By providing the codes of the uploaded documents, they will be attached to the lead.     The uploaded document content will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
            status (str): Lead status. Default values are \"created\", \"approved\" and \"declined\".     However, those can be extended using /lead-statuses endpoint from insuranceservice.. [optional]  # noqa: E501
            premium_override ([PremiumOverrideRequestDto]): Premium Override is utilized to override the premium calculation.     The premium formulas will be disregarded when this object is present.     The premium override content will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
            payment_method (bool, date, datetime, dict, float, int, list, str, none_type): Payment method, used to for payment method support, such as SEPA, invoice, etc.     The payment method content will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
            validate (bool): The validation indicator, with a default value of true, serves as a toggle.     When set to false, it allows the bypassing of validation—a useful option for saving leads for later processing.     This feature provides flexibility by enabling users to choose whether to enforce validation checks during     the current stage or defer them for a subsequent time.. [optional] if omitted the server will use the default value of True  # noqa: E501
            partner (bool, date, datetime, dict, float, int, list, str, none_type): Optional partner object contains necessary information to link a partner to the policy.     The partner content will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.account = account
        self.policy = policy
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, account, policy, *args, **kwargs):  # noqa: E501
        """CreateLeadRequestDto - a model defined in OpenAPI

        Args:
            account (bool, date, datetime, dict, float, int, list, str, none_type): Account object. The create lead request should either contain accountCode or account.     The account content will be validated if the 'validate' flag is set to true. an empty object is required if 'validate flag is set to false.
            policy (bool, date, datetime, dict, float, int, list, str, none_type): The policy object contains necessary information to create a policy.     The Policy content will be validated if the 'validate' flag is set to true

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            code (str): The lead code is used in cases where the lead has been initiated before the lead creation.. [optional]  # noqa: E501
            product_version_id (float): The product version id of the product version to be used for the lead.     The product version id will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
            account_code (str): The account code is used in cases where the account has been created before the lead.     The create lead request should include either the 'accountCode' or 'account'.     The account code will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
            bank_account (bool, date, datetime, dict, float, int, list, str, none_type): Bank account details, to be used for direct debit payments,     the created bank account will be attached to the lead for later use, such as paying claims.     The bank account content will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
            custom_data ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Optional custom data for the lead.     This field is useful for edge cases where the lead requires additional data for the risk carrier,     such as creating an application in the risk carrier platform or performing a premium calculation.     The custom data should include three main entities: 'data', 'provider', and 'productCode'.     The 'data' entity contains information used in the risk carrier platform,     the 'provider' field contains the name of the provider (usually the risk carrier's name), the provider must be supported in EMIL,     The 'productCode' field contains the product code in EMIL. [optional]  # noqa: E501
            uploaded_document (bool, date, datetime, dict, float, int, list, str, none_type): Used to pass pre-uploaded documents to the lead.     By providing the codes of the uploaded documents, they will be attached to the lead.     The uploaded document content will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
            status (str): Lead status. Default values are \"created\", \"approved\" and \"declined\".     However, those can be extended using /lead-statuses endpoint from insuranceservice.. [optional]  # noqa: E501
            premium_override ([PremiumOverrideRequestDto]): Premium Override is utilized to override the premium calculation.     The premium formulas will be disregarded when this object is present.     The premium override content will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
            payment_method (bool, date, datetime, dict, float, int, list, str, none_type): Payment method, used to for payment method support, such as SEPA, invoice, etc.     The payment method content will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
            validate (bool): The validation indicator, with a default value of true, serves as a toggle.     When set to false, it allows the bypassing of validation—a useful option for saving leads for later processing.     This feature provides flexibility by enabling users to choose whether to enforce validation checks during     the current stage or defer them for a subsequent time.. [optional] if omitted the server will use the default value of True  # noqa: E501
            partner (bool, date, datetime, dict, float, int, list, str, none_type): Optional partner object contains necessary information to link a partner to the policy.     The partner content will be validated if the 'validate' flag is set to true.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.account = account
        self.policy = policy
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
