"""
    EMIL InsuranceService

    The EMIL InsuranceService API description  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: kontakt@emil.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from eis.insurance.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from eis.insurance.exceptions import ApiAttributeError



class UpdateProductFieldRequestDto(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('type_entity',): {
            'SYSTEM_PRODUCT_FIELD_TYPE': "system_product_field_type",
            'PRODUCT_FACTOR_TYPE': "product_factor_type",
        },
        ('used_in_premium_calculation_override',): {
            'USED': "used",
            'NOT_USED': "not_used",
        },
        ('used_in_field_calculation_override',): {
            'USED': "used",
            'NOT_USED': "not_used",
        },
    }

    validations = {
        ('name',): {
            'regex': {
                'pattern': r'^[_$a-zA-Z][_$a-zA-Z0-9]*$',  # noqa: E501
            },
        },
        ('order',): {
            'inclusive_maximum': 10000,
            'inclusive_minimum': 0,
        },
        ('legacy_bf_order',): {
            'inclusive_maximum': 10000,
            'inclusive_minimum': 0,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'id': (float,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'label': (str,),  # noqa: E501
            'type_entity': (str,),  # noqa: E501
            'type_id': (float,),  # noqa: E501
            'insured_object_id': (float,),  # noqa: E501
            'group': (str,),  # noqa: E501
            'is_required': (bool,),  # noqa: E501
            'is_hidden': (bool,),  # noqa: E501
            'is_hidden_customer_portal': (bool,),  # noqa: E501
            'is_editable_customer_portal': (bool,),  # noqa: E501
            'is_unique': (bool,),  # noqa: E501
            'default_value': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'bf_description': (str,),  # noqa: E501
            'bf_tooltip': (str,),  # noqa: E501
            'bf_label': (str,),  # noqa: E501
            'expression': (str,),  # noqa: E501
            'min_value': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'max_value': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'order': (float,),  # noqa: E501
            'legacy_bf_order': (float,),  # noqa: E501
            'metadata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'used_in_premium_calculation_override': (str,),  # noqa: E501
            'used_in_field_calculation_override': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'name': 'name',  # noqa: E501
        'label': 'label',  # noqa: E501
        'type_entity': 'typeEntity',  # noqa: E501
        'type_id': 'typeId',  # noqa: E501
        'insured_object_id': 'insuredObjectId',  # noqa: E501
        'group': 'group',  # noqa: E501
        'is_required': 'isRequired',  # noqa: E501
        'is_hidden': 'isHidden',  # noqa: E501
        'is_hidden_customer_portal': 'isHiddenCustomerPortal',  # noqa: E501
        'is_editable_customer_portal': 'isEditableCustomerPortal',  # noqa: E501
        'is_unique': 'isUnique',  # noqa: E501
        'default_value': 'defaultValue',  # noqa: E501
        'bf_description': 'bfDescription',  # noqa: E501
        'bf_tooltip': 'bfTooltip',  # noqa: E501
        'bf_label': 'bfLabel',  # noqa: E501
        'expression': 'expression',  # noqa: E501
        'min_value': 'minValue',  # noqa: E501
        'max_value': 'maxValue',  # noqa: E501
        'order': 'order',  # noqa: E501
        'legacy_bf_order': 'legacyBfOrder',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'used_in_premium_calculation_override': 'usedInPremiumCalculationOverride',  # noqa: E501
        'used_in_field_calculation_override': 'usedInFieldCalculationOverride',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, id, name, label, type_entity, type_id, insured_object_id, group, is_required, is_hidden, is_hidden_customer_portal, is_editable_customer_portal, is_unique, default_value, *args, **kwargs):  # noqa: E501
        """UpdateProductFieldRequestDto - a model defined in OpenAPI

        Args:
            id (float): Internal unique identifier for the object. You should not have to use this, use code instead.
            name (str): Product field name.
            label (str): Product field label.
            type_entity (str): Product field type.
            type_id (float): Unique identifier referencing the product field type..
            insured_object_id (float): Unique identifier referencing the insured object.
            group (str): Product field group.
            is_required (bool): Is field required?
            is_hidden (bool): Is field hidden on the booking funnel?
            is_hidden_customer_portal (bool): Should the field be hidden on customer portal?
            is_editable_customer_portal (bool): Should the field be editable on customer portal?
            is_unique (bool): Should the field value be unique across policies?
            default_value ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Default value of the field. For the field type date-time, it should be { \"templated\" : \"{{today}}\" }

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            bf_description (str): Booking funnel description.. [optional]  # noqa: E501
            bf_tooltip (str): Booking funnel tooltip.. [optional]  # noqa: E501
            bf_label (str): Booking funnel label.. [optional]  # noqa: E501
            expression (str): Expression to calculate the field.. [optional]  # noqa: E501
            min_value ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Minimum value of the field. For the field type date-time, it should be { \"templated\" : \"{{today}}\" }. [optional]  # noqa: E501
            max_value ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Maximum value of the field. For the field type date-time, it should be { \"templated\" : \"{{today}}\" }. [optional]  # noqa: E501
            order (float): Order index for the product field item, used to define the order of the items in the insured object. The order will also impact the order of the items in the policy itself.. [optional]  # noqa: E501
            legacy_bf_order (float): order index for the product field for display on the booking funnel, not defined for hidden fields.. [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Product field metadata object. The field may contain special data specific to the product.. [optional]  # noqa: E501
            used_in_premium_calculation_override (str): Overrides automatic dependency check result (if this field is used in the premium calculation or not).. [optional]  # noqa: E501
            used_in_field_calculation_override (str): Overrides automatic dependency check result (if this field is used in the product field calculation or not).. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.name = name
        self.label = label
        self.type_entity = type_entity
        self.type_id = type_id
        self.insured_object_id = insured_object_id
        self.group = group
        self.is_required = is_required
        self.is_hidden = is_hidden
        self.is_hidden_customer_portal = is_hidden_customer_portal
        self.is_editable_customer_portal = is_editable_customer_portal
        self.is_unique = is_unique
        self.default_value = default_value
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, id, name, label, type_entity, type_id, insured_object_id, group, is_required, is_hidden, is_hidden_customer_portal, is_editable_customer_portal, is_unique, default_value, *args, **kwargs):  # noqa: E501
        """UpdateProductFieldRequestDto - a model defined in OpenAPI

        Args:
            id (float): Internal unique identifier for the object. You should not have to use this, use code instead.
            name (str): Product field name.
            label (str): Product field label.
            type_entity (str): Product field type.
            type_id (float): Unique identifier referencing the product field type..
            insured_object_id (float): Unique identifier referencing the insured object.
            group (str): Product field group.
            is_required (bool): Is field required?
            is_hidden (bool): Is field hidden on the booking funnel?
            is_hidden_customer_portal (bool): Should the field be hidden on customer portal?
            is_editable_customer_portal (bool): Should the field be editable on customer portal?
            is_unique (bool): Should the field value be unique across policies?
            default_value ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Default value of the field. For the field type date-time, it should be { \"templated\" : \"{{today}}\" }

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            bf_description (str): Booking funnel description.. [optional]  # noqa: E501
            bf_tooltip (str): Booking funnel tooltip.. [optional]  # noqa: E501
            bf_label (str): Booking funnel label.. [optional]  # noqa: E501
            expression (str): Expression to calculate the field.. [optional]  # noqa: E501
            min_value ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Minimum value of the field. For the field type date-time, it should be { \"templated\" : \"{{today}}\" }. [optional]  # noqa: E501
            max_value ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Maximum value of the field. For the field type date-time, it should be { \"templated\" : \"{{today}}\" }. [optional]  # noqa: E501
            order (float): Order index for the product field item, used to define the order of the items in the insured object. The order will also impact the order of the items in the policy itself.. [optional]  # noqa: E501
            legacy_bf_order (float): order index for the product field for display on the booking funnel, not defined for hidden fields.. [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Product field metadata object. The field may contain special data specific to the product.. [optional]  # noqa: E501
            used_in_premium_calculation_override (str): Overrides automatic dependency check result (if this field is used in the premium calculation or not).. [optional]  # noqa: E501
            used_in_field_calculation_override (str): Overrides automatic dependency check result (if this field is used in the product field calculation or not).. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.name = name
        self.label = label
        self.type_entity = type_entity
        self.type_id = type_id
        self.insured_object_id = insured_object_id
        self.group = group
        self.is_required = is_required
        self.is_hidden = is_hidden
        self.is_hidden_customer_portal = is_hidden_customer_portal
        self.is_editable_customer_portal = is_editable_customer_portal
        self.is_unique = is_unique
        self.default_value = default_value
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
