import * as waf from 'aws-cdk-lib/aws-wafv2';
import { Construct } from 'constructs';
export interface WafGeoRestrictRuleGroupProps {
    readonly name?: string;
    readonly scope: Scope;
    readonly allowCountries: string[];
    readonly ipRateLimiting?: IpRateLimitingProperty;
    readonly allowIpSetArn?: string;
}
export interface IpRateLimitingProperty {
    readonly enable: boolean;
    readonly count: number;
}
export declare enum Scope {
    GLOBAL = "Global",
    REGIONAL = "Regional"
}
export declare class WafGeoRestrictRuleGroup extends waf.CfnRuleGroup {
    constructor(scope: Construct, id: string, props: WafGeoRestrictRuleGroupProps);
}
