"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafGeoRestrictRuleGroup = exports.Scope = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const waf = require("aws-cdk-lib/aws-wafv2");
var Scope;
(function (Scope) {
    Scope["GLOBAL"] = "Global";
    Scope["REGIONAL"] = "Regional";
})(Scope = exports.Scope || (exports.Scope = {}));
class WafGeoRestrictRuleGroup extends waf.CfnRuleGroup {
    constructor(scope, id, props) {
        super(scope, id, {
            name: props.name,
            description: 'geo restrict rule group',
            scope: (() => {
                switch (props.scope) {
                    case Scope.GLOBAL:
                        return 'CLOUDFRONT';
                    case Scope.REGIONAL:
                        return 'REGIONAL';
                }
            })(),
            capacity: 10,
            rules: (() => {
                const defaults = [
                    {
                        priority: 4,
                        name: 'allow-geo-rule',
                        action: {
                            allow: {},
                        },
                        visibilityConfig: {
                            cloudWatchMetricsEnabled: true,
                            sampledRequestsEnabled: true,
                            metricName: 'AllowGeoRule',
                        },
                        statement: {
                            geoMatchStatement: {
                                countryCodes: props.allowCountries,
                            },
                        },
                    },
                    {
                        priority: 5,
                        name: 'deny-geo-rule',
                        action: {
                            block: {
                                CustomResponse: {
                                    CustomResponseBodyKey: 'geo-restrict',
                                    ResponseCode: 403,
                                },
                            },
                        },
                        visibilityConfig: {
                            cloudWatchMetricsEnabled: true,
                            sampledRequestsEnabled: true,
                            metricName: 'DenyGeoRule',
                        },
                        statement: {
                            notStatement: {
                                statement: {
                                    geoMatchStatement: {
                                        countryCodes: props.allowCountries,
                                    },
                                },
                            },
                        },
                    },
                ];
                if (props.ipRateLimiting) {
                    if (props.ipRateLimiting.enable) {
                        if (props.ipRateLimiting.count < 100) {
                            throw new Error('IP rate limiting count value needs to be above 100');
                        }
                        else {
                            const rule = {
                                priority: 2,
                                name: 'ip-rate-limiting-rule',
                                action: {
                                    block: {
                                        CustomResponse: {
                                            CustomResponseBodyKey: 'ip-rate-restrict',
                                            ResponseCode: 429,
                                        },
                                    },
                                },
                                visibilityConfig: {
                                    cloudWatchMetricsEnabled: true,
                                    sampledRequestsEnabled: true,
                                    metricName: 'DenyIpLimitingRule',
                                },
                                statement: {
                                    rateBasedStatement: {
                                        aggregateKeyType: 'IP',
                                        limit: props.ipRateLimiting.count,
                                    },
                                },
                            };
                            defaults.push(rule);
                        }
                    }
                }
                if (props.allowIpSetArn) {
                    const rule = {
                        priority: 0,
                        name: 'allow-ip-set-rule',
                        action: { allow: {} },
                        visibilityConfig: {
                            sampledRequestsEnabled: true,
                            cloudWatchMetricsEnabled: true,
                            metricName: 'AllowIpSetRule',
                        },
                        statement: {
                            ipSetReferenceStatement: {
                                arn: props.allowIpSetArn,
                            },
                        },
                    };
                    defaults.push(rule);
                }
                return defaults;
            })(),
            customResponseBodies: {
                ['geo-restrict']: {
                    contentType: 'TEXT_PLAIN',
                    content: 'Sorry, You Are Not Allowed to Access This Service.',
                },
                ['ip-rate-restrict']: {
                    contentType: 'TEXT_PLAIN',
                    content: 'Sorry, You Are Not Allowed to Access This Service.',
                },
                ['sample-restrict']: {
                    contentType: 'TEXT_PLAIN',
                    content: 'Sorry, You Are Not Allowed to Access This Service.',
                },
            },
            visibilityConfig: {
                cloudWatchMetricsEnabled: true,
                sampledRequestsEnabled: true,
                metricName: 'GeoRestrictRule',
            },
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
WafGeoRestrictRuleGroup[_a] = { fqn: "@gammarer/aws-waf-geo-restriction-rule-group.WafGeoRestrictRuleGroup", version: "0.9.32" };
exports.WafGeoRestrictRuleGroup = WafGeoRestrictRuleGroup;
//# sourceMappingURL=data:application/json;base64,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