# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

import types

__config__ = pulumi.Config('docker')


class _ExportableConfig(types.ModuleType):
    @_builtins.property
    def ca_material(self) -> Optional[str]:
        """
        PEM-encoded content of Docker host CA certificate
        """
        return __config__.get('caMaterial')

    @_builtins.property
    def cert_material(self) -> Optional[str]:
        """
        PEM-encoded content of Docker client certificate
        """
        return __config__.get('certMaterial')

    @_builtins.property
    def cert_path(self) -> Optional[str]:
        """
        Path to directory with Docker TLS config
        """
        return __config__.get('certPath')

    @_builtins.property
    def context(self) -> Optional[str]:
        """
        The name of the Docker context to use. Can also be set via `DOCKER_CONTEXT` environment variable. Overrides the `host`
        if set.
        """
        return __config__.get('context')

    @_builtins.property
    def disable_docker_daemon_check(self) -> Optional[bool]:
        """
        If set to `true`, the provider will not check if the Docker daemon is running. This is useful for
        resources/data_sourcess that do not require a running Docker daemon, such as the data source `RegistryImage`.
        """
        return __config__.get_bool('disableDockerDaemonCheck')

    @_builtins.property
    def host(self) -> Optional[str]:
        """
        The Docker daemon address
        """
        return __config__.get('host') or _utilities.get_env('DOCKER_HOST')

    @_builtins.property
    def key_material(self) -> Optional[str]:
        """
        PEM-encoded content of Docker client private key
        """
        return __config__.get('keyMaterial')

    @_builtins.property
    def registry_auth(self) -> Optional[str]:
        return __config__.get('registryAuth')

    @_builtins.property
    def ssh_opts(self) -> Optional[str]:
        """
        Additional SSH option flags to be appended when using `ssh://` protocol
        """
        return __config__.get('sshOpts')

