# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRegistryImageManifestsResult',
    'AwaitableGetRegistryImageManifestsResult',
    'get_registry_image_manifests',
    'get_registry_image_manifests_output',
]

@pulumi.output_type
class GetRegistryImageManifestsResult:
    """
    A collection of values returned by getRegistryImageManifests.
    """
    def __init__(__self__, auth_config=None, id=None, insecure_skip_verify=None, manifests=None, name=None):
        if auth_config and not isinstance(auth_config, dict):
            raise TypeError("Expected argument 'auth_config' to be a dict")
        pulumi.set(__self__, "auth_config", auth_config)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if insecure_skip_verify and not isinstance(insecure_skip_verify, bool):
            raise TypeError("Expected argument 'insecure_skip_verify' to be a bool")
        pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if manifests and not isinstance(manifests, list):
            raise TypeError("Expected argument 'manifests' to be a list")
        pulumi.set(__self__, "manifests", manifests)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional['outputs.GetRegistryImageManifestsAuthConfigResult']:
        """
        Authentication configuration for the Docker registry. It is only used for this resource.
        """
        return pulumi.get(self, "auth_config")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[_builtins.bool]:
        """
        If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
        """
        return pulumi.get(self, "insecure_skip_verify")

    @_builtins.property
    @pulumi.getter
    def manifests(self) -> Sequence['outputs.GetRegistryImageManifestsManifestResult']:
        """
        The metadata for each manifest in the image
        """
        return pulumi.get(self, "manifests")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Docker image, including any tags. e.g. `alpine:latest`
        """
        return pulumi.get(self, "name")


class AwaitableGetRegistryImageManifestsResult(GetRegistryImageManifestsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegistryImageManifestsResult(
            auth_config=self.auth_config,
            id=self.id,
            insecure_skip_verify=self.insecure_skip_verify,
            manifests=self.manifests,
            name=self.name)


def get_registry_image_manifests(auth_config: Optional[Union['GetRegistryImageManifestsAuthConfigArgs', 'GetRegistryImageManifestsAuthConfigArgsDict']] = None,
                                 insecure_skip_verify: Optional[_builtins.bool] = None,
                                 name: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegistryImageManifestsResult:
    """
    Reads the image metadata for each manifest in a Docker multi-arch image from a Docker Registry.


    :param Union['GetRegistryImageManifestsAuthConfigArgs', 'GetRegistryImageManifestsAuthConfigArgsDict'] auth_config: Authentication configuration for the Docker registry. It is only used for this resource.
    :param _builtins.bool insecure_skip_verify: If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
    :param _builtins.str name: The name of the Docker image, including any tags. e.g. `alpine:latest`
    """
    __args__ = dict()
    __args__['authConfig'] = auth_config
    __args__['insecureSkipVerify'] = insecure_skip_verify
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('docker:index/getRegistryImageManifests:getRegistryImageManifests', __args__, opts=opts, typ=GetRegistryImageManifestsResult).value

    return AwaitableGetRegistryImageManifestsResult(
        auth_config=pulumi.get(__ret__, 'auth_config'),
        id=pulumi.get(__ret__, 'id'),
        insecure_skip_verify=pulumi.get(__ret__, 'insecure_skip_verify'),
        manifests=pulumi.get(__ret__, 'manifests'),
        name=pulumi.get(__ret__, 'name'))
def get_registry_image_manifests_output(auth_config: Optional[pulumi.Input[Optional[Union['GetRegistryImageManifestsAuthConfigArgs', 'GetRegistryImageManifestsAuthConfigArgsDict']]]] = None,
                                        insecure_skip_verify: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                        name: Optional[pulumi.Input[_builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegistryImageManifestsResult]:
    """
    Reads the image metadata for each manifest in a Docker multi-arch image from a Docker Registry.


    :param Union['GetRegistryImageManifestsAuthConfigArgs', 'GetRegistryImageManifestsAuthConfigArgsDict'] auth_config: Authentication configuration for the Docker registry. It is only used for this resource.
    :param _builtins.bool insecure_skip_verify: If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
    :param _builtins.str name: The name of the Docker image, including any tags. e.g. `alpine:latest`
    """
    __args__ = dict()
    __args__['authConfig'] = auth_config
    __args__['insecureSkipVerify'] = insecure_skip_verify
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('docker:index/getRegistryImageManifests:getRegistryImageManifests', __args__, opts=opts, typ=GetRegistryImageManifestsResult)
    return __ret__.apply(lambda __response__: GetRegistryImageManifestsResult(
        auth_config=pulumi.get(__response__, 'auth_config'),
        id=pulumi.get(__response__, 'id'),
        insecure_skip_verify=pulumi.get(__response__, 'insecure_skip_verify'),
        manifests=pulumi.get(__response__, 'manifests'),
        name=pulumi.get(__response__, 'name')))
