# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 ca_material: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_material: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_path: Optional[pulumi.Input[_builtins.str]] = None,
                 context: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_docker_daemon_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 key_material: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_auth: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderRegistryAuthArgs']]]] = None,
                 ssh_opts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] ca_material: PEM-encoded content of Docker host CA certificate
        :param pulumi.Input[_builtins.str] cert_material: PEM-encoded content of Docker client certificate
        :param pulumi.Input[_builtins.str] cert_path: Path to directory with Docker TLS config
        :param pulumi.Input[_builtins.str] context: The name of the Docker context to use. Can also be set via `DOCKER_CONTEXT` environment variable. Overrides the `host`
               if set.
        :param pulumi.Input[_builtins.bool] disable_docker_daemon_check: If set to `true`, the provider will not check if the Docker daemon is running. This is useful for
               resources/data_sourcess that do not require a running Docker daemon, such as the data source `RegistryImage`.
        :param pulumi.Input[_builtins.str] host: The Docker daemon address
        :param pulumi.Input[_builtins.str] key_material: PEM-encoded content of Docker client private key
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_opts: Additional SSH option flags to be appended when using `ssh://` protocol
        """
        if ca_material is not None:
            pulumi.set(__self__, "ca_material", ca_material)
        if cert_material is not None:
            pulumi.set(__self__, "cert_material", cert_material)
        if cert_path is not None:
            pulumi.set(__self__, "cert_path", cert_path)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if disable_docker_daemon_check is not None:
            pulumi.set(__self__, "disable_docker_daemon_check", disable_docker_daemon_check)
        if host is None:
            host = _utilities.get_env('DOCKER_HOST')
        if host is not None:
            pulumi.set(__self__, "host", host)
        if key_material is not None:
            pulumi.set(__self__, "key_material", key_material)
        if registry_auth is not None:
            pulumi.set(__self__, "registry_auth", registry_auth)
        if ssh_opts is not None:
            pulumi.set(__self__, "ssh_opts", ssh_opts)

    @_builtins.property
    @pulumi.getter(name="caMaterial")
    def ca_material(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PEM-encoded content of Docker host CA certificate
        """
        return pulumi.get(self, "ca_material")

    @ca_material.setter
    def ca_material(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_material", value)

    @_builtins.property
    @pulumi.getter(name="certMaterial")
    def cert_material(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PEM-encoded content of Docker client certificate
        """
        return pulumi.get(self, "cert_material")

    @cert_material.setter
    def cert_material(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_material", value)

    @_builtins.property
    @pulumi.getter(name="certPath")
    def cert_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to directory with Docker TLS config
        """
        return pulumi.get(self, "cert_path")

    @cert_path.setter
    def cert_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_path", value)

    @_builtins.property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Docker context to use. Can also be set via `DOCKER_CONTEXT` environment variable. Overrides the `host`
        if set.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "context", value)

    @_builtins.property
    @pulumi.getter(name="disableDockerDaemonCheck")
    def disable_docker_daemon_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the provider will not check if the Docker daemon is running. This is useful for
        resources/data_sourcess that do not require a running Docker daemon, such as the data source `RegistryImage`.
        """
        return pulumi.get(self, "disable_docker_daemon_check")

    @disable_docker_daemon_check.setter
    def disable_docker_daemon_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_docker_daemon_check", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Docker daemon address
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="keyMaterial")
    def key_material(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PEM-encoded content of Docker client private key
        """
        return pulumi.get(self, "key_material")

    @key_material.setter
    def key_material(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_material", value)

    @_builtins.property
    @pulumi.getter(name="registryAuth")
    def registry_auth(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProviderRegistryAuthArgs']]]]:
        return pulumi.get(self, "registry_auth")

    @registry_auth.setter
    def registry_auth(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderRegistryAuthArgs']]]]):
        pulumi.set(self, "registry_auth", value)

    @_builtins.property
    @pulumi.getter(name="sshOpts")
    def ssh_opts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Additional SSH option flags to be appended when using `ssh://` protocol
        """
        return pulumi.get(self, "ssh_opts")

    @ssh_opts.setter
    def ssh_opts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ssh_opts", value)


@pulumi.type_token("pulumi:providers:docker")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_material: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_material: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_path: Optional[pulumi.Input[_builtins.str]] = None,
                 context: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_docker_daemon_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 key_material: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_auth: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderRegistryAuthArgs', 'ProviderRegistryAuthArgsDict']]]]] = None,
                 ssh_opts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        The provider type for the docker package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ca_material: PEM-encoded content of Docker host CA certificate
        :param pulumi.Input[_builtins.str] cert_material: PEM-encoded content of Docker client certificate
        :param pulumi.Input[_builtins.str] cert_path: Path to directory with Docker TLS config
        :param pulumi.Input[_builtins.str] context: The name of the Docker context to use. Can also be set via `DOCKER_CONTEXT` environment variable. Overrides the `host`
               if set.
        :param pulumi.Input[_builtins.bool] disable_docker_daemon_check: If set to `true`, the provider will not check if the Docker daemon is running. This is useful for
               resources/data_sourcess that do not require a running Docker daemon, such as the data source `RegistryImage`.
        :param pulumi.Input[_builtins.str] host: The Docker daemon address
        :param pulumi.Input[_builtins.str] key_material: PEM-encoded content of Docker client private key
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_opts: Additional SSH option flags to be appended when using `ssh://` protocol
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the docker package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_material: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_material: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_path: Optional[pulumi.Input[_builtins.str]] = None,
                 context: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_docker_daemon_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 key_material: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_auth: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderRegistryAuthArgs', 'ProviderRegistryAuthArgsDict']]]]] = None,
                 ssh_opts: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["ca_material"] = ca_material
            __props__.__dict__["cert_material"] = cert_material
            __props__.__dict__["cert_path"] = cert_path
            __props__.__dict__["context"] = context
            __props__.__dict__["disable_docker_daemon_check"] = pulumi.Output.from_input(disable_docker_daemon_check).apply(pulumi.runtime.to_json) if disable_docker_daemon_check is not None else None
            if host is None:
                host = _utilities.get_env('DOCKER_HOST')
            __props__.__dict__["host"] = host
            __props__.__dict__["key_material"] = key_material
            __props__.__dict__["registry_auth"] = pulumi.Output.from_input(registry_auth).apply(pulumi.runtime.to_json) if registry_auth is not None else None
            __props__.__dict__["ssh_opts"] = pulumi.Output.from_input(ssh_opts).apply(pulumi.runtime.to_json) if ssh_opts is not None else None
        super(Provider, __self__).__init__(
            'docker',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="caMaterial")
    def ca_material(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        PEM-encoded content of Docker host CA certificate
        """
        return pulumi.get(self, "ca_material")

    @_builtins.property
    @pulumi.getter(name="certMaterial")
    def cert_material(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        PEM-encoded content of Docker client certificate
        """
        return pulumi.get(self, "cert_material")

    @_builtins.property
    @pulumi.getter(name="certPath")
    def cert_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to directory with Docker TLS config
        """
        return pulumi.get(self, "cert_path")

    @_builtins.property
    @pulumi.getter
    def context(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Docker context to use. Can also be set via `DOCKER_CONTEXT` environment variable. Overrides the `host`
        if set.
        """
        return pulumi.get(self, "context")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Docker daemon address
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="keyMaterial")
    def key_material(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        PEM-encoded content of Docker client private key
        """
        return pulumi.get(self, "key_material")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:docker/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

